/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.CheckUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.CheckCreateTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.computing.util.BatchProcessHelper;
import org.apache.commons.collections.CollectionUtils;

public class AccountMulTransactionUpgradeService
extends AbstractUpgradeService {
    private Set<DynamicObject> accountMulData;
    private Set<DynamicObject> auditTrailData;
    private Set<DynamicObject> checkRecordData;

    public AccountMulTransactionUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    protected void readyUpgradeData() {
        this.readyCheckRecordProcess();
    }

    @Override
    protected void saveData() {
        this.readyAccountMulData();
        if (this.accountMulData != null && this.accountMulData.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])this.accountMulData.toArray(new DynamicObject[0]));
        }
        this.readyAuditTrailData();
        if (this.auditTrailData != null && this.auditTrailData.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])this.auditTrailData.toArray(new DynamicObject[0]));
        }
        if (this.checkRecordData != null && this.checkRecordData.size() > 0) {
            BatchProcessHelper.batchConsume(new ArrayList<DynamicObject>(this.checkRecordData), (int)10000, list -> {
                DynamicObject[] savedDys = list.toArray(new DynamicObject[0]);
                SaveServiceHelper.update((DynamicObject[])savedDys);
            });
        }
    }

    @Override
    public void afterSaveData() {
        CheckUpgradeService.upgradeCheck(this.context.getModelId());
    }

    private void readyAccountMulData() {
        QFilter qf = new QFilter("model", "=", (Object)this.context.getModelId());
        DynamicObject[] checkTmpls = BusinessDataServiceHelper.load((String)"bcm_checktmpl", (String)"entryentity.account, entryentity.account0, entryentity.elim_account, entryentity.elim_account0", (QFilter[])new QFilter[]{qf});
        this.accountMulData = new HashSet<DynamicObject>(16);
        for (DynamicObject checkTmpl : checkTmpls) {
            DynamicObjectCollection entries = checkTmpl.getDynamicObjectCollection("entryentity");
            boolean isUpdate = false;
            for (DynamicObject entry : entries) {
                DynamicObject elim_account0;
                DynamicObjectCollection elim_account;
                DynamicObject account0;
                DynamicObjectCollection account = entry.getDynamicObjectCollection("account");
                if (account.size() == 0 && (account0 = entry.getDynamicObject("account0")) != null) {
                    DynamicObject addNew = account.addNew();
                    addNew.set("pkid", (Object)GlobalIdUtil.genGlobalLongId());
                    addNew.set("fbasedataid", (Object)account0);
                    isUpdate = true;
                }
                if ((elim_account = entry.getDynamicObjectCollection("elim_account")).size() != 0 || (elim_account0 = entry.getDynamicObject("elim_account0")) == null) continue;
                DynamicObject addNew = elim_account.addNew();
                addNew.set("pkid", (Object)GlobalIdUtil.genGlobalLongId());
                addNew.set("fbasedataid", (Object)elim_account0);
                isUpdate = true;
            }
            if (!isUpdate) continue;
            this.accountMulData.add(checkTmpl);
        }
    }

    private void readyAuditTrailData() {
        QFilter qf = new QFilter("model", "=", (Object)this.context.getModelId());
        Map checkTmpls = BusinessDataServiceHelper.loadFromCache((String)"bcm_checktmpl", (QFilter[])new QFilter[]{qf});
        QFilter dimQf = new QFilter("number", "=", (Object)"AuditTrail");
        DynamicObject dimension = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_dimension", (QFilter[])new QFilter[]{qf, dimQf});
        QFilter attotalQf = new QFilter("number", "=", (Object)"ATTotal");
        DynamicObject attotalDyn = QueryServiceHelper.queryOne((String)"bcm_audittrialmembertree", (String)"id", (QFilter[])new QFilter[]{qf, attotalQf});
        QFilter autojournalQf = new QFilter("number", "=", (Object)"AutoJournal");
        DynamicObject autojournalQfDyn = QueryServiceHelper.queryOne((String)"bcm_audittrialmembertree", (String)"id", (QFilter[])new QFilter[]{qf, autojournalQf});
        if (attotalDyn == null || autojournalQfDyn == null) {
            return;
        }
        this.auditTrailData = new HashSet<DynamicObject>(16);
        for (DynamicObject checkTmpl : checkTmpls.values()) {
            DynamicObjectCollection detailscopes;
            DynamicObjectCollection entries = checkTmpl.getDynamicObjectCollection("entryentity");
            boolean isHas = false;
            for (DynamicObject entry : entries) {
                detailscopes = entry.getDynamicObjectCollection("detailscope");
                for (DynamicObject detail : detailscopes) {
                    if (!"audittrail".equals(detail.get("sign"))) continue;
                    isHas = true;
                    break;
                }
                if (!isHas) continue;
                break;
            }
            if (isHas) continue;
            for (DynamicObject entry : entries) {
                detailscopes = entry.getDynamicObjectCollection("detailscope");
                DynamicObject audittrailDyn = detailscopes.addNew();
                audittrailDyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                audittrailDyn.set("seq", (Object)detailscopes.size());
                audittrailDyn.set("dimension", (Object)dimension.getLong("id"));
                audittrailDyn.set("scope", (Object)10);
                audittrailDyn.set("memberid", (Object)attotalDyn.getLong("id"));
                audittrailDyn.set("sign", (Object)"audittrail");
                DynamicObjectCollection elimdetailscopes = entry.getDynamicObjectCollection("elimdetailscope");
                DynamicObject elimaudittrailDyn = elimdetailscopes.addNew();
                elimaudittrailDyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
                audittrailDyn.set("seq", (Object)elimdetailscopes.size());
                elimaudittrailDyn.set("elimdimension", (Object)dimension.getLong("id"));
                elimaudittrailDyn.set("elimscope", (Object)10);
                elimaudittrailDyn.set("elimmemberid", (Object)autojournalQfDyn.getLong("id"));
                elimaudittrailDyn.set("elimsign", (Object)"elimaudittrail");
            }
            this.auditTrailData.add(checkTmpl);
        }
    }

    private void readyCheckRecordProcess() {
        this.checkRecordData = new HashSet<DynamicObject>(16);
        String modelNum = MemberReader.findModelNumberById((Object)this.context.getModelId());
        QFilter qf = new QFilter("model", "=", (Object)this.context.getModelId());
        QFilter progressQf = new QFilter("number", "=", (Object)"ARPT");
        DynamicObject arptProcess = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id", (QFilter[])new QFilter[]{qf, progressQf});
        if (arptProcess == null) {
            return;
        }
        QFilter createTypeFilter = new QFilter("createtype", "!=", (Object)CheckCreateTypeEnum.CHECK_CREATE.value);
        List<String> processNums = Arrays.asList("ARPT", "Rpt");
        QFilter qfCheckRecord = new QFilter("process.number", "not in", processNums);
        qfCheckRecord.or(new QFilter("adjustnumber", "=", (Object)" "));
        qfCheckRecord.or(new QFilter("adjustnumber", "=", (Object)""));
        qfCheckRecord.or(new QFilter("adjustnumber", "is null", null));
        qfCheckRecord.or(new QFilter("mycvtmoney", "=", (Object)0).and("opcvtmoney", "=", (Object)0));
        DynamicObject query = QueryServiceHelper.queryOne((String)"bcm_checkrecord", (String)"count(*) as num", (QFilter[])new QFilter[]{qf, createTypeFilter, qfCheckRecord});
        BatchProcessHelper.pageConsume((int)query.getInt("num"), (int)999, index -> {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bcm_checkrecord", (String)"id,number,status,scene,year,period,adjustnumber,process,createtype,myentity,oppositeentity,cvtdifmoney,difference,entryentity.entrymycompany,entryentity.entrycompany,entryentity.entrymycvtmoney,entryentity.entryopcvtmoney,mycvtmoney,opcvtmoney,entryentity.dc,entryentity.entrydebit,entryentity.entrycredit,entryentity.entryorg,entryentity.entrymyaccount,entryentity.entryopaccount,entryentity.entrydebitaccout,entryentity.entrycreditaccout", (QFilter[])new QFilter[]{qf, createTypeFilter, qfCheckRecord}, (String)"createtime", (int)index, (int)999);
            if (dynamicObjects != null && dynamicObjects.length > 0) {
                QFBuilder sourceQF = new QFBuilder();
                sourceQF.add("model", "=", (Object)this.context.getModelId());
                sourceQF.add("groupnum", "in", Arrays.stream(dynamicObjects).map(e -> e.getString("number")).collect(Collectors.toSet()));
                DynamicObjectCollection objects = QueryServiceHelper.query((String)"bcm_rptadjustdata", (String)"id,year.id,period.id,scenario.id,adjust.number,groupnum", (QFilter[])sourceQF.toArray());
                Map<String, String> adjustNumMap = objects.stream().collect(Collectors.toMap(k -> k.getLong("year.id") + "&" + k.getLong("period.id") + "&" + k.getLong("scenario.id") + "&" + k.getString("groupnum"), v -> v.getString("adjust.number"), (a, b) -> b));
                for (DynamicObject e2 : dynamicObjects) {
                    e2.set("process", (Object)arptProcess.getLong("id"));
                    e2.set("createtype", (Object)CheckCreateTypeEnum.CHECKADJUST_CREATE.value);
                    e2.set("cvtdifmoney", (Object)e2.getBigDecimal("difference"));
                    this.dealadjustNumber(e2, adjustNumMap);
                    DynamicObjectCollection entryentity = e2.getDynamicObjectCollection("entryentity");
                    if (this.isDealEntryData(e2, entryentity)) {
                        DynamicObject entry = (DynamicObject)entryentity.get(0);
                        if (StringUtils.isEmpty((String)entry.getString("entrymycompany.number"))) {
                            e2.set("myentity", (Object)entry.getLong("entryorg.id"));
                        } else {
                            IDNumberTreeNode myEntityNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)entry.getString("entrymycompany.number"));
                            e2.set("myentity", (Object)myEntityNode.getId());
                        }
                        IDNumberTreeNode opEntityNode = MemberReader.findEntityMemberByNum((String)modelNum, (String)entry.getString("entrycompany.number"));
                        e2.set("oppositeentity", (Object)opEntityNode.getId());
                        this.dealCvtMoney(e2, entryentity, entry.getString("entrycompany.number"));
                    }
                    this.checkRecordData.add(e2);
                }
            }
        });
    }

    private boolean isDealEntryData(DynamicObject rec, DynamicObjectCollection entryentity) {
        if (CollectionUtils.isEmpty((Collection)entryentity)) {
            return false;
        }
        long opEntityId = rec.getLong("oppositeentity.id");
        DynamicObject entry = (DynamicObject)entryentity.get(0);
        return opEntityId == 0L || entry.getLong("entryopaccount.id") == 0L && entry.getLong("entrymyaccount.id") == 0L;
    }

    private void dealadjustNumber(DynamicObject e, Map<String, String> adjustNumMap) {
        String key;
        String num;
        if (2 == e.getInt("status") && StringUtils.isNotEmpty((String)(num = adjustNumMap.get(key = e.getLong("year.id") + "&" + e.getLong("period.id") + "&" + e.getLong("scene.id") + "&" + e.getString("number"))))) {
            e.set("adjustnumber", (Object)num);
        }
    }

    private void dealCvtMoney(DynamicObject e, DynamicObjectCollection entryentity, String oppEntityNum) {
        BigDecimal absum = BigDecimal.ZERO;
        BigDecimal basum = BigDecimal.ZERO;
        for (DynamicObject entry : entryentity) {
            BigDecimal entrycredit;
            BigDecimal entrydebit = entry.getBigDecimal("entrydebit") == null ? BigDecimal.ZERO : entry.getBigDecimal("entrydebit");
            BigDecimal bigDecimal = entrycredit = entry.getBigDecimal("entrycredit") == null ? BigDecimal.ZERO : entry.getBigDecimal("entrycredit");
            if (BigDecimal.ZERO.compareTo(entrydebit) == 0 && BigDecimal.ZERO.compareTo(entrycredit) == 0) continue;
            if (Objects.equals(entry.getString("entrycompany.number"), oppEntityNum)) {
                if (BigDecimal.ZERO.compareTo(entrydebit) != 0) {
                    absum = absum.subtract(entrydebit);
                    entry.set("entrymyaccount", (Object)entry.getLong("entrydebitaccout.id"));
                    entry.set("entrymycvtmoney", (Object)entrydebit);
                    continue;
                }
                absum = absum.add(entrycredit);
                entry.set("entrymyaccount", (Object)entry.getLong("entrycreditaccout.id"));
                entry.set("entrymycvtmoney", (Object)entrycredit);
                continue;
            }
            if (BigDecimal.ZERO.compareTo(entrydebit) != 0) {
                basum = basum.subtract(entrydebit);
                entry.set("entryopaccount", (Object)entry.getLong("entrydebitaccout.id"));
                entry.set("entryopcvtmoney", (Object)entrydebit);
                continue;
            }
            basum = basum.add(entrycredit);
            entry.set("entryopaccount", (Object)entry.getLong("entrycreditaccout.id"));
            entry.set("entryopcvtmoney", (Object)entrycredit);
        }
        e.set("mycvtmoney", (Object)absum);
        e.set("opcvtmoney", (Object)basum);
    }
}

