/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.ThrowableHelper;

public class AccountOffsetUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        List<Pair<Long, String>> allModels = this.getCmAndRptModel();
        if (allModels.isEmpty()) {
            return this.success();
        }
        String sql = "select b.fid ,a.faccountpart from t_bcm_structofaccount b left join t_bcm_structofaccount a on b.fcopyfrom=a.fid where b.fmodelid = ? and b.fstoragetype='3' and exists (select 1 from  t_bcm_structofaccount c where b.fcopyfrom=c.fid and b.faccountpart != c.faccountpart)";
        String update = "update t_bcm_structofaccount set faccountpart = ? where fid = ?";
        allModels.forEach(m -> {
            try {
                ArrayList paramsList = new ArrayList(16);
                DB.query((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{m.p1}, rs -> {
                    while (rs.next()) {
                        paramsList.add(new Object[]{rs.getLong("faccountpart"), rs.getLong("fid")});
                    }
                    return paramsList;
                });
                if (!paramsList.isEmpty()) {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)update, paramsList);
                }
            }
            catch (Exception e) {
                this.log.error(String.format("AccountOffsetUpgradeService - model: %s message: %s", m.p2, ThrowableHelper.toString((Exception)e)));
            }
        });
        return this.success();
    }
}

