/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.login.utils.ErrorCodeUtils;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class AddExtendPreDataUpgradeService
extends BcmUpgradeService {
    private static final String FI_BCM_BUSINESS = "fi-bcm-business";
    private static final String LOCALE_ID = "zh_CN";

    private String getEnumItemName() {
        return ResManager.loadKDString((String)"\u662f\u5426\u5dee\u989d", (String)"AddExtendPreDataUpgradeService_0", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
    }

    private String getEnumValueYes() {
        return ResManager.loadKDString((String)"\u662f", (String)"AddExtendPreDataUpgradeService_1", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
    }

    private String getEnumValueNo() {
        return ResManager.loadKDString((String)"\u5426", (String)"AddExtendPreDataUpgradeService_2", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
    }

    private String getExtendFieldName() {
        return ResManager.loadKDString((String)"\u4ea4\u6613\u5dee\u989d\u9879", (String)"AddExtendPreDataUpgradeService_3", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
    }

    private String getDescripttion() {
        return ResManager.loadKDString((String)"\u7cfb\u7edf\u9884\u7f6e", (String)"AddExtendPreDataUpgradeService_4", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
    }

    @Override
    public Map<String, Object> upgrade() {
        try {
            String sql0 = "select fid, fmodelid from t_bcm_dimension_ext";
            DataSet dsDims = DB.queryDataSet((String)"select_get_all_extends_dim", (DBRoute)DBRoute.of((String)"bcm"), (String)sql0, null);
            String longnumber = "Extends!INTR!INTR_000";
            String sql1 = "select fmodelid from t_bcm_structofextend where flongnumber = ?";
            DataSet ds = DB.queryDataSet((String)"select_getPreINTR_000", (DBRoute)DBRoute.of((String)"bcm"), (String)sql1, (Object[])new Object[]{longnumber});
            HashSet<Long> ids = new HashSet<Long>(16);
            if (ds != null && ds.hasNext()) {
                while (ds.hasNext()) {
                    ids.add(ds.next().getLong("fmodelid"));
                }
            }
            String sql7 = "select fseq,fmodelid from t_bcm_structofextend";
            DataSet dsSeqs = DB.queryDataSet((String)"select_dseq_all_dim", (DBRoute)DBRoute.of((String)"bcm"), (String)sql7, null);
            HashMap<Long, List> dseqMap = new HashMap<Long, List>(16);
            if (dsSeqs != null && dsSeqs.hasNext()) {
                while (dsSeqs.hasNext()) {
                    Row next = dsSeqs.next();
                    dseqMap.computeIfAbsent(next.getLong("fmodelid"), k -> new ArrayList(16)).add(next.getInteger("fseq"));
                }
            }
            String sql8 = "select fmodelid,ffieldmapped from t_bcm_structofextend where flongnumber like ?";
            DataSet dsFileds = DB.queryDataSet((String)"select_ffieldmapped_all_dim", (DBRoute)DBRoute.of((String)"bcm"), (String)sql8, (Object[])new Object[]{"Extends!INTR!INTR_%"});
            HashMap fieldmapps = new HashMap(32);
            if (dsFileds != null && dsFileds.hasNext()) {
                while (dsFileds.hasNext()) {
                    Row next = dsFileds.next();
                    fieldmapps.computeIfAbsent(next.getLong("fmodelid"), k -> new ArrayList(16)).add(next.getString("ffieldmapped"));
                }
            }
            for (Map.Entry entry : fieldmapps.entrySet()) {
                Long k2 = (Long)entry.getKey();
                List value = (List)entry.getValue();
                value = value.stream().filter(x -> x.contains("textext")).collect(Collectors.toList());
                fieldmapps.put(k2, value);
            }
            String sql9 = "select fid,fmodelid from t_bcm_structofextend where flongnumber = ?";
            DataSet dataSet = DB.queryDataSet((String)"select_parentid_all_dim", (DBRoute)DBRoute.of((String)"bcm"), (String)sql9, (Object[])new Object[]{"Extends!INTR"});
            HashMap<Long, Long> parentMaps = new HashMap<Long, Long>(32);
            if (dataSet != null && dataSet.hasNext()) {
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    parentMaps.put(next.getLong("fmodelid"), next.getLong("fid"));
                }
            }
            String sql2 = "insert into t_bcm_enumitem (fid,fname,fdatatype,fdimensionid,fmodelid,fissysenumitem) values (?,?,?,?,?,?)";
            String sql2l = "insert into t_bcm_enumitem_l (fpkid,fid,flocaleid,fname) values (?,?,?,?)";
            String sql3 = "insert into t_bcm_enumValue (fid,fname,fenumvalue,fdatatype,fdimensionid,fmodelid,fenumitemid,fissysenumvalue) values (?,?,?,?,?,?,?,?)";
            String sql3l = "insert into t_bcm_enumvalue_l (fpkid,fid,flocaleid,fenumvalue) values (?,?,?,?)";
            String sql4 = "insert into t_bcm_membofextend (fid,fname,fnumber,fsimplename,fdimensionid,fmodelid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fstatus,fenable) values (?,?,?,?,?,?,?,?,?,?,?,?)";
            String sql4l = "insert into t_bcm_membofextend_l (fpkid,fid,flocaleid,fname,fsimplename) values (?,?,?,?,?)";
            String sql5 = "insert into t_bcm_structofextend (fid,fname,fnumber,fdescription,fmodelid,fisleaf,flevel,fissysmember,fdimensionid,fmemberid,fcreatorid,fcreatetime,fmodifierid,fmodifytime,fstoragetype,fdatatype,fvalue,fexchange,fentryrate,fstatus,fenable,fseq,ffieldmapped,flongnumber,fsimplename,fparentid,fdisablerid,fdpropertyid1,fdpropertyid2,fdpropertyid3,fdpropertyid4,fdpropertyid5,fdpropertyid6,fdpropertyid7,fdpropertyid8,fdpropertyid9,fdpropertyid10,fcopyfrom) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            String sql5l = "insert into t_bcm_structofextend_l (fpkid,fid,flocaleid,fname,fdescription,fsimplename) values (?,?,?,?,?,?)";
            HashMap<String, List> sql2params = new HashMap<String, List>(16);
            ArrayList<Object[]> enumitemPars = new ArrayList<Object[]>(32);
            ArrayList<Object[]> enumitemlPars = new ArrayList<Object[]>(32);
            ArrayList<Object[]> enumValuePars = new ArrayList<Object[]>(32);
            ArrayList<Object[]> enumValuelPars = new ArrayList<Object[]>(32);
            ArrayList<Object[]> memPars = new ArrayList<Object[]>(32);
            ArrayList<Object[]> memlPars = new ArrayList<Object[]>(32);
            ArrayList<Object[]> treePars = new ArrayList<Object[]>(32);
            ArrayList<Object[]> treelPars = new ArrayList<Object[]>(32);
            String[] names = new String[]{this.getEnumValueYes(), this.getEnumValueNo()};
            Date date = new Date();
            String enumItemName = this.getEnumItemName();
            while (dsDims != null && dsDims.hasNext()) {
                Optional<Integer> max;
                Row next = dsDims.next();
                long dimId = next.getLong("fid");
                long modelId = next.getLong("fmodelid");
                if (ids.contains(modelId)) continue;
                Long enumitemId = GlobalIdUtil.genGlobalLongId();
                Object[] params2 = new Object[]{enumitemId, enumItemName, "3", dimId, modelId, 1};
                enumitemPars.add(params2);
                String enumitem_lid = GlobalIdUtil.genStringId();
                Object[] params2_l = new Object[]{enumitem_lid, enumitemId, LOCALE_ID, enumItemName};
                enumitemlPars.add(params2_l);
                for (int i = 0; i < 2; ++i) {
                    Object[] paramArr = new Object[]{GlobalIdUtil.genGlobalLongId(), enumItemName, names[i], "3", dimId, modelId, enumitemId, 1};
                    enumValuePars.add(paramArr);
                    String enumvalue_lid = GlobalIdUtil.genStringId();
                    Object[] params3_l = new Object[]{enumvalue_lid, paramArr[0], LOCALE_ID, names[i]};
                    enumValuelPars.add(params3_l);
                }
                long currUserId = 1L;
                Long memId = GlobalIdUtil.genGlobalLongId();
                Object[] params4 = new Object[]{memId, this.getExtendFieldName(), "INTR_000", this.getExtendFieldName(), dimId, modelId, currUserId, date, currUserId, date, "C", "1"};
                memPars.add(params4);
                String mem_lid = GlobalIdUtil.genStringId();
                Object[] params4_l = new Object[]{mem_lid, memId, LOCALE_ID, this.getExtendFieldName(), this.getExtendFieldName()};
                memlPars.add(params4_l);
                Integer dseq = 0;
                List seqs = (List)dseqMap.get(modelId);
                if (seqs == null || seqs.isEmpty() || !(max = seqs.stream().max(Comparator.comparing(x -> x))).isPresent()) continue;
                dseq = max.get() + 1;
                String fieldmapped = "";
                List fieldmappeds = (List)fieldmapps.get(modelId);
                if (fieldmappeds == null || fieldmappeds.isEmpty()) continue;
                List collects = fieldmappeds.stream().map(x -> Integer.parseInt(x.substring(7))).collect(Collectors.toList());
                Integer maxNum = (Integer)collects.stream().reduce(collects.get(0), Integer::max);
                fieldmapped = "textext" + (maxNum + 1);
                Long parentid = (Long)parentMaps.get(modelId);
                if (parentid == null || parentid == 0L) continue;
                Long memTreeId = GlobalIdUtil.genGlobalLongId();
                Object[] paramMemTree = new Object[]{memTreeId, this.getExtendFieldName(), "INTR_000", this.getExtendFieldName(), modelId, "1", 3, 1, dimId, memId, currUserId, date, currUserId, date, StorageTypeEnum.STORAGE.getOIndex(), "6", enumitemId, "0", "0", "C", "1", dseq, fieldmapped, "Extends!INTR!INTR_000", this.getExtendFieldName(), parentid, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                treePars.add(paramMemTree);
                String tree_lid = GlobalIdUtil.genStringId();
                Object[] params5_l = new Object[]{tree_lid, memTreeId, LOCALE_ID, this.getExtendFieldName(), this.getExtendFieldName(), this.getExtendFieldName()};
                treelPars.add(params5_l);
            }
            sql2params.put(sql2, enumitemPars);
            sql2params.put(sql2l, enumitemlPars);
            sql2params.put(sql3, enumValuePars);
            sql2params.put(sql3l, enumValuelPars);
            sql2params.put(sql4, memPars);
            sql2params.put(sql4l, memlPars);
            sql2params.put(sql5, treePars);
            sql2params.put(sql5l, treelPars);
            try (TXHandle tx = TX.required((String)"AddExtendPreDataUpgradeService_save_predata");){
                try {
                    sql2params.forEach((k, v) -> {
                        if (v != null && !v.isEmpty()) {
                            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)k, (List)v);
                        }
                    });
                }
                catch (Exception e) {
                    tx.markRollback();
                    throw new KDBizException((Throwable)e, ErrorCodeUtils.getSystemErrorCode((String)("Failed to save predata: " + e.getMessage())), new Object[0]);
                }
            }
            this.updateExtendsModel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return super.upgrade();
    }

    private void updateExtendsModel() {
        DataSet ds2 = DB.queryDataSet((String)"update_getINTR_000ID", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid, fmodelid from t_bcm_structofextend where fnumber = 'INTR_000'", null);
        HashMap idMap = Maps.newHashMapWithExpectedSize((int)16);
        while (ds2 != null && ds2.hasNext()) {
            Row row = ds2.next();
            Long id = row.getLong("fid");
            Long modelId = row.getLong("fmodelid");
            idMap.put(modelId, id);
        }
        DataSet ds = DB.queryDataSet((String)"update_getINTR_CONSOLExtendModel", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid, fmodelid from t_bcm_extendsmodel where fnumber = 'INTR_CONSOL'", null);
        ArrayList<Object[]> params = new ArrayList<Object[]>(32);
        while (ds != null && ds.hasNext()) {
            DataSet ds3;
            Row row = ds.next();
            Long id = row.getLong("fid");
            Long modelId = row.getLong("fmodelid");
            Long fieldID = (Long)idMap.get(modelId);
            if (fieldID == null || (ds3 = DB.queryDataSet((String)"update_getINTR_000xtendModel", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid from t_bcm_extmodelfield where fextmodelid = ? and fextfield = ?", (Object[])new Object[]{id, fieldID})) != null && ds3.hasNext()) continue;
            Object[] param = new Object[]{GlobalIdUtil.genGlobalLongId(), id, fieldID, 0};
            params.add(param);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)"insert into t_bcm_extmodelfield(fid,fextmodelid,fextfield,fseq) values(?,?,?,?)", params);
        DataSet ds4 = DB.queryDataSet((String)"update_getINTR_CONSOLExtendModel", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid from t_bcm_extendsmodel where fnumber in ('INTR_CONSOL','INTR_SALE','INTR_PURCHASE') and fdescription = ' '", null);
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)16);
        while (ds4 != null && ds4.hasNext()) {
            ids.add(ds4.next().get("fid"));
        }
        if (ids.size() > 0) {
            SQLBuilder4RDB updateSql = new SQLBuilder4RDB();
            updateSql.append("update t_bcm_extendsmodel set fdescription = '").append(this.getDescripttion()).append("' where fid in (").append(Joiner.on((String)",").join((Iterable)ids)).append(")");
            DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql.toString());
        }
    }
}

