/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class AddModelFilterUpgradeService
extends BcmUpgradeService {
    private static final String FI_BCM_BUSINESS = "fi-bcm-business";
    private static final List<Tuple<String, MultiLangEnumBridge, Long>> MULTI_LANG_MAPPER = new ArrayList<Tuple<String, MultiLangEnumBridge, Long>>(2);

    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"AddModelFilterUpgradeService");){
            try {
                this.deleteAllData();
                this.insertMainEntityData();
                this.insertMultiTableData();
            }
            catch (Throwable e) {
                tx.markRollback();
                this.log.error("AddModelFilterUpgradeService error\uff1a" + e.getMessage(), e);
                throw new KDBizException(e.getMessage());
            }
        }
        return super.upgrade();
    }

    private void insertMultiTableData() {
        Lang[] allLang = Lang.values();
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        for (Tuple<String, MultiLangEnumBridge, Long> tuple : MULTI_LANG_MAPPER) {
            Long fid = (Long)tuple.p3;
            MultiLangEnumBridge multi = (MultiLangEnumBridge)tuple.p2;
            String description = multi.getDescription();
            String resourceID = multi.getResourceID();
            String systemType = multi.getSystemType();
            for (Lang lang : allLang) {
                String promptWordCN = PromptWordCacheNew.getPromptWord((String)description, (String)resourceID, (Lang)lang, (String)systemType, (Object[])new Object[0]);
                if (!Objects.nonNull(promptWordCN)) continue;
                Object[] param = new Object[]{GlobalIdUtil.genStringId(), fid, lang.toString(), promptWordCN};
                params.add(param);
            }
        }
        String multiSql = "insert into t_bcm_modelfiltermetaname_l (fpkid,fid,flocaleid,fname) values (?,?,?,?)";
        if (params.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)multiSql, params);
        }
    }

    private void insertMainEntityData() {
        String sql = "insert into t_bcm_modelfiltermetaname (fid, fnumber, fname, fenable, fcreatorid, fmodifierid, fcreatetime, fmodifytime) values (?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>(16);
        Date date = new Date();
        String fname1 = ResManager.loadKDString((String)"\u5404\u79cd\u72b6\u6001\u503c", (String)"AddModelFilterMetaDataUpgradeService_0", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
        long creatorid = 1L;
        Object[] params1 = new Object[]{AddModelFilterUpgradeService.MULTI_LANG_MAPPER.get((int)0).p3, "bcm_status", fname1, "1", creatorid, creatorid, date, date};
        String fname2 = ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236\u5b9e\u4f53", (String)"AddModelFilterMetaDataUpgradeService_1", (String)FI_BCM_BUSINESS, (Object[])new Object[0]);
        Object[] params2 = new Object[]{AddModelFilterUpgradeService.MULTI_LANG_MAPPER.get((int)1).p3, "bcm_reportentity", fname2, "1", creatorid, creatorid, date, date};
        params.add(params1);
        params.add(params2);
        if (params.size() != 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)sql, params);
        }
    }

    private void deleteAllData() {
        String delSql = "delete from t_bcm_modelfiltermetaname";
        String delSql_l = "delete from t_bcm_modelfiltermetaname_l";
        DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)delSql);
        DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)delSql_l);
    }

    static {
        MULTI_LANG_MAPPER.add((Tuple<String, MultiLangEnumBridge, Long>)Tuple.create((Object)"bcm_status", (Object)new MultiLangEnumBridge("\u5404\u79cd\u72b6\u6001\u503c", "AddModelFilterMetaDataUpgradeService_0", FI_BCM_BUSINESS), (Object)GlobalIdUtil.genGlobalLongId()));
        MULTI_LANG_MAPPER.add((Tuple<String, MultiLangEnumBridge, Long>)Tuple.create((Object)"bcm_reportentity", (Object)new MultiLangEnumBridge("\u62a5\u8868\u7f16\u5236\u5b9e\u4f53", "AddModelFilterMetaDataUpgradeService_1", FI_BCM_BUSINESS), (Object)GlobalIdUtil.genGlobalLongId()));
    }
}

