/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;

public class AdjustPeriodUpgradeService
extends BcmUpgradeService {
    WatchLogger logger = BcmLogFactory.getWatchLogInstance(AdjustPeriodUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        List<Pair<Long, String>> allModels = this.getCmAndRptModel();
        if (allModels.isEmpty()) {
            return this.success();
        }
        this.updateRelatedNumber();
        allModels.forEach(m -> {
            try {
                QFilter filter1 = new QFilter("model", "=", m.p1);
                QFilter filter2 = new QFilter("level", "=", (Object)3);
                DynamicObjectCollection years = QueryServiceHelper.query((String)"bcm_fymembertree", (String)"id,number", (QFilter[])new QFilter[]{filter1, filter2}, (String)"number");
                if (years != null && years.size() > 0) {
                    StringBuilder sb = new StringBuilder();
                    years.forEach(y -> sb.append(",").append(y.getString("number")));
                    sb.append(",");
                    List<Map<String, Object>> ids = this.getAdjustPeriods((Long)m.p1);
                    ArrayList<Object[]> params = new ArrayList<Object[]>(20);
                    ids.forEach(id -> {
                        Object[] param = new Object[]{sb.toString(), id.get("id")};
                        params.add(param);
                    });
                    this.updateUseYear(params);
                }
            }
            catch (Exception e) {
                this.log.error(String.format("AdjustPeriodUpgradeService - model: %s message: %s", m.p2, e.getMessage()));
            }
        });
        return this.success();
    }

    private List<Map<String, Object>> getAdjustPeriods(long modelId) {
        String sql = "select b.fid,a.fnumber from t_bcm_structofperiod a join t_bcm_structofperiod_s b on b.fid=a.fid where a.fmodelid = ? and b.frelatednumber='M_M12' and b.fuseyear = ' '";
        return (List)DB.query((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{modelId}, rs -> {
            ArrayList result = new ArrayList(10);
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>(10);
                map.put("id", rs.getLong("fid"));
                map.put("number", rs.getString("fnumber"));
                result.add(map);
            }
            return result;
        });
    }

    private void updateUseYear(List<Object[]> params) {
        String updateSql = "update t_bcm_structofperiod_s  set fuseyear = ? where fid = ?";
        if (params != null && params.size() > 0) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql, params);
        }
    }

    private void updateRelatedNumber() {
        String updateSql = "update t_bcm_structofperiod_s set frelatednumber = 'M_M12',fisadjust = '1' where fid in(select fid from t_bcm_structofperiod p where fnumber in('M_M13','M_M14','M_M15','M_M16')) and frelatednumber = ' '";
        DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql);
    }
}

