/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import org.apache.commons.collections4.CollectionUtils;

public class AdjustTemplateUpgradeService
extends BcmUpgradeService {
    public Map<String, Object> upgradeTest(Long modelId) {
        List<Map<String, Object>> allAdjustTemplateList = this.getAllAdjustTemplate();
        if (CollectionUtils.isEmpty(allAdjustTemplateList)) {
            return Maps.newHashMap();
        }
        Map spreaddim = allAdjustTemplateList.stream().filter(recordMap -> StringUtils.isNotEmpty((String)((String)recordMap.get("spreaddim"))) && ((Long)recordMap.get("model")).longValue() != modelId.longValue()).findAny().orElseGet(() -> Maps.newHashMap());
        return this.upgradeStart(spreaddim.isEmpty() ? null : Lists.newArrayList((Object[])new Map[]{spreaddim}));
    }

    @Override
    public Map<String, Object> upgrade() {
        return this.upgradeStart(this.getAllAdjustTemplate());
    }

    private Map<String, Object> upgradeStart(List<Map<String, Object>> allAdjustTemplateList) {
        boolean exist = this.checkTableExist();
        if (exist) {
            this.log.info("start ");
            if (allAdjustTemplateList != null && allAdjustTemplateList.size() > 0) {
                for (Map<String, Object> recordMap : allAdjustTemplateList) {
                    String spreadDimStr = (String)recordMap.get("spreaddim");
                    if (StringUtils.isEmpty((String)spreadDimStr)) continue;
                    long fid = (Long)recordMap.get("id");
                    long model = (Long)recordMap.get("model");
                    String[] spreadDimArray = spreadDimStr.split(";");
                    List<String> spreadDimList = Arrays.asList(spreadDimArray);
                    List<Map<String, Object>> dimList = this.getAllDimByModel(model);
                    ArrayList<String> commonDimList = new ArrayList<String>(10);
                    HashMap<String, Long> dimNumberIdMap = new HashMap<String, Long>(dimList.size());
                    for (Map<String, Object> map : dimList) {
                        long dimId = (Long)map.get("id");
                        String dimNumber = (String)map.get("number");
                        if (!spreadDimList.contains(dimNumber)) {
                            commonDimList.add(dimNumber);
                        }
                        dimNumberIdMap.put(dimNumber, dimId);
                    }
                    this.insertCommonDimData(fid, commonDimList, dimNumberIdMap);
                    this.insertSpreadDimData(fid, spreadDimList, dimNumberIdMap);
                }
            }
            this.log.info("end ");
        }
        this.log.info("update adjust template complete");
        return this.success();
    }

    private void insertCommonDimData(long fid, List<String> commonDimList, Map<String, Long> dimNumberIdMap) {
        String insertSql = "insert into t_bcm_adjusttmpcomdim(fid,fentryid,fseq,fmemberid,fdimensionid) values(?,?,?,?,?)";
        ArrayList<Long> commonDimIdList = new ArrayList<Long>(10);
        if (commonDimList.size() > 0) {
            for (String number : commonDimList) {
                commonDimIdList.add(dimNumberIdMap.get(number));
            }
        }
        try {
            if (commonDimIdList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, this.packageDimEntry(fid, commonDimIdList));
            }
        }
        catch (Exception e) {
            this.log.error("insert t_bcm_adjusttmpcomdim exception:" + e.getMessage());
        }
    }

    private void insertSpreadDimData(long fid, List<String> spreadDimList, Map<String, Long> dimNumberIdMap) {
        String insertSql = "insert into t_bcm_adjusttmpspreaddim(fid,fentryid,fseq,fmemberid,fdimensionid) values(?,?,?,?,?)";
        ArrayList<Long> spreadDimIdList = new ArrayList<Long>(10);
        if (spreadDimList.size() > 0) {
            for (String number : spreadDimList) {
                spreadDimIdList.add(dimNumberIdMap.get(number));
            }
        }
        try {
            if (spreadDimIdList.size() > 0) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, this.packageDimEntry(fid, spreadDimIdList));
            }
        }
        catch (Exception e) {
            this.log.error("insert t_bcm_adjusttmpspreaddim exception:" + e.getMessage());
        }
    }

    private boolean checkTableExist() {
        boolean commonFlag = DB.exitsTable((DBRoute)DBRoute.of((String)"bcm"), (String)"t_bcm_adjusttmpcomdim");
        if (!commonFlag) {
            this.log.error("table t_bcm_adjusttmpcomdim is not exist. ");
            return false;
        }
        boolean spreadFlag = DB.exitsTable((DBRoute)DBRoute.of((String)"bcm"), (String)"t_bcm_adjusttmpspreaddim");
        if (!spreadFlag) {
            this.log.error("table t_bcm_adjusttmpspreaddim is not exist. ");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getAllAdjustTemplate() {
        ArrayList<Map<String, Object>> allAdjustTemplate = new ArrayList<Map<String, Object>>(10);
        DataSet ds = DB.queryDataSet((String)"update_getAllAdjustTemplate", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid,fmodel,fspreaddim from t_bcm_adjusttemplate", null);
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                HashMap<String, Object> recordMap = new HashMap<String, Object>(16);
                recordMap.put("id", row.getLong("fid"));
                recordMap.put("model", row.getLong("fmodel"));
                recordMap.put("spreaddim", row.getString("fspreaddim"));
                allAdjustTemplate.add(recordMap);
            }
        }
        catch (Exception e) {
            this.log.error("get all adjust template fail:" + e.getMessage());
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (Exception e) {
                    this.log.error("get all adjust template db close fail:" + e.getMessage());
                }
            }
        }
        return allAdjustTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map<String, Object>> getAllDimByModel(long model) {
        ArrayList<Map<String, Object>> allDimInfo = new ArrayList<Map<String, Object>>(10);
        DataSet ds = DB.queryDataSet((String)"update_getAllDimByModel", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid,fnumber from t_bcm_dimension where fmodelid = ? ", (Object[])new Object[]{model});
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                HashMap<String, Object> recordMap = new HashMap<String, Object>(16);
                recordMap.put("id", row.getLong("fid"));
                recordMap.put("number", row.getString("fnumber"));
                allDimInfo.add(recordMap);
            }
        }
        catch (Exception e) {
            this.log.error("get model dim list fail:" + e.getMessage());
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (Exception e) {
                    this.log.error("query dim db close fail:" + e.getMessage());
                }
            }
        }
        return allDimInfo;
    }

    private List<Object[]> packageDimEntry(Long fid, List<Long> dimsId) {
        ArrayList<Object[]> ob = new ArrayList<Object[]>(10);
        if (dimsId == null) {
            return ob;
        }
        long[] ids = DB.genGlobalLongIds((int)dimsId.size());
        for (int i = 0; i < dimsId.size(); ++i) {
            Long dimID = dimsId.get(i);
            ArrayList<Number> ob1 = new ArrayList<Number>(10);
            ob1.add(fid);
            ob1.add(ids[i]);
            ob1.add(i + 1);
            ob1.add(0);
            ob1.add(dimID);
            ob.add(ob1.toArray(new Object[ob1.size()]));
        }
        return ob;
    }
}

