/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;

public class AnalyticsSolutionDataUpgradeService
extends AbstractUpgradeService {
    List<Object> pks;
    List<DynamicObject> uppdateDys;
    private String PAGE_DIM = "pagedim";
    private String ROW_DIM = "rowdim";
    private String COL_DIM = "coldim";

    public AnalyticsSolutionDataUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    void saveData() {
        if (this.uppdateDys != null && !this.uppdateDys.isEmpty()) {
            SaveServiceHelper.update((DynamicObject[])this.uppdateDys.toArray(new DynamicObject[this.uppdateDys.size()]));
        }
    }

    @Override
    protected void readyUpgradeData() {
        this.pks = QueryServiceHelper.queryPrimaryKeys((String)"bcm_analyticssoluentry", (QFilter[])new QFilter("model", "=", (Object)this.context.getModelId()).toArray(), null, (int)-1);
        if (!this.pks.isEmpty()) {
            DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])this.pks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bcm_analyticssoluentry"));
            this.uppdateDys = new ArrayList<DynamicObject>(dynamicObjects.length);
            for (DynamicObject object : dynamicObjects) {
                this.updateProcessAndCurrency(object);
            }
        }
    }

    private void updateProcessAndCurrency(DynamicObject object) {
        List<String> list = Arrays.asList(this.PAGE_DIM, this.ROW_DIM, this.COL_DIM);
        boolean flag = false;
        for (int i = 0; i < 3; ++i) {
            String rangStr = list.get(i);
            DynamicObjectCollection collection = object.getDynamicObjectCollection(rangStr);
            String str = "";
            String idStr = "";
            if (this.PAGE_DIM.equals(rangStr)) {
                str = "dimid";
                idStr = "menberid";
            }
            if (this.ROW_DIM.equals(rangStr)) {
                str = "rowdimid";
                idStr = "rowmenberid";
            }
            if (this.COL_DIM.equals(rangStr)) {
                str = "columndimid";
                idStr = "columnmenberid";
            }
            for (DynamicObject dynamicObject : collection) {
                String rowOrColMem = this.getRowOrColMem(dynamicObject, idStr, str);
                if (dynamicObject.getString(idStr).equalsIgnoreCase(rowOrColMem)) continue;
                dynamicObject.set(idStr, (Object)rowOrColMem);
                flag = true;
            }
        }
        if (flag) {
            object.set("updateuserid", (Object)Long.valueOf(RequestContext.get().getUserId()));
            object.set("updatetime", (Object)TimeServiceHelper.now());
            this.uppdateDys.add(object);
        }
    }

    private String getRowOrColMem(DynamicObject dynamicObject, String idStr, String str) {
        String s = dynamicObject.getString(idStr);
        if (StringUtils.isEmpty((String)s)) {
            return s;
        }
        DynamicObject object = dynamicObject.getDynamicObject(str);
        if (object == null) {
            return s;
        }
        String number = object.getString("number");
        if ("dimid".equalsIgnoreCase(str)) {
            s = this.updateId(Long.parseLong(s), number).toString();
        } else {
            String[] memList = s.split(",");
            boolean isOnlyOne = true;
            for (String mem : memList) {
                Long id;
                String[] temMem = mem.split(";");
                if (temMem.length <= 1 || (id = this.updateId(Long.parseLong(temMem[0]), number)) == Long.parseLong(temMem[0])) continue;
                if (isOnlyOne) {
                    s = s.replaceFirst(temMem[0], id.toString());
                    isOnlyOne = false;
                    continue;
                }
                s = s.replaceFirst("," + temMem[0] + ";" + temMem[1], "");
            }
        }
        return s;
    }

    private Long updateId(Long id, String number) {
        IDNumberTreeNode currencyMemberById;
        IDNumberTreeNode member = null;
        if ("Process".equalsIgnoreCase(number) && !QueryServiceHelper.exists((String)"bcm_processmembertree", (Object)id)) {
            member = MemberReader.findProcessMemberByNum((String)MemberReader.findModelNumberById((Object)this.context.getModelId()), (String)"EIRpt");
        }
        if ("Currency".equalsIgnoreCase(number) && (currencyMemberById = MemberReader.findCurrencyMemberById((String)MemberReader.findModelNumberById((Object)this.context.getModelId()), (Long)id)) != null && "PC".equalsIgnoreCase(currencyMemberById.getNumber())) {
            member = MemberReader.findCurrencyMemberByNum((String)MemberReader.findModelNumberById((Object)this.context.getModelId()), (String)"DC");
        }
        if (member != null) {
            id = member.getId();
        }
        return id;
    }
}

