/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.OrgCurrencyServiceHelper;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;

public class BaseDataConfigUpgradeService
extends AbstractUpgradeService {
    static String[] entityNames = new String[]{"bcm_accountmembertree", "bcm_changetypemembertree", "bcm_userdefinedmembertree", "bcm_scenemembertree"};

    public BaseDataConfigUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    void saveData() {
        long modelId = this.context.getModelId();
        this.changeEcToDcAtUserSelectTable(modelId);
        this.upgradeDataTypeForSomeDimension(modelId);
        OrgCurrencyServiceHelper.upgradeOrgChangeRdForModelId(modelId);
    }

    private void upgradeDataTypeForSomeDimension(long modelId) {
        for (String entityName : entityNames) {
            this.doUpgradeDataTypeForDimension(modelId, entityName);
        }
    }

    private void doUpgradeDataTypeForDimension(long modelId, String entityName) {
        DynamicObject[] dys;
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        QFilter parentQf = new QFilter("parent", "=", (Object)0L);
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)entityName, (String)"id, datatype", (QFilter[])new QFilter[]{modelQf, parentQf})) {
            dy.set("datatype", (Object)Character.valueOf('0'));
        }
        SaveServiceHelper.save((DynamicObject[])dys);
    }

    void changeEcToDcAtUserSelectTable(long modelId) {
        DynamicObject[] rds;
        long[] idOfEcAndDc = this.getEcAndDcIds(modelId);
        long ecId = idOfEcAndDc[0];
        long dcId = idOfEcAndDc[1];
        if (ecId == 0L || dcId == 0L) {
            return;
        }
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        QFilter ecQf = new QFilter("currency.id", "=", (Object)ecId);
        for (DynamicObject rd : rds = BusinessDataServiceHelper.load((String)"bcm_userselect", (String)"id, number, currency", (QFilter[])new QFilter[]{modelQf, ecQf})) {
            rd.set("currency.id", (Object)dcId);
        }
        if (rds.length > 0) {
            SaveServiceHelper.update((DynamicObject[])rds);
        }
    }

    private long[] getEcAndDcIds(long modelId) {
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        QFilter numberQf = new QFilter("number", "in", (Object)new String[]{"EC", "DC"});
        DynamicObjectCollection dys = QueryServiceHelper.query((String)"bcm_currencymembertree", (String)"id, number", (QFilter[])new QFilter[]{modelQf, numberQf});
        long ecId = 0L;
        long dcId = 0L;
        for (DynamicObject dy : dys) {
            if ("EC".equalsIgnoreCase(dy.getString("number"))) {
                ecId = dy.getLong("id");
                continue;
            }
            if (!"DC".equalsIgnoreCase(dy.getString("number"))) continue;
            dcId = dy.getLong("id");
        }
        return new long[]{ecId, dcId};
    }

    @Override
    protected void readyUpgradeData() {
    }
}

