/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.serviceHelper.UpgradeServiceHelper;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.ModelTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;

public abstract class BcmUpgradeService
implements IUpgradeService {
    protected WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, this.getClass());
    public static final String UR_SUCCESS = "success";
    public static final String UR_LOG = "log";
    public static final String UR_EL = "el";
    public static final String UR_ERRORINFO = "errorInfo";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            return new UpgradeResult(this.upgradeBefore());
        }
        catch (Throwable t) {
            return new UpgradeResult(this.fail(t));
        }
    }

    protected String getUpgradeType() {
        return "default_not_record";
    }

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        try {
            boolean isRecord;
            Pair<Long, String> recorded = null;
            String clzName = this.getClass().getSimpleName();
            boolean bl = isRecord = UpgradeServiceHelper.isExistTableAndField() && !Objects.equals(this.getUpgradeType(), "default_not_record");
            if (isRecord) {
                recorded = UpgradeServiceHelper.getNameByTypeClz(this.getUpgradeType(), clzName);
            }
            if (isRecord && Objects.equals(sqlFileName, recorded.p2)) {
                return new UpgradeResult(this.success());
            }
            UpgradeResult upgradeResult = new UpgradeResult(this.upgrade());
            if (isRecord && upgradeResult.isSuccess()) {
                UpgradeServiceHelper.recordInsertOrUpdate((Long)recorded.p1, this.getUpgradeType(), sqlFileName, clzName);
            }
            return upgradeResult;
        }
        catch (Throwable t) {
            return new UpgradeResult(this.fail(t));
        }
    }

    public Map<String, Object> upgradeBefore() {
        return this.success();
    }

    public Map<String, Object> upgrade() {
        return this.success();
    }

    public Map<String, Object> upgrade(Long id, String number) {
        return this.success();
    }

    protected Map<String, Object> success() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(UR_SUCCESS, true);
        String className = this.getClass().getName();
        result.put(UR_LOG, className + UR_SUCCESS);
        result.put(UR_EL, "");
        result.put(UR_ERRORINFO, "");
        return result;
    }

    protected Map<String, Object> fail(Throwable t) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        String logInfo = String.format("Upgrade error!\n%s", ThrowableHelper.toString((Throwable)t));
        result.put(UR_SUCCESS, false);
        result.put(UR_LOG, logInfo);
        result.put(UR_EL, ThrowableHelper.toString((Throwable)t));
        result.put(UR_ERRORINFO, t.getMessage());
        this.log.error(logInfo);
        return result;
    }

    protected List<Pair<Long, String>> queryBcmModel() {
        QFBuilder qf = new QFBuilder();
        qf.add("modeltype", "in", (Object)new String[]{ModelTypeEnum.cm.getValue(), ModelTypeEnum.cmbg.getValue()});
        String entityName = "bcm_model";
        ArrayList<Pair<Long, String>> ids = new ArrayList<Pair<Long, String>>(10);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)("QueryServiceHelper." + entityName), (String)entityName, (String)"id, number", (QFilter[])qf.toArray(), null);){
            ds.forEach(d -> ids.add(Pair.onePair((Object)d.getLong("id"), (Object)d.getString("number"))));
        }
        return ids;
    }

    protected List<Pair<Long, String>> getCmAndRptModel() {
        QFilter appFilter = new QFilter("reporttype", "in", Arrays.asList(ApplicationTypeEnum.CM.getOIndex(), ApplicationTypeEnum.RPT.getOIndex()));
        ArrayList<Pair<Long, String>> models = new ArrayList<Pair<Long, String>>(10);
        DynamicObjectCollection doc = QueryServiceHelper.query((String)"bcm_model", (String)"id,number", (QFilter[])new QFilter[]{appFilter});
        doc.forEach(d -> models.add(Pair.onePair((Object)d.getLong("id"), (Object)d.getString("number"))));
        return models;
    }
}

