/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class CHKUpgradeService
extends AbstractUpgradeService {
    DynamicObject[] setDys;
    String updateSql = "";

    public CHKUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    protected void saveData() {
        if (this.setDys != null) {
            SaveServiceHelper.save((DynamicObject[])this.setDys);
        }
        if (StringUtils.isNotEmpty((String)this.updateSql)) {
            DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)this.updateSql);
        }
    }

    @Override
    protected void readyUpgradeData() {
        QFilter bpFilter = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"CS", "Rpt", "IRpt", "EIRpt"}));
        QFilter typeFilter = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        DynamicObject[] bps = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,dimension.id,number", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.context.getModelId()), bpFilter, typeFilter});
        HashMap<String, DynamicObject> num2bp = new HashMap<String, DynamicObject>(2);
        long dim_bpid = 0L;
        for (DynamicObject bp : bps) {
            dim_bpid = bp.getLong("dimension.id");
            num2bp.put(bp.getString("number"), bp);
        }
        DynamicObject[] sets = BusinessDataServiceHelper.load((String)"bcm_chkformulasetting", (String)"leftformula,lformulatemp,rightformula,rformulatemp,vformula,chineseformula,fixdimtxt,memberrange.dimension,memberrange.memberid", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.context.getModelId())});
        String bcmStr = ResManager.loadKDString((String)"\u5408\u5e76\u62a5\u8868", (String)"CHKUpgradeService_0", (String)"fi-bcm-business", (Object[])new Object[0]);
        String reportAfterStr = ResManager.loadKDString((String)"\u62a5\u8868\u8c03\u6574\u540e", (String)"CHKUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        String rptStr = ResManager.loadKDString((String)"\u4e2a\u522b\u62a5\u8868", (String)"CHKUpgradeService_2", (String)"fi-bcm-business", (Object[])new Object[0]);
        String reportStr = ResManager.loadKDString((String)"\u62a5\u8868", (String)"CHKUpgradeService_3", (String)"fi-bcm-business", (Object[])new Object[0]);
        for (DynamicObject set : sets) {
            set.set("leftformula", (Object)set.getString("leftformula").replaceAll("\"BP.CS\"", "\"BP.RPT\""));
            set.set("lformulatemp", (Object)set.getString("lformulatemp").replaceAll("\"BP.CS\"", "\"BP.RPT\""));
            set.set("rightformula", (Object)set.getString("rightformula").replaceAll("\"BP.CS\"", "\"BP.RPT\""));
            set.set("rformulatemp", (Object)set.getString("rformulatemp").replaceAll("\"BP.CS\"", "\"BP.RPT\""));
            set.set("vformula", (Object)set.getString("vformula").replaceAll("\"BP.CS\"", "\"BP.RPT\""));
            set.set("chineseformula", (Object)set.getString("chineseformula").replaceAll(bcmStr, reportAfterStr));
            set.set("chineseformula", (Object)set.getString("chineseformula").replaceAll(rptStr, reportStr));
            set.set("fixdimtxt", (Object)set.getString("fixdimtxt").replaceAll(bcmStr, reportAfterStr));
            set.set("fixdimtxt", (Object)set.getString("fixdimtxt").replaceAll(rptStr, reportStr));
            for (DynamicObject d : set.getDynamicObjectCollection("memberrange")) {
                Long bp_cs_id = this.context.getDel_bps().get("CS");
                if (d.getLong("dimension.id") != dim_bpid || bp_cs_id == null || d.getLong("memberid") != bp_cs_id.longValue()) continue;
                d.set("memberid", num2bp.get("Rpt"));
            }
        }
        Long bp_cs_id = this.context.getDel_bps().get("CS");
        DynamicObject bp_irpt = (DynamicObject)num2bp.get("IRpt");
        Long bp_irpt_id = bp_irpt != null ? Long.valueOf(bp_irpt.getLong("id")) : this.context.getDel_bps().get("IRpt");
        DynamicObject eirptDy = (DynamicObject)num2bp.get("EIRpt");
        long eirptId = eirptDy.getLong("id");
        StringBuilder updateSqlBuilder = new StringBuilder("update t_bcm_status set fprocess = ");
        updateSqlBuilder.append(eirptId).append(" where fprocess in (");
        StringBuilder whereSql = new StringBuilder();
        if (bp_cs_id != null) {
            whereSql.append(bp_cs_id).append(",");
        } else if (bp_irpt_id > 0L) {
            whereSql.append(bp_irpt_id).append(",");
        }
        this.setDys = sets;
        if (whereSql.length() > 0) {
            this.updateSql = updateSqlBuilder.append(whereSql.substring(0, whereSql.length() - 1)).append(");").toString();
        }
    }
}

