/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.enums.DiffMethodEnum;
import kd.fi.bcm.common.enums.DiffModeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.LongUtil;
import kd.fi.bcm.fel.common.StringUtils;

public class CheckTmplDiffTypeUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        Set modelSet = this.queryBcmModel().stream().map(model -> (Long)model.p1).collect(Collectors.toSet());
        for (Long modelId : modelSet) {
            CheckTmplDiffTypeUpgradeService.updateCheckTmplDiffTypeAndLayout(modelId);
        }
        return this.success();
    }

    public static void updateCheckTmplDiffTypeAndLayout(Long modelId) {
        CheckTmplDiffTypeUpgradeService.updateCheckTmplDiffType(modelId);
        CheckTmplDiffTypeUpgradeService.updateCheckTmplLayout(modelId);
    }

    private static void updateCheckTmplDiffType(Long modelId) {
        ArrayList<Object[]> tmplParamList = new ArrayList<Object[]>(16);
        String updateSql = " update t_bcm_checktmpl set fdiffmode = ? ,fdiffmethod = ? ,fdiffmodeformula = ? where fid = ? ";
        try (DataSet ds = DB.queryDataSet((String)"updateCheckTmplDiffType", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid,fdiffmode,fdiffmethod,fcheckconfig,fdiffmodeformula  from t_bcm_checktmpl  where fmodelid  = ? ", (Object[])new Object[]{modelId});){
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Object[] tmplParam = CheckTmplDiffTypeUpgradeService.getCheckTmplParam(row);
                if (tmplParam != null) {
                    tmplParamList.add(tmplParam);
                }
                if (tmplParamList.size() != 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql, tmplParamList);
                tmplParamList.clear();
            }
        }
        if (!tmplParamList.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql, tmplParamList);
        }
    }

    private static Object[] getCheckTmplParam(Row row) {
        String checkconfig;
        Long id = row.getLong("fid");
        String diffmode = row.getString("fdiffmode");
        String diffmethod = row.getString("fdiffmethod") == null ? "" : row.getString("fdiffmethod");
        String diffmodeformula = row.getString("fdiffmodeformula");
        String string = checkconfig = row.getString("fcheckconfig") == null ? " " : row.getString("fcheckconfig");
        if (StringUtils.isEmpty((CharSequence)diffmethod.trim())) {
            if ((DiffModeEnum.BIG.getValue() + "").equals(diffmode) || (DiffModeEnum.SMALL.getValue() + "").equals(diffmode)) {
                diffmethod = DiffMethodEnum.DIFFITEM.getValue() + "";
            } else if ((DiffModeEnum.ABSBIG.getValue() + "").equals(diffmode) || (DiffModeEnum.ABSSMALL.getValue() + "").equals(diffmode)) {
                String string2 = diffmode = (DiffModeEnum.ABSBIG.getValue() + "").equals(diffmode) ? DiffModeEnum.BIG.getValue() + "" : DiffModeEnum.SMALL.getValue() + "";
                diffmethod = checkconfig.contains("8") ? DiffMethodEnum.ORDERLINE.getValue() + "" : DiffMethodEnum.MAXLINE.getValue() + "";
            } else if ((DiffModeEnum.DEBIT.getValue() + "").equals(diffmode) || (DiffModeEnum.CREDIT.getValue() + "").equals(diffmode)) {
                diffmethod = checkconfig.contains("8") ? DiffMethodEnum.ORDERLINE.getValue() + "" : DiffMethodEnum.MAXLINE.getValue() + "";
            } else if ((DiffModeEnum.MAPPINGBIG.getValue() + "").equals(diffmode)) {
                diffmode = DiffModeEnum.BIG.getValue() + "";
                diffmethod = DiffMethodEnum.MAXMAPPING.getValue() + "";
            } else {
                diffmethod = "0";
            }
            if (StringUtils.isNotEmpty((CharSequence)diffmodeformula)) {
                diffmodeformula = diffmodeformula.replace("CVT(\"diffmodetype@1\")", "CVT(\"diffmodetype@1.1\")");
                diffmodeformula = diffmodeformula.replace("CVT(\"diffmodetype@2\")", "CVT(\"diffmodetype@2.1\")");
                diffmodeformula = diffmodeformula.replace("CVT(\"diffmodetype@6\")", checkconfig.contains("8") ? "CVT(\"diffmodetype@6.3\")" : "CVT(\"diffmodetype@6.2\")");
                diffmodeformula = diffmodeformula.replace("CVT(\"diffmodetype@7\")", checkconfig.contains("8") ? "CVT(\"diffmodetype@7.3\")" : "CVT(\"diffmodetype@7.2\")");
                diffmodeformula = diffmodeformula.replace("CVT(\"diffmodetype@9\")", checkconfig.contains("8") ? "CVT(\"diffmodetype@9.3\")" : "CVT(\"diffmodetype@9.2\")");
                diffmodeformula = diffmodeformula.replace("CVT(\"diffmodetype@10\")", checkconfig.contains("8") ? "CVT(\"diffmodetype@10.3\")" : "CVT(\"diffmodetype@10.2\")");
                diffmodeformula = diffmodeformula.replace("CVT(\"diffmodetype@11\")", "CVT(\"diffmodetype@1.4\")");
            } else {
                diffmodeformula = " ";
            }
            return new Object[]{diffmode, diffmethod, diffmodeformula, id};
        }
        return null;
    }

    private static void updateCheckTmplLayout(Long modelId) {
        ArrayList<Object[]> layoutParamList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> datas = new ArrayList<Object[]>(16);
        String insertSql = "insert into t_bcm_checkrptlotentry(fentryid,fid,fseq,fcolumnnumber,fisshow,fsortorder)  values (?,?,?,?,?,?)";
        DataSet ds = DB.queryDataSet((String)"updateCheckTmplLayout", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fentryid,a.fid fid,fseq,fcolumnnumber,fisshow,fsortorder  from t_bcm_checkrptlotentry a,t_bcm_checkrptlot b  where a.fid = b.fid  and  fcolumnnumber in ('diffmode','diffmethod')  and  fmodelid  = ? ", (Object[])new Object[]{modelId});
        Object object = null;
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                datas.add(new Object[]{row.getLong("fentryid"), row.getLong("fid"), row.getInteger("fseq"), row.getString("fcolumnnumber"), row.getBoolean("fisshow"), row.getInteger("fsortorder")});
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (object != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        if (!datas.isEmpty()) {
            Map<Long, List<Object[]>> entryMap = datas.stream().collect(Collectors.groupingBy(e -> LongUtil.toLong((Object)e[1])));
            for (Map.Entry entry : entryMap.entrySet()) {
                Long id = (Long)entry.getKey();
                List dataList = (List)entry.getValue();
                if (dataList.size() == 1) {
                    Object[] r = (Object[])dataList.get(0);
                    layoutParamList.add(new Object[]{GlobalIdUtil.genGlobalLongId(), id, 0, "diffmethod", r[4], r[5]});
                }
                if (layoutParamList.size() != 1000) continue;
                DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, layoutParamList);
                layoutParamList.clear();
            }
            if (!layoutParamList.isEmpty()) {
                DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, layoutParamList);
            }
        }
    }
}

