/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;

public class CheckUpgradeService
extends BcmUpgradeService {
    public static void upgradeCheck(Long modelId) {
        DynamicObject[] load;
        QFilter qFilter = new QFilter("model", "=", (Object)modelId);
        Long dimensions = CheckUpgradeService.getDimensions(modelId);
        if (dimensions == 0L) {
            return;
        }
        for (DynamicObject dn : load = BusinessDataServiceHelper.load((String)"bcm_checktmpl", (String)String.join((CharSequence)",", EntityMetadataCache.getDataEntityType((String)"bcm_checktmpl").getAllFields().keySet()), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entryentity = dn.getDynamicObjectCollection("entryentity");
            entryentity.forEach(dy -> {
                DynamicObjectCollection detailscope = dy.getDynamicObjectCollection("detailscope");
                DynamicObjectCollection elimdetailscope = dy.getDynamicObjectCollection("elimdetailscope");
                if (!detailscope.stream().anyMatch(p -> "accounttree".equals(p.getString("sign")))) {
                    dy.getDynamicObjectCollection("account").forEach(p -> CheckUpgradeService.addAccount(p, detailscope, dimensions, ""));
                }
                if (!elimdetailscope.stream().anyMatch(p -> "elimaccounttree".equals(p.getString("elimsign")))) {
                    dy.getDynamicObjectCollection("elim_account").forEach(p -> CheckUpgradeService.addAccount(p, elimdetailscope, dimensions, "elim"));
                }
            });
        }
        SaveServiceHelper.save((DynamicObject[])load);
    }

    public static void addAccount(DynamicObject dn, DynamicObjectCollection dy, Long dimensions, String account) {
        DynamicObject fbasedataid = dn.getDynamicObject("fbasedataid");
        if (null != fbasedataid) {
            DynamicObject dynamicObject = dy.addNew();
            dynamicObject.set(account + "scope", (Object)"10");
            dynamicObject.set(account + "sign", (Object)(account + "accounttree"));
            dynamicObject.set(account + "memberid", (Object)fbasedataid.getLong("id"));
            dynamicObject.set(account + "dimension", (Object)dimensions);
        }
    }

    private static Long getDimensions(Long modelid) {
        QFilter qFilter = new QFilter("model", "=", (Object)modelid).and("number", "=", (Object)"Account");
        DynamicObject query = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])qFilter.toArray());
        return null == query ? 0L : query.getLong("id");
    }
}

