/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;

public class ChkAllocUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try {
            DynamicObjectCollection chks = this.getUnallocatedCheckDatas();
            if (!chks.isEmpty()) {
                IDataEntityType objtype = BusinessDataServiceHelper.newDynamicObject((String)"bcm_allocatechkentity").getDataEntityType();
                ArrayList<DynamicObject> chkalloLst = new ArrayList<DynamicObject>();
                String userid = RequestContext.get().getUserId();
                Date now = TimeServiceHelper.now();
                for (DynamicObject chk : chks) {
                    DynamicObject chkalloObject = (DynamicObject)objtype.createInstance();
                    chkalloObject.set("chksetting", chk.get("id"));
                    chkalloObject.set("stage", (Object)0);
                    chkalloObject.set("modifier", (Object)userid);
                    chkalloObject.set("modifydate", (Object)now);
                    chkalloObject.set("createdate", (Object)now);
                    chkalloObject.set("creator", (Object)userid);
                    chkalloLst.add(chkalloObject);
                }
                SaveServiceHelper.save((DynamicObject[])chkalloLst.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.success();
    }

    private DynamicObjectCollection getUnallocatedCheckDatas() {
        QFilter alchkqf = new QFilter("1", "=", (Object)"1");
        DynamicObjectCollection allochk = QueryServiceHelper.query((String)"bcm_allocatechkentity", (String)"id,chksetting", (QFilter[])alchkqf.toArray());
        Set allochkids = allochk.stream().map(t -> t.get("chksetting")).collect(Collectors.toSet());
        QFilter chkqf = new QFilter("status", "=", (Object)"1");
        if (!allochkids.isEmpty()) {
            chkqf.and("id", "not in", allochkids);
        }
        return QueryServiceHelper.query((String)"bcm_chkformulasetting", (String)"id,number,name,model,rangetxt", (QFilter[])chkqf.toArray());
    }
}

