/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.chkcheck.ChkResultTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.lang3.StringUtils;

public class ChkStatusUpgradeService
extends BcmUpgradeService {
    protected static WatchLogger log = BcmLogFactory.getWatchLogInstance((boolean)true, ChkStatusUpgradeService.class);
    public static final int BATCH_SIZE = 10000;
    public static final String UPDATESQL = "update t_bcm_mergecontrol set fchkstatus = ? where fid = ?;";
    public static final String SELECT_FIELD = "fid,fflowstatus,fcalculatestatus,fmodelid,fscenarioid,fyearid,fperiodid,forgnumber,fcurrencynumber";
    private final Map<String, String> orgCurrencyCache = new ConcurrentHashMap<String, String>(16);
    private final Map<String, Set<Long>> memberCache = new ConcurrentHashMap<String, Set<Long>>(16);

    public Map<String, Object> updateByModelId(long modelId) {
        return this.upgradeStatus(modelId);
    }

    @Override
    public Map<String, Object> upgrade() {
        return this.upgradeStatus(null);
    }

    public Map<String, Object> upgradeStatus(Long modelId) {
        try {
            HashMap<Long, String> sysCurrencyMap = new HashMap<Long, String>(16);
            try (DataSet currencyDs = DB.queryDataSet((String)"find_bd_currency", (DBRoute)DBRoute.of((String)"basedata"), (String)"select fid, fnumber from t_bd_currency", null);){
                while (currencyDs != null && currencyDs.hasNext()) {
                    Row row = currencyDs.next();
                    sysCurrencyMap.put(row.getLong("fid"), row.getString("fnumber"));
                }
            }
            StringBuilder sql = new StringBuilder();
            sql.append("select ").append(SELECT_FIELD).append(" from t_bcm_mergecontrol ");
            if (modelId != null && modelId != 0L) {
                sql.append(" where fmodelid=").append(modelId).append(" and (fchkstatus = ' ' or fchkstatus is null)");
            } else {
                sql.append(" where fchkstatus = ' ' or fchkstatus is null");
            }
            ArrayList<Callable<Pair>> taskList = new ArrayList<Callable<Pair>>(16);
            try (DataSet ds = DB.queryDataSet((String)"find_chkstatus_bcm_mergecontrol", (DBRoute)DBRoute.of((String)"bcm"), (String)sql.toString(), null);){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    Map<String, Object> rowMap = this.copyMap(row);
                    taskList.add(() -> this.updateChkStatus(rowMap, sysCurrencyMap));
                    if (taskList.size() != 10000) continue;
                    this.updateData(ThreadPoolService.runInWaiting4MergeStatusTaskThread(taskList.toArray(new Callable[0])));
                    taskList.clear();
                }
                if (!taskList.isEmpty()) {
                    this.updateData(ThreadPoolService.runInWaiting4MergeStatusTaskThread(taskList.toArray(new Callable[0])));
                }
            }
            Map<String, Object> map = this.success();
            return map;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            this.orgCurrencyCache.clear();
            this.memberCache.clear();
        }
    }

    /*
     * Exception decompiling
     */
    private void updateData(List<Pair<String, Long>> result) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Pair<String, Long> updateChkStatus(Map<String, Object> row, Map<Long, String> sysCurrencyMap) {
        String chkReportStatus = "B";
        String flowStatus = row.getOrDefault("fflowstatus", "").toString();
        String calStatus = row.getOrDefault("fcalculatestatus", "").toString();
        if ("C".equalsIgnoreCase(flowStatus)) {
            chkReportStatus = "C";
        } else if ("C".equalsIgnoreCase(calStatus)) {
            Long modelId = LongUtil.toLong((Object)row.get("fmodelid"));
            String orgCurrency = this.getOrgCurrency(modelId, sysCurrencyMap, row.getOrDefault("forgnumber", "").toString());
            if (kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)orgCurrency)) {
                log.error(String.format("can't find org currency,modelId=%s,org=%s", modelId, row.getOrDefault("forgnumber", "").toString()));
                return null;
            }
            Optional orgOpt = this.getMemberIds(modelId, "t_bcm_structofent", Sets.newHashSet((Object[])new String[]{row.getOrDefault("forgnumber", "").toString()})).stream().findFirst();
            if (!orgOpt.isPresent()) {
                log.error(String.format("can't find org,modelId=%s,org=%s", modelId, row.getOrDefault("forgnumber", "").toString()));
                return null;
            }
            Optional currencyOpt = this.getMemberIds(modelId, "t_bcm_structofcurrency", Sets.newHashSet((Object[])new String[]{row.getOrDefault("fcurrencynumber", "").toString()})).stream().findFirst();
            if (!currencyOpt.isPresent()) {
                log.error(String.format("can't find currency,modelId=%s,currency=%s", modelId, row.getOrDefault("forgnumber", "").toString()));
                return null;
            }
            if (orgCurrency.equalsIgnoreCase(row.getOrDefault("fcurrencynumber", "").toString())) {
                Set<Long> processIds = this.getMemberIds(modelId, "t_bcm_structofprocess", Sets.newHashSet((Object[])new String[]{"EIRpt", "ERAdj", "ERpt"}));
                if (processIds.isEmpty()) {
                    log.error(String.format("can't find process,modelId=%s,process=EIRpt,ERADJ,ERPT", modelId));
                    return null;
                }
                chkReportStatus = this.isChkReportPass(row, processIds) ? "C" : "U";
            } else {
                Set<Long> processIds = this.getMemberIds(modelId, "t_bcm_structofprocess", Sets.newHashSet((Object[])new String[]{"IRpt", "RAdj", "Rpt"}));
                if (processIds.isEmpty()) {
                    log.error(String.format("can't find process,modelId=%s,process=EIRpt,ERADJ,ERPT", modelId));
                    return null;
                }
                chkReportStatus = this.isChkReportPass(row, processIds) ? "C" : "U";
            }
        }
        return Pair.onePair((Object)chkReportStatus, (Object)LongUtil.toLong((Object)row.get("fid")));
    }

    private boolean isChkReportPass(Map<String, Object> row, Set<Long> processIds) {
        Long modelId = LongUtil.toLong((Object)row.get("fmodelid"));
        Optional orgOpt = this.getMemberIds(modelId, "t_bcm_structofent", Sets.newHashSet((Object[])new String[]{row.getOrDefault("forgnumber", "").toString()})).stream().findFirst();
        Optional currencyOpt = this.getMemberIds(modelId, "t_bcm_structofcurrency", Sets.newHashSet((Object[])new String[]{row.getOrDefault("fcurrencynumber", "").toString()})).stream().findFirst();
        String sql = String.format("select count(1) as count from t_bcm_chkreport where fmodel = ? and forg = ? and fsence =? and fyear = ? and fperiod = ? and fcurrency = ? and fprocessld in(%s) and fchkresulttype = '%s'", StringUtils.join(processIds, (String)","), ChkResultTypeEnum.UNPASS.getIndex());
        try (DataSet ds = DB.queryDataSet((String)"find_mergestatus_bcm_chkreport", (DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{modelId, orgOpt.get(), LongUtil.toLong((Object)row.get("fscenarioid")), LongUtil.toLong((Object)row.get("fyearid")), LongUtil.toLong((Object)row.get("fperiodid")), currencyOpt.get()});){
            if (ds != null && ds.hasNext() && ds.next().getLong("count") > 0L) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    private Set<Long> getMemberIds(Long modelId, String table, Set<String> memberNums) {
        return this.memberCache.computeIfAbsent(String.format("chkupdate_member_%s_%s_%s", modelId, table, String.join((CharSequence)"_", memberNums)), e -> {
            HashSet<Long> result = new HashSet<Long>(16);
            String sql = String.format("select fid from %s where fmodelid=? and fstatus='C' and fcopyfrom=0 and fnumber in('%s')", table, String.join((CharSequence)"','", memberNums));
            try (DataSet ds = DB.queryDataSet((String)"find_mergestatus_bcm_structofmember", (DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[]{modelId});){
                while (ds != null && ds.hasNext()) {
                    result.add(ds.next().getLong("fid"));
                }
            }
            return result;
        });
    }

    private String getOrgCurrency(Long modelId, Map<Long, String> sysCurrencyMap, String orgNum) {
        return this.orgCurrencyCache.computeIfAbsent(String.format("chkupdate_%s_%s", modelId, orgNum), e -> {
            try (DataSet ds = DB.queryDataSet((String)"find_mergestatus_bcm_structofent", (DBRoute)DBRoute.of((String)"bcm"), (String)"select fid, fnumber,fcurrencyid from t_bcm_structofent where fmodelid=? and fstatus='C' and fcopyfrom=0 and fnumber =?", (Object[])new Object[]{modelId, orgNum});){
                while (ds != null && ds.hasNext()) {
                    Row row = ds.next();
                    String currency = (String)sysCurrencyMap.get(row.getLong("fcurrencyid"));
                    if (kd.fi.bcm.fel.common.StringUtils.isBlank((CharSequence)currency)) continue;
                    String string = currency;
                    return string;
                }
            }
            return "";
        });
    }

    private Map<String, Object> copyMap(Row row) {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        for (String field : SELECT_FIELD.split(",")) {
            result.put(field, row.get(field));
        }
        return result;
    }
}

