/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.chkcheck.model.ChkMember;
import kd.fi.bcm.business.chkcheck.serviceHelper.ChkCheckServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.common.enums.DimTypesEnum;
import kd.fi.bcm.common.enums.chkcheck.ChkMemberRangeLimitTypeEnum;
import kd.fi.bcm.common.util.MemberRangeUtil;
import org.apache.commons.lang3.StringUtils;

public class ChkVTxtUpgradeService
extends BcmUpgradeService {
    private HashMap<Long, Pair<Map<Long, String>, Map<String, Long>>> modelId2DimMap = new HashMap(16);

    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"ChkVTxtUpgradeService");){
            try {
                HashMap<Long, ArrayList<ChkMember>> chkSetting = this.getChkSetting();
                Set<Long> modelIds = this.getAllModelId();
                HashMap<Long, Map<String, String>> dimId2DimPropertyMap = this.getDimId2DimPropertyMap();
                if (!chkSetting.isEmpty()) {
                    SQLBuilder4RDB updateSql = new SQLBuilder4RDB();
                    updateSql.append("update t_bcm_chkformulasetting set fvrangetxt = ?,  fvfixdimtxt = ? where fid = ?");
                    ArrayList<Object[]> paremList = new ArrayList<Object[]>(chkSetting.values().size());
                    for (Map.Entry<Long, ArrayList<ChkMember>> entry : chkSetting.entrySet()) {
                        if (!modelIds.contains((Long)entry.getValue().get(0).get("fmodelid"))) continue;
                        String rangtxt = this.buildRangeTxt(entry.getValue(), dimId2DimPropertyMap);
                        String fixDimtxt = this.buildFixDimTxt(entry.getValue(), dimId2DimPropertyMap);
                        paremList.add(new Object[]{rangtxt, fixDimtxt, entry.getKey()});
                    }
                    if (!paremList.isEmpty()) {
                        DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql.toString(), paremList);
                    }
                }
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("\u52fe\u7a3d\u8bbe\u7f6e\u5347\u7ea7\u5386\u53f2\u6570\u636e vrangetxt\uff0cvfixdimtxt\u5931\u8d25\uff01", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return this.success();
    }

    private HashMap<Long, ArrayList<ChkMember>> getChkSetting() {
        SQLBuilder4RDB sql = new SQLBuilder4RDB();
        sql.append("select t1.fid,fmodelid,fvfixdimtxt,fvrangetxt,t2.* from t_bcm_chkformulasetting t1 left join t_bcm_chkmembrange t2 on t1.fid =t2.fid");
        DataSet ds = DB.queryDataSet((String)"query_chksetting_membrange", (DBRoute)BCMConstant.DBROUTE, (String)sql.toString(), null);
        HashMap<Long, ArrayList<ChkMember>> rsMap = new HashMap<Long, ArrayList<ChkMember>>(16);
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            if (!StringUtils.isEmpty((CharSequence)row.getString("fvrangetxt")) && !StringUtils.isBlank((CharSequence)row.getString("fvrangetxt"))) continue;
            ChkMember chkMember = new ChkMember();
            Long fid = row.getLong("fid");
            chkMember.put("fid", (Object)fid);
            chkMember.put("fmodelid", row.get("fmodelid"));
            chkMember.put("fentryid", row.get("fentryid"));
            chkMember.setId(row.getLong("fmemberid"));
            chkMember.setScope(row.getInteger("fmembbound"));
            chkMember.setDimId(row.getLong("fdimensionid"));
            chkMember.setMembboundtype(row.getString("fmembboundtype"));
            chkMember.setLimittype(row.getString("flimittype"));
            rsMap.computeIfAbsent(fid, v -> new ArrayList()).add(chkMember);
        }
        return rsMap;
    }

    private HashMap<Long, Map<String, String>> getDimId2DimPropertyMap() {
        String queryDimSql = "select fid,fnumber,fshortnumber,fmodelid from t_bcm_dimension";
        DataSet ds = DB.queryDataSet((String)"query_chksetting_membrange", (DBRoute)BCMConstant.DBROUTE, (String)queryDimSql, null);
        HashMap<Long, Map<String, String>> dimid2DimproMap = new HashMap<Long, Map<String, String>>(16);
        while (ds.hasNext()) {
            Row row = ds.next();
            HashMap<String, String> dimProperty = new HashMap<String, String>(4);
            dimProperty.put("fid", row.getString("fid"));
            dimProperty.put("fnumber", row.getString("fnumber"));
            dimProperty.put("fshortnumber", row.getString("fshortnumber"));
            dimProperty.put("fmodelid", row.getString("fmodelid"));
            dimid2DimproMap.put(row.getLong("fid"), dimProperty);
        }
        return dimid2DimproMap;
    }

    private String buildRangeTxt(ArrayList<ChkMember> membrList, HashMap<Long, Map<String, String>> dimId2DimProMap) {
        if (membrList.isEmpty()) {
            return null;
        }
        Long modelId = (Long)membrList.get(0).get("fmodelid");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        if (StringUtils.isEmpty((CharSequence)modelNum)) {
            return null;
        }
        Map dimnum2DynMaps = MemberReader.getDimDyoByModelId((long)modelId);
        Pair<Map<Long, String>, Map<String, Long>> dimIDAndNumberMap = this.getModelDimIDAndNumberMap(modelId);
        StringBuilder sb = new StringBuilder();
        Map<Long, List<ChkMember>> dim2MembrsMap = membrList.stream().collect(Collectors.groupingBy(ChkMember::getDimId));
        for (Map.Entry<Long, List<ChkMember>> entry : dim2MembrsMap.entrySet()) {
            Map<String, String> dimPropertys = dimId2DimProMap.get(entry.getKey());
            if (dimPropertys == null || dimPropertys.isEmpty()) continue;
            String dimNumber = dimPropertys.get("fnumber");
            if (!DimTypesEnum.SCENARIO.getNumber().equals(dimNumber) && !DimTypesEnum.ENTITY.getNumber().equals(dimNumber) && !DimTypesEnum.PROCESS.getNumber().equals(dimNumber)) continue;
            if (DimTypesEnum.ENTITY.getNumber().equals(dimNumber)) {
                Map<String, List<ChkMember>> orgMap = entry.getValue().stream().collect(Collectors.groupingBy(ChkMember::getLimittype));
                for (Map.Entry<String, List<ChkMember>> entry1 : orgMap.entrySet()) {
                    if (ChkMemberRangeLimitTypeEnum.INBOUND.getLimitType().equals(entry1.getKey())) {
                        sb.append("ValidEntities").append(":");
                    } else {
                        sb.append("InvalidEntities").append(":");
                    }
                    ArrayList<String> memberList = new ArrayList<String>(entry.getValue().size());
                    for (ChkMember member : entry.getValue()) {
                        IDNumberTreeNode dimMember = MemberReader.findMemberById((String)modelNum, (String)ChkCheckServiceHelper.getDimMembEntityNumByDimNum(dimNumber), (Long)member.getId());
                        memberList.add(MemberRangeUtil.getMemberRangeNumber((int)member.getScope()) + "[" + dimMember.getNumber() + "]");
                    }
                    sb.append(String.join((CharSequence)",", memberList)).append(";");
                }
                continue;
            }
            sb.append(dimPropertys.get("fshortnumber")).append(":");
            ArrayList<String> memberList = new ArrayList<String>(entry.getValue().size());
            for (ChkMember member : entry.getValue()) {
                IDNumberTreeNode dimMember = MemberReader.findMemberById((String)modelNum, (String)ChkCheckServiceHelper.getDimMembEntityNumByDimNum(dimNumber), (Long)member.getId());
                memberList.add(MemberRangeUtil.getMemberRangeNumber((int)member.getScope()) + "[" + dimMember.getNumber() + "]");
            }
            sb.append(String.join((CharSequence)",", memberList)).append(";");
        }
        return sb.toString();
    }

    private String buildFixDimTxt(ArrayList<ChkMember> membrList, HashMap<Long, Map<String, String>> dimId2DimProMap) {
        if (membrList.isEmpty()) {
            return null;
        }
        Long modelId = (Long)membrList.get(0).get("fmodelid");
        String modelNum = MemberReader.findModelNumberById((Object)modelId);
        if (StringUtils.isEmpty((CharSequence)modelNum)) {
            return null;
        }
        Map dimnum2DynMaps = MemberReader.getDimDyoByModelId((long)modelId);
        Pair<Map<Long, String>, Map<String, Long>> dimIDAndNumberMap = this.getModelDimIDAndNumberMap(modelId);
        StringBuilder sb = new StringBuilder();
        Map<Long, List<ChkMember>> dim2MembrsMap = membrList.stream().collect(Collectors.groupingBy(ChkMember::getDimId));
        for (Map.Entry<Long, List<ChkMember>> entry : dim2MembrsMap.entrySet()) {
            Map<String, String> dimPropertys = dimId2DimProMap.get(entry.getKey());
            if (dimPropertys == null || dimPropertys.isEmpty()) continue;
            String dimNumber = dimPropertys.get("fnumber");
            if (DimTypesEnum.SCENARIO.getNumber().equals(dimNumber) || DimTypesEnum.ENTITY.getNumber().equals(dimNumber) || DimTypesEnum.PROCESS.getNumber().equals(dimNumber) || DimTypesEnum.PERIOD.getNumber().equals(dimNumber)) continue;
            sb.append(dimPropertys.get("fshortnumber")).append(":");
            ArrayList<String> memberList = new ArrayList<String>(entry.getValue().size());
            for (ChkMember member : entry.getValue()) {
                IDNumberTreeNode dimMember = MemberReader.findMemberById((String)modelNum, (String)ChkCheckServiceHelper.getDimMembEntityNumByDimNum(dimNumber), (Long)member.getId());
                memberList.add(MemberRangeUtil.getMemberRangeNumber((int)member.getScope()) + "[" + dimMember.getNumber() + "]");
            }
            sb.append(String.join((CharSequence)",", memberList)).append(";");
        }
        return sb.toString();
    }

    private Pair<Map<Long, String>, Map<String, Long>> getModelDimIDAndNumberMap(long modelid) {
        Pair dimIDAndNumberMap = this.modelId2DimMap.get(modelid);
        if (dimIDAndNumberMap == null) {
            dimIDAndNumberMap = MemberReader.getModelDimIDAndNumberMap((long)modelid);
            this.modelId2DimMap.put(modelid, (Pair<Map<Long, String>, Map<String, Long>>)dimIDAndNumberMap);
        }
        return dimIDAndNumberMap;
    }

    private Set<Long> getAllModelId() {
        SQLBuilder4RDB querySql = new SQLBuilder4RDB();
        querySql.append("select fid from t_bcm_model");
        DataSet getAllModelId = DB.queryDataSet((String)"getAllModelId", (DBRoute)BCMConstant.DBROUTE, (String)querySql.toString());
        HashSet<Long> ids = new HashSet<Long>(10);
        while (getAllModelId.hasNext()) {
            Row row = getAllModelId.next();
            ids.add(row.getLong("fid"));
        }
        return ids;
    }
}

