/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.permission.BcmFunPermissionHelper;
import kd.fi.bcm.business.upgrade.CommonPermItemsUpgradeService;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.Permission.UserTypeEnum;
import kd.fi.bcm.common.util.LongUtil;

public abstract class CommonAdminPermDir2RoleUpgradeService
extends CommonPermItemsUpgradeService {
    protected static final String MODEL = "model";
    protected static final String USER_ID = "userId";
    protected static final String USER_TYPE = "userType";
    protected static final String USERTYPE = "usertype";
    protected static final String USER = "user";
    protected ApplicationTypeEnum app;
    protected String appId;
    protected String permType;
    private Set<Long> modelIds = Sets.newHashSetWithExpectedSize((int)16);
    private Map<Long, Set<Long>> userMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, Set<Long>> userGroupMap = Maps.newHashMapWithExpectedSize((int)16);
    private Map<Long, List<Long>> userAssignInfo = Maps.newHashMapWithExpectedSize((int)16);
    private List<DynamicObject> usrGrpSaveList = Lists.newArrayListWithExpectedSize((int)16);

    protected <T extends List> Map<String, Object> upgradeStart(T doc) {
        if (doc.isEmpty()) {
            return this.success();
        }
        this.modelIds = Sets.newHashSetWithExpectedSize((int)16);
        this.userMap = Maps.newHashMapWithExpectedSize((int)16);
        this.userGroupMap = Maps.newHashMapWithExpectedSize((int)16);
        this.userAssignInfo = Maps.newHashMapWithExpectedSize((int)16);
        this.usrGrpSaveList = Lists.newArrayListWithExpectedSize((int)16);
        if (doc instanceof DynamicObjectCollection) {
            for (Map dy : (DynamicObjectCollection)doc) {
                this.doc2Dao(LongUtil.toLong((Object)dy.getLong(MODEL)), dy.getString(USERTYPE), LongUtil.toLong((Object)dy.getLong(USER)));
            }
        } else {
            for (Map dy : doc) {
                this.doc2Dao(LongUtil.toLong(dy.get(MODEL)), dy.get(USER_TYPE).toString(), LongUtil.toLong(dy.get(USER_ID)));
            }
        }
        if (this.userMap.isEmpty() && this.userGroupMap.isEmpty()) {
            return this.success();
        }
        Map<Object, Object> groupUserMap = Maps.newHashMapWithExpectedSize((int)16);
        if (!this.userGroupMap.isEmpty()) {
            HashSet groupIds = Sets.newHashSetWithExpectedSize((int)16);
            this.userGroupMap.values().forEach(groupIds::addAll);
            String selectFields = "user.id,usergroup.id";
            DynamicObjectCollection usergroups = QueryServiceHelper.query((String)"bos_usergroupstaff", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("usergroup", "in", (Object)groupIds)});
            groupUserMap = usergroups.stream().collect(Collectors.groupingBy(t -> t.getLong("usergroup.id"), Collectors.mapping(t -> t.getLong("user.id"), Collectors.toSet())));
        }
        for (Long modelId : this.modelIds) {
            HashSet userIds = Sets.newHashSetWithExpectedSize((int)16);
            userIds.addAll((Collection)this.userMap.getOrDefault(modelId, Sets.newHashSetWithExpectedSize((int)16)));
            Set<Long> userGroupIds = this.userGroupMap.get(modelId);
            if (!CollectionUtils.isEmpty(userGroupIds)) {
                for (Long userGroupId : userGroupIds) {
                    userIds.addAll(groupUserMap.getOrDefault(userGroupId, Sets.newHashSetWithExpectedSize((int)16)));
                }
            }
            if (CollectionUtils.isEmpty((Collection)userIds)) continue;
            this.log.info(String.format(ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u6743\u9650\u5347\u7ea7->\u4f53\u7cfbid:%1$s,\u7528\u6237id:%2$s", (String)"AdminPermUpgrade_01", (String)"fi-bcm-business", (Object[])new Object[0]), modelId, JSON.toJSONString((Object)userIds)));
            ThreadPoolService.upgradeModelThread(() -> this.upgradePerm(modelId, userIds));
        }
        if (!CollectionUtils.isEmpty(this.userAssignInfo)) {
            PermissionServiceHelper.roleAssignUserOrg((String)BcmFunPermissionHelper.APP2ADMINROLEID.get(this.app), (String)this.permType, this.userAssignInfo, null, (boolean)Boolean.TRUE);
            if (ApplicationTypeEnum.CM == this.app) {
                PermissionServiceHelper.roleAssignUserOrg((String)BcmFunPermissionHelper.APP2ADMINROLEID.get(ApplicationTypeEnum.RPT), (String)this.permType, this.userAssignInfo, null, (boolean)Boolean.TRUE);
            }
        }
        if (!CollectionUtils.isEmpty(this.usrGrpSaveList)) {
            SaveServiceHelper.save((DynamicObject[])this.usrGrpSaveList.toArray(new DynamicObject[0]));
        }
        return this.success();
    }

    private void upgradePerm(Long modelId, Set<Long> userIds) {
        BcmFunPermissionHelper.delPermByUser(modelId, Lists.newArrayList(userIds), this.permType, this.appId);
    }

    private DynamicObject buildUsrGrpDyObj(long dimId, long usrGrpId) {
        DynamicObject saveObj = BusinessDataServiceHelper.newDynamicObject((String)"perm_usrgrprole");
        saveObj.set("dimtype", (Object)this.permType);
        saveObj.set("dimid", (Object)dimId);
        saveObj.set("includesub", (Object)0);
        saveObj.set("usrgrpid", (Object)usrGrpId);
        saveObj.set("role", (Object)BcmFunPermissionHelper.APP2ADMINROLEID.get(this.app));
        return saveObj;
    }

    private void doc2Dao(Long modelId, String userType, Long userId) {
        if (!Objects.equals(modelId, 0L)) {
            if (UserTypeEnum.USER.getName().equals(userType)) {
                this.userMap.computeIfAbsent(modelId, k -> Sets.newHashSetWithExpectedSize((int)16)).add(userId);
                if (!Objects.equals(userId, 0L)) {
                    this.userAssignInfo.computeIfAbsent(userId, k -> Lists.newArrayListWithExpectedSize((int)16)).add(modelId);
                }
            } else {
                this.userGroupMap.computeIfAbsent(modelId, k -> Sets.newHashSetWithExpectedSize((int)16)).add(userId);
                if (!Objects.equals(userId, 0L)) {
                    this.usrGrpSaveList.add(this.buildUsrGrpDyObj(modelId, userId));
                }
            }
            this.modelIds.add(modelId);
        }
    }
}

