/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class ConvertDiffScenesUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        List<Pair<Long, String>> allModels = this.getCmAndRptModel();
        if (allModels.isEmpty()) {
            return this.success();
        }
        Set<Long> modelIds = allModels.stream().map(s -> (Long)s.p1).collect(Collectors.toSet());
        List<Object[]> paramList = this.getConvertDiffScenes(modelIds);
        String updateSql = "insert into t_bcm_applyscenarioconfig(fid, fentryid, fseq, fisexcept, fscenarioid, fscope) values(?,?,?,?,?,?)";
        try {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramList);
        }
        catch (Exception e) {
            this.log.error(String.format("ConvertDiffScenesUpgradeService - message: %s", e.getMessage()));
        }
        return this.success();
    }

    private List<Object[]> getConvertDiffScenes(Set<Long> modelIds) {
        ArrayList paramsList = new ArrayList();
        paramsList.clear();
        String sql = "select a.fid as fid ,a.fscenarioid as fscenarioid ,b.fentryid as fentryid from t_bcm_convertdiffentity a left join t_bcm_applyscenarioconfig b on b.fid=a.fid where a.fmodelid in ( " + Joiner.on((String)",").join(modelIds) + ")";
        return (List)DB.query((DBRoute)DBRoute.of((String)"bcm"), (String)sql, (Object[])new Object[0], rs -> {
            while (rs.next()) {
                if (rs.getObject("fentryid") != null && rs.getLong("fentryid") != 0L) continue;
                Object[] param = new Object[]{rs.getLong("fid"), GlobalIdUtil.genGlobalLongId(), 0, "0", rs.getLong("fscenarioid"), "10"};
                paramsList.add(param);
            }
            return paramsList;
        });
    }
}

