/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.util.QFBuilder;

public class ConvertRelatedUpgradeService
extends AbstractUpgradeService {
    public ConvertRelatedUpgradeService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    protected void readyUpgradeData() {
    }

    @Override
    protected void saveData() {
        this.saveConvertDiff();
        this.saveUserdefCvtFormula();
        this.saveExchangeRate();
    }

    private void saveConvertDiff() {
        DynamicObject[] dys;
        String properties = "leftformula, lformulatemp, rightformula, rformulatemp, vformula, entryentity.memberid";
        QFilter filter = new QFilter("model", "=", (Object)this.context.getModelId());
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"bcm_convertdiffentity", (String)properties, (QFilter[])new QFilter[]{filter})) {
            dy.set("leftformula", (Object)dy.getString("leftformula").replace("\"BP.CS\"", "\"BP.IRpt\""));
            dy.set("lformulatemp", (Object)dy.getString("lformulatemp").replace("\"BP.CS\"", "\"BP.IRpt\""));
            dy.set("rightformula", (Object)dy.getString("rightformula").replace("\"BP.CS\"", "\"BP.IRpt\""));
            dy.set("rformulatemp", (Object)dy.getString("rformulatemp").replace("\"BP.CS\"", "\"BP.IRpt\""));
            dy.set("vformula", (Object)dy.getString("vformula").replace("\"BP.CS\"", "\"BP.IRpt\""));
        }
        SaveServiceHelper.save((DynamicObject[])dys);
        Long bp_csid = this.context.getDel_bps().get("CS");
        QFBuilder qfIRpt = new QFBuilder("model", "=", (Object)this.context.getModelId());
        qfIRpt.and("number", "=", (Object)"IRpt");
        DynamicObject memberIRpt = QueryServiceHelper.queryOne((String)"bcm_processmembertree", (String)"id", (QFilter[])qfIRpt.toArray());
        if (bp_csid != null && memberIRpt != null) {
            DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)("UPDATE t_bcm_condiffmembrange SET fmemberid = " + memberIRpt.getString("id") + " WHERE fmemberid = " + bp_csid.toString()));
        }
    }

    private void saveUserdefCvtFormula() {
        DynamicObject[] dys;
        String properties = "convertformula, cvtformulaechoed";
        QFilter filter = new QFilter("model", "=", (Object)this.context.getModelId());
        for (DynamicObject dy : dys = BusinessDataServiceHelper.load((String)"bcm_userdefcvtformula", (String)properties, (QFilter[])new QFilter[]{filter})) {
            dy.set("convertformula", (Object)dy.getString("convertformula").replace("\"BP.CS\"", "\"BP.IRpt\""));
            dy.set("cvtformulaechoed", (Object)dy.getString("cvtformulaechoed").replace("\"BP.CS\"", "\"BP.IRpt\""));
        }
        SaveServiceHelper.save((DynamicObject[])dys);
    }

    private void saveExchangeRate() {
        QFilter qf = new QFilter("model", "=", (Object)this.context.getModelId());
        qf.and("isexchangerate", "=", (Object)true);
        qf.and("isleaf", "=", (Object)true);
        HashSet numbers = new HashSet();
        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number", (QFilter[])qf.toArray()).forEach(org -> numbers.add(org.getString("number")));
        RunScriptBuilder run = new RunScriptBuilder(this.context.getCube());
        run.appendV((PairList<String, String>)new PairList().addPair((Object)"AuditTrail", (Object)"ATNone"));
        run.appendEqualSign();
        run.appendV((PairList<String, String>)new PairList().addPair((Object)"AuditTrail", (Object)"EntityInput"));
        run.endRunExpress();
        run.addDimensionScope(PresetConstant.ENTITY_DIM, numbers.toArray(new String[0]));
        run.runScript();
    }
}

