/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.upgrade.DimMemberEntity;
import kd.fi.bcm.common.enums.DimDataSourceEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;

@DataEntityTypeAttribute
public class DimAuditTrailEntity
extends DimMemberEntity {
    private boolean isDatacollect;
    private String dataSource;

    @SimplePropertyAttribute(name="datasource")
    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    @SimplePropertyAttribute(name="isdatacollect")
    public boolean isDatacollect() {
        return this.isDatacollect;
    }

    public void setDatacollect(boolean datacollect) {
        this.isDatacollect = datacollect;
    }

    @Override
    protected String getSelectField() {
        return super.getSelectField() + ",isdatacollect,datasource";
    }

    @Override
    protected void setDefaultDataSource(List<DynamicObject> load) {
        List<String> deleteNumbers = this.getDeleteNumbers();
        HashMap<String, DynamicObject> map = new HashMap<String, DynamicObject>(16);
        List<String> strs = Arrays.asList("EntityInputTraDif", "DataCollection", "EntityInput", "TraDif", "UTTotal", "ADJE", "RptDS");
        for (DynamicObject dyn : load) {
            String ds = dyn.getString("datasource");
            String number = dyn.getString("number");
            if (StringUtils.isEmpty((String)ds) && !deleteNumbers.contains(number) && dyn.getBoolean("isleaf")) {
                if ("AutoCWP".equals(number)) {
                    dyn.set("datasource", (Object)DimDataSourceEnum.Style.getIndex());
                } else if ("EntityInputTraDif".equals(number)) {
                    dyn.set("datasource", (Object)"");
                } else {
                    dyn.set("datasource", (Object)DimDataSourceEnum.Entry.getIndex());
                }
            }
            if (!strs.contains(number)) continue;
            map.put(number, dyn);
        }
        DynamicObject UTTotal = (DynamicObject)map.get("UTTotal");
        if (UTTotal != null) {
            DynamicObject ADJE = (DynamicObject)map.get("ADJE");
            ADJE.set("parent", (Object)UTTotal.getLong("id"));
            ADJE.set("parent_id", (Object)UTTotal.getLong("id"));
        } else {
            DynamicObject RptDS = (DynamicObject)map.get("RptDS");
            if (RptDS != null) {
                RptDS.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.getOIndex());
                RptDS.set("isleaf", (Object)false);
                long RptDSId = RptDS.getLong("id");
                int level = RptDS.getInt("level");
                List<String> children = Arrays.asList("DataCollection", "EntityInput", "TraDif", "EntityInputTraDif");
                for (String child : children) {
                    DynamicObject childDyn = (DynamicObject)map.get(child);
                    if (childDyn == null) continue;
                    childDyn.set("parent", (Object)RptDSId);
                    childDyn.set("parent_id", (Object)RptDSId);
                    childDyn.set("level", (Object)(level + 1));
                    if ("TraDif".equalsIgnoreCase(child)) {
                        childDyn.set("storagetype", (Object)StorageTypeEnum.UNSHARE.getOIndex());
                        continue;
                    }
                    childDyn.set("storagetype", (Object)StorageTypeEnum.STORAGE.getOIndex());
                }
            }
        }
    }

    @Override
    protected void afterSave(List<DynamicObject> obj) {
    }

    @Override
    protected void filterBeforeSave(List<DynamicObject> load, List<DynamicObject> needNews) {
    }
}

