/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.ComplexPropertyAttribute;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.DimAuditTrailEntity;
import kd.fi.bcm.business.upgrade.DimCurrencyEntity;
import kd.fi.bcm.business.upgrade.DimProcessEntity;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.util.GlobalIdUtil;
import org.apache.commons.beanutils.ConvertUtils;

@DataEntityTypeAttribute
public abstract class DimMemberEntity {
    private String name;
    private String number;
    private String storagetype;
    private String aggoprt;
    private List<DimMemberEntity> children = new ArrayList<DimMemberEntity>(10);
    private DimMemberEntity parent;
    private String longNumber;
    private boolean isleaf;
    private int level;
    private int dseq;
    private long modelId;
    private long dimensionId;
    private String modelNumber;
    private String dimNumber;

    public static IDataEntityType getDataEntityType(String dim) {
        Class clazz = null;
        switch (dim) {
            case "Process": {
                clazz = DimProcessEntity.class;
                break;
            }
            case "AuditTrail": {
                clazz = DimAuditTrailEntity.class;
                break;
            }
            case "Currency": {
                clazz = DimCurrencyEntity.class;
            }
        }
        if (clazz == null) {
            throw new KDBizException("Not supported dimension: " + dim);
        }
        return OrmUtils.getDataEntityType(clazz);
    }

    public static Object convertValue(Class<?> propertyType, String value) {
        if (propertyType == String.class) {
            return value;
        }
        if (propertyType == Boolean.TYPE) {
            return !"0".equals(value);
        }
        if (propertyType == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (propertyType == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        return ConvertUtils.convert((String)value, propertyType);
    }

    @SimplePropertyAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @SimplePropertyAttribute(name="number")
    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    @SimplePropertyAttribute(name="storagetype")
    public String getStoragetype() {
        return this.storagetype;
    }

    public void setStoragetype(String storagetype) {
        this.storagetype = storagetype;
    }

    @SimplePropertyAttribute(name="aggoprt")
    public String getAggoprt() {
        return this.aggoprt;
    }

    public void setAggoprt(String aggoprt) {
        this.aggoprt = aggoprt;
    }

    @ComplexPropertyAttribute(name="parent")
    public DimMemberEntity getParent() {
        return this.parent;
    }

    public void setParent(DimMemberEntity parent) {
        this.parent = parent;
    }

    @CollectionPropertyAttribute(collectionItemPropertyType=DimMemberEntity.class, name="children")
    public List<DimMemberEntity> getChildren() {
        return this.children;
    }

    public void setChildren(List<DimMemberEntity> children) {
        this.children = children;
    }

    @SimplePropertyAttribute(name="longnumber")
    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    @SimplePropertyAttribute(name="isleaf")
    public boolean isIsleaf() {
        return this.isleaf;
    }

    public void setIsleaf(boolean isleaf) {
        this.isleaf = isleaf;
    }

    @SimplePropertyAttribute(name="level")
    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @SimplePropertyAttribute(name="dseq")
    public int getDseq() {
        return this.dseq;
    }

    public void setDseq(int dseq) {
        this.dseq = dseq;
    }

    @SimplePropertyAttribute(name="model")
    public long getModelId() {
        return this.modelId;
    }

    public void setModelId(long modelId) {
        this.modelId = modelId;
    }

    @SimplePropertyAttribute(name="dimension")
    public long getDimensionId() {
        return this.dimensionId;
    }

    public void setDimensionId(long dimensionId) {
        this.dimensionId = dimensionId;
    }

    protected DynamicObject createDyn(MainEntityType dt, IDataEntityType clrType) {
        DynamicObject dyn = (DynamicObject)dt.createInstance();
        DataEntityPropertyCollection properties = clrType.getProperties();
        for (IDataEntityProperty property : properties) {
            Object value;
            if (!(property instanceof ISimpleProperty) || (value = property.getValue((Object)this)) == null) continue;
            dyn.set(property.getName(), value);
        }
        this.setDefaultValue(dyn);
        return dyn;
    }

    protected void setDefaultValue(DynamicObject dyn) {
        DimensionServiceHelper.initDimensionDyObject(dyn);
        dyn.set("id", (Object)GlobalIdUtil.genGlobalLongId());
        dyn.set("member", (Object)GlobalIdUtil.genGlobalLongId());
        dyn.set("issysmember", (Object)1);
    }

    public boolean updateDyn(DynamicObject dyn, IDataEntityType clrType) {
        boolean result = false;
        DataEntityPropertyCollection properties = clrType.getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof ISimpleProperty)) continue;
            String name = property.getName();
            Object newValue = property.getValue((Object)this);
            Object oldValue = dyn.get(name);
            if (oldValue instanceof DynamicObject) {
                oldValue = ((DynamicObject)oldValue).getLong("id");
            }
            if (!result) {
                result = this.needUpdateValue(newValue, oldValue);
            }
            if (!result) continue;
            if (oldValue instanceof OrmLocaleValue) {
                OrmLocaleValue localeValue = (OrmLocaleValue)oldValue;
                localeValue.setLocaleValue_zh_CN((String)newValue);
                dyn.set(name, (Object)localeValue);
                continue;
            }
            dyn.set(name, newValue);
        }
        return result;
    }

    private boolean needUpdateValue(Object newValue, Object oldValue) {
        if (newValue != null) {
            if (oldValue == null) {
                return true;
            }
            if (oldValue instanceof OrmLocaleValue) {
                OrmLocaleValue localeValue = (OrmLocaleValue)oldValue;
                String cnValue = localeValue.getLocaleValue_zh_CN();
                return !cnValue.equals(newValue);
            }
            if (oldValue instanceof String) {
                String strValue = (String)oldValue;
                return !strValue.equals(newValue);
            }
            if (oldValue instanceof Long) {
                return ((Long)oldValue).longValue() != ((Long)newValue).longValue();
            }
            if (oldValue instanceof Boolean) {
                return ((Boolean)oldValue).booleanValue() != ((Boolean)newValue).booleanValue();
            }
            if (oldValue instanceof Integer) {
                return ((Integer)oldValue).intValue() != ((Integer)newValue).intValue();
            }
            return !oldValue.toString().equals(newValue.toString());
        }
        return false;
    }

    protected String getSelectField() {
        return "id,name,number,parent,storagetype,aggoprt,longnumber,isleaf,level,dseq,model,dimension";
    }

    protected Map<String, List<String>> getNewOldNumberMap() {
        return new HashMap<String, List<String>>(16);
    }

    protected List<String> getReplaceNumbers() {
        return new ArrayList<String>(10);
    }

    protected List<String> getDeleteNumbers() {
        return new ArrayList<String>(10);
    }

    protected void setDefaultDataSource(List<DynamicObject> load) {
    }

    protected void filterBeforeSave(List<DynamicObject> load, List<DynamicObject> needNews) {
        Set alreadyHasNumber = load.stream().map(x -> x.getString("number")).collect(Collectors.toSet());
        needNews.removeIf(x -> alreadyHasNumber.contains(x.get("number")));
    }

    public void saveDyn(List<DynamicObject> load, List<DynamicObject> needNews, UpgradeContext context) {
        this.filterBeforeSave(load, needNews);
        this.saveNewOlap(this.modelNumber, this.dimNumber, needNews);
        this.setDefaultDataSource(load);
        List<String> deleteNumbers = this.getDeleteNumbers();
        List<DynamicObject> list = load.stream().filter(x -> !deleteNumbers.contains(x.getString("number"))).collect(Collectors.toList());
        ArrayList<DynamicObject> updates = new ArrayList<DynamicObject>(needNews);
        updates.addAll(list);
        List<String> allNums = this.getAllNumbers(this);
        HashMap<String, Integer> numIdxMap = new HashMap<String, Integer>(16);
        for (int i = 0; i < allNums.size(); ++i) {
            numIdxMap.put(allNums.get(i), i);
        }
        updates.sort((a, b) -> {
            boolean y;
            String aNum = a.getString("number");
            String bNum = b.getString("number");
            Integer aidx = (Integer)numIdxMap.get(aNum);
            Integer bidx = (Integer)numIdxMap.get(bNum);
            boolean x = aidx == null || aNum.endsWith("None");
            boolean bl = y = bidx == null || bNum.endsWith("None");
            if (x && y) {
                return 0;
            }
            if (x) {
                return 1;
            }
            if (y) {
                return -1;
            }
            return aidx - bidx;
        });
        DimensionTree<String, DynamicObject> treeFromDyn = DimensionTree.createTreeFromDyn(updates.toArray(new DynamicObject[0]));
        List<DynamicObject> obj = this.update(treeFromDyn, 1);
        if (list.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[list.size()]));
        }
        if (needNews.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])needNews.toArray(new DynamicObject[needNews.size()]));
        }
        this.deleteDimensions(deleteNumbers, context);
        this.afterSave(obj);
    }

    protected List<String> getAllNumbers(DimMemberEntity entity) {
        ArrayList<String> result = new ArrayList<String>(10);
        List<DimMemberEntity> children = entity.getChildren();
        if (children != null) {
            for (DimMemberEntity child : children) {
                result.add(child.getNumber());
                result.addAll(this.getAllNumbers(child));
            }
        }
        return result;
    }

    protected void afterSave(List<DynamicObject> obj) {
    }

    protected void deleteDimensions(List<String> deleteNumbers, UpgradeContext context) {
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)this.modelId), new QFilter("number", "in", deleteNumbers)};
        String entityName = DimensionServiceHelper.getDimMembEntityNumByDimNum(this.dimNumber.toLowerCase(Locale.ENGLISH));
        DynamicObjectCollection saveToContext = QueryServiceHelper.query((String)entityName, (String)"id, number", (QFilter[])filters);
        if ("process".equals(this.dimNumber.toLowerCase(Locale.ENGLISH))) {
            for (DynamicObject delMember : saveToContext) {
                context.getDel_bps().put(delMember.getString("number"), delMember.getLong("id"));
            }
        } else if ("audittrail".equals(this.dimNumber.toLowerCase(Locale.ENGLISH))) {
            for (DynamicObject delMember : saveToContext) {
                context.getDel_at().put(delMember.getString("number"), delMember.getLong("id"));
            }
        } else if ("currency".equals(this.dimNumber.toLowerCase(Locale.ENGLISH))) {
            for (DynamicObject delMember : saveToContext) {
                context.getDel_c().put(delMember.getString("number"), delMember.getLong("id"));
            }
        }
        DeleteServiceHelper.delete((String)entityName, (QFilter[])filters);
        DynamicComputingServiceHelper.repairModelByDim(this.modelNumber, this.dimNumber, true);
    }

    private List<DynamicObject> update(DimensionTree<String, DynamicObject> root, int dseq) {
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        DynamicObject data = root.getData();
        result.add(data);
        data.set("dseq", (Object)dseq);
        List<DimensionTree<String, DynamicObject>> children = root.getChildren();
        boolean isleaf = children == null || children.size() == 0;
        data.set("isleaf", (Object)isleaf);
        if (children != null) {
            int ddseq = 1;
            for (DimensionTree<String, DynamicObject> child : children) {
                result.addAll(this.update(child, ddseq));
                ++ddseq;
            }
        }
        return result;
    }

    private void saveNewOlap(String cubeNumber, String dimNumber, List<DynamicObject> needNews) {
        HashSet<String> numbers = new HashSet<String>(16);
        ArrayList<DynamicObject> memberList = new ArrayList<DynamicObject>(needNews.size());
        String entityNumber = DimensionServiceHelper.getDimMembEntityNumByDimNum(dimNumber.toLowerCase(Locale.ENGLISH)).replace("tree", "");
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        for (DynamicObject treeDyn : needNews) {
            DynamicObject member = (DynamicObject)dt.createInstance();
            DimensionServiceHelper.initDimensionDyObjectWithOrg(member);
            String number = treeDyn.getString("number");
            member.set("id", (Object)treeDyn.getLong("member"));
            member.set("number", (Object)number);
            member.set("name", (Object)treeDyn.getString("name"));
            member.set("model", (Object)this.modelId);
            member.set("dimension", (Object)this.dimensionId);
            memberList.add(member);
            numbers.add(number);
        }
        SaveServiceHelper.save((DynamicObject[])memberList.toArray(new DynamicObject[0]));
        numbers.addAll(this.getNewOldNumberMap().keySet());
        OlapServiceHelper.batchCreateDimensionMembers(cubeNumber, dimNumber, numbers.toArray(new String[0]));
    }

    public String getModelNumber() {
        return this.modelNumber;
    }

    public void setModelNumber(String modelNumber) {
        this.modelNumber = modelNumber;
    }

    public String getDimNumber() {
        return this.dimNumber;
    }

    public void setDimNumber(String dimNumber) {
        this.dimNumber = dimNumber;
    }
}

