/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.olap.dataSources.AggFactorMetadataItem;
import kd.bos.olap.metadata.MemberStorageTypes;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.sharemember.AddNewShareMemberUtil;
import kd.fi.bcm.business.dimension.struct.ShareNodeStructSyncHelper;
import kd.fi.bcm.business.olap.shield.ShieldRuleBulider;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.DimMemberEntity;
import kd.fi.bcm.business.util.OlapUtils;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.DimDataSourceEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.QFBuilder;

@DataEntityTypeAttribute
public class DimProcessEntity
extends DimMemberEntity {
    private static WatchLogger logger = BcmLogFactory.getWatchLogInstance(DimProcessEntity.class);
    private String dataSource;
    private boolean isBizrule;
    private static String[] nums = new String[]{"IRpt", "CS", "SRPT", "SIRPT"};
    private static List<String> ADJ_DATASOURCE_PROCESS = Arrays.asList("CCADJ", "EJE", "CADJ", "ADJ", "RAdj", "ERAdj", "SADJ", "SCADJ", "SCCADJ", "DADJ", "SEJE", "DEJE", "TADJ", "SRPT", "SEIT", "SECF", "SEIC", "SEOE", "SEOther");
    private static List<String> NOT_BIZ_RULE_PROCESS = Arrays.asList("SADJ", "SCADJ", "SCCADJ", "SEJE", "SRPT", "SEIT", "SECF", "SEIC", "SEOE", "SEOther", "EIT", "ECF", "EICA", "EOE", "EOther");

    @SimplePropertyAttribute(name="isbizrule")
    public boolean isBizrule() {
        return this.isBizrule;
    }

    public void setBizrule(boolean bizrule) {
        this.isBizrule = bizrule;
    }

    @SimplePropertyAttribute(name="datasource")
    public String getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    protected Map<String, List<String>> getNewOldNumberMap() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(16);
        result.put("ARPT", Arrays.asList("ARpt", "Arpt"));
        result.put("Rpt", Collections.singletonList("PC"));
        result.put("SRPT", Collections.singletonList("SIRpt"));
        return result;
    }

    @Override
    protected List<String> getReplaceNumbers() {
        return Arrays.asList("ARpt", "Arpt", "PC", "SIRpt");
    }

    @Override
    protected List<String> getDeleteNumbers() {
        ArrayList<String> deleteMembers = new ArrayList<String>(10);
        deleteMembers.add("CS");
        deleteMembers.add("TRpt");
        return deleteMembers;
    }

    @Override
    protected String getSelectField() {
        return super.getSelectField() + ",datasource,isbizrule";
    }

    @Override
    protected void setDefaultDataSource(List<DynamicObject> load) {
        List<String> deleteNumbers = this.getDeleteNumbers();
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        for (DynamicObject dyn : load) {
            String ds = dyn.getString("datasource");
            String number = dyn.getString("number");
            if (!deleteNumbers.contains(number) && dyn.getBoolean("isleaf")) {
                if (ADJ_DATASOURCE_PROCESS.contains(number)) {
                    dyn.set("datasource", (Object)DimDataSourceEnum.ADJ.getIndex());
                    if (NOT_BIZ_RULE_PROCESS.contains(number)) {
                        dyn.set("isbizrule", (Object)Character.valueOf('0'));
                    } else {
                        dyn.set("isbizrule", (Object)Character.valueOf('1'));
                    }
                    list.add(dyn);
                } else if (StringUtils.isEmpty((String)ds)) {
                    dyn.set("datasource", (Object)DimDataSourceEnum.RPT.getIndex());
                    dyn.set("isbizrule", (Object)Character.valueOf('1'));
                    list.add(dyn);
                }
            }
            if (!"EJE".equalsIgnoreCase(number) && !"SEJE".equalsIgnoreCase(number) || dyn.getBoolean("isleaf")) continue;
            dyn.set("storagetype", (Object)StorageTypeEnum.DYNAMIC.getOIndex());
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    @Override
    protected void afterSave(List<DynamicObject> obj) {
        super.afterSave(obj);
        QFilter modelFilter = new QFilter("model", "=", (Object)this.getModelId());
        QFilter rptFilter = new QFilter("number", "=", (Object)"Rpt");
        QFilter shareFilter = new QFilter("storagetype", "=", (Object)"3");
        QFilter noShareFilter = new QFilter("storagetype", "!=", (Object)"3");
        boolean hasShareRpt = QueryServiceHelper.exists((String)"bcm_processmembertree", (QFilter[])new QFilter[]{modelFilter, rptFilter, shareFilter});
        if (!hasShareRpt) {
            QFilter tarptFilter = new QFilter("number", "=", (Object)"TARPT");
            DynamicObject RptMemberID = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_processmembertree", (String)"id", (QFilter[])new QFilter[]{modelFilter, noShareFilter, rptFilter});
            DynamicObject RptMember = BusinessDataServiceHelper.loadSingleFromCache((Object)RptMemberID.get("id"), (String)"bcm_processmembertree");
            DynamicObject TarptMember = BusinessDataServiceHelper.loadSingleFromCache((String)"bcm_processmembertree", (String)"id,level,longnumber", (QFilter[])new QFilter[]{modelFilter, tarptFilter});
            AddNewShareMemberUtil.addNewProcessShareMember(RptMember, TarptMember);
            ShareNodeStructSyncHelper.resyncShareNodeStructure("bcm_processmembertree", this.getModelId(), this.getDimensionId());
        }
        OlapServiceHelper.alterSingleMemberName(this.getModelNumber(), this.getDimNumber(), "ARpt", "ARPT");
        if (!ConfigServiceHelper.getGlobalBoolParam("isForbiddenCsToIRpt")) {
            Set<String> objects = OlapServiceHelper.batCheckMemberIsExistOlap(this.getDimNumber(), nums, this.getModelNumber());
            ArrayList<String> existObjs = new ArrayList<String>(10);
            for (int i = 0; i < nums.length; ++i) {
                boolean existFlag = true;
                Iterator<String> it = objects.iterator();
                while (it.hasNext()) {
                    if (!nums[i].equals(it.next())) continue;
                    existFlag = false;
                }
                if (!existFlag) continue;
                existObjs.add(nums[i]);
            }
            Collection yearAllNode = MemberReader.getAllNodeByDimNum((String)PresetConstant.FY_DIM, (String)this.getModelNumber());
            Collection periodAllNode = MemberReader.getAllNodeByDimNum((String)PresetConstant.PERIOD_DIM, (String)this.getModelNumber());
            List yearList = yearAllNode.stream().map(IDNumberTreeNode::getNumber).filter(r -> !r.equals(PresetConstant.FY_DIM)).collect(Collectors.toList());
            List periodList = periodAllNode.stream().map(IDNumberTreeNode::getNumber).filter(r -> !r.equals(PresetConstant.PERIOD_DIM)).collect(Collectors.toList());
            ArrayList<Pair> yearPeriodAllPair = new ArrayList<Pair>(10);
            for (Object yearNumber : yearList) {
                for (String periodNumber : periodList) {
                    yearPeriodAllPair.add(Pair.onePair((Object)yearNumber, (Object)periodNumber));
                }
            }
            if (existObjs.contains("IRpt") && existObjs.contains("CS")) {
                Object yearNumber;
                Set<String> orgNumsNotLeaf = this.getNotLeafMemberNum();
                yearNumber = orgNumsNotLeaf.iterator();
                while (yearNumber.hasNext()) {
                    String s = (String)yearNumber.next();
                    for (Pair yearPeriod : yearPeriodAllPair) {
                        RunScriptBuilder run = new RunScriptBuilder(this.getModelNumber());
                        run.addDimensionScope(PresetConstant.ENTITY_DIM, s);
                        run.addDimensionScope(PresetConstant.FY_DIM, (String)yearPeriod.p1);
                        run.addDimensionScope(PresetConstant.PERIOD_DIM, (String)yearPeriod.p2);
                        run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PROCESS_DIM, (Object)"IRpt"));
                        run.appendEqualSign();
                        run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PROCESS_DIM, (Object)"CS"));
                        run.endRunExpress();
                        run.runScript();
                    }
                }
            }
            if (existObjs.contains("SRPT") && existObjs.contains("SIRPT")) {
                for (Pair yearPeriod : yearPeriodAllPair) {
                    RunScriptBuilder run = new RunScriptBuilder(this.getModelNumber());
                    run.addDimensionScope(PresetConstant.FY_DIM, (String)yearPeriod.p1);
                    run.addDimensionScope(PresetConstant.PERIOD_DIM, (String)yearPeriod.p2);
                    run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PROCESS_DIM, (Object)"SRPT"));
                    run.appendEqualSign();
                    run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PROCESS_DIM, (Object)"SIRPT"));
                    run.endRunExpress();
                    run.runScript();
                }
            }
        }
        List<String> strs = Arrays.asList("CCADJ", "EJE", "CADJ", "ADJ");
        QFilter[] filters = new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("dimension", "=", (Object)this.getDimensionId()), new QFilter("number", "in", strs)};
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"id,storagetype", (QFilter[])filters, null);
        boolean flag = true;
        for (DynamicObject dot : query) {
            String storagetype = dot.getString("storagetype");
            if (!StorageTypeEnum.STORAGE.index.equals(storagetype) && !StorageTypeEnum.UNSHARE.index.equals(storagetype)) continue;
            if (flag) {
                if (!OlapServiceHelper.existAggShieldRule(this.getModelNumber(), "E")) {
                    DeleteServiceHelper.delete((String)"bcm_aggshieldrule", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)this.getModelId()), new QFilter("rule", "=", (Object)"E")});
                }
                flag = false;
            }
            ShieldRuleBulider srb = new ShieldRuleBulider(this.getModelId());
            long srid = srb.getShieldRule(this.getDimensionId(), "E");
            srb.save(this.getDimensionId(), dot.getLong("id"), srid);
        }
        DimProcessEntity.aggEIRptAndEAdj(this.getModelNumber());
    }

    public static void aggEIRptAndEAdj(String modelNumber) {
        try {
            HashMap<String, List<AggFactorMetadataItem>> aggMap = new HashMap<String, List<AggFactorMetadataItem>>(16);
            aggMap.put("EIRpt", Collections.singletonList(OlapUtils.createAggFactorMetadataItem("IRpt", 1)));
            aggMap.put("ERAdj", Collections.singletonList(OlapUtils.createAggFactorMetadataItem("RAdj", 1)));
            OlapServiceHelper.batchRepairAggFactor(modelNumber, DimEntityNumEnum.PROCESS.getNumber(), aggMap);
            HashMap<String, MemberStorageTypes> storageMap = new HashMap<String, MemberStorageTypes>(16);
            storageMap.put("EIRpt", MemberStorageTypes.DynamicCalc);
            storageMap.put("ERAdj", MemberStorageTypes.DynamicCalc);
            OlapServiceHelper.batchAlterMemberStorageType(modelNumber, DimEntityNumEnum.PROCESS.getNumber(), storageMap);
        }
        catch (Exception ex) {
            logger.error((Throwable)ex);
        }
    }

    private Set<String> getNotLeafMemberNum() {
        HashSet<Long> parentIds = new HashSet<Long>(16);
        HashSet<String> orgNumsNotLeafNumber = new HashSet<String>(16);
        QFBuilder orgQf = new QFBuilder();
        orgQf.add("model", "=", (Object)this.getModelId());
        DynamicObjectCollection allMembers = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,parent.id,number", (QFilter[])orgQf.toArray());
        for (DynamicObject member : allMembers) {
            parentIds.add(member.getLong("parent.id"));
        }
        for (DynamicObject member : allMembers) {
            if (!parentIds.contains(member.getLong("id"))) continue;
            orgNumsNotLeafNumber.add(member.getString("number"));
        }
        orgNumsNotLeafNumber.remove("RateEntity");
        orgNumsNotLeafNumber.remove("RatePreset");
        return orgNumsNotLeafNumber;
    }
}

