/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bcm.business.upgrade.DimNodeType;
import kd.fi.bcm.business.upgrade.DimensionCircleNode;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.common.enums.StorageTypeEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class DimensionNode {
    private DynamicObject dyn;
    private DynamicObject shareDyn;
    private long id;
    private long memberId;
    private long parent;
    private boolean isLeaf;
    private String storageType;
    private String aggoprt;
    private Date modifyTime;
    private String modifier;
    private String number;
    private String longNumber;
    private Integer dseq;
    private DimNodeType nodeType;
    private Map<String, Object> propExtend = new HashMap<String, Object>(8);
    private static final int maxLevel = 500;

    public DimensionNode(DynamicObject dyn) {
        if (dyn != null) {
            this.dyn = dyn;
            DataEntityPropertyCollection properties = dyn.getDataEntityType().getProperties();
            this.id = dyn.getLong("id");
            this.parent = DimensionNode.getLongCompatible(dyn, "parent");
            this.storageType = dyn.getString("storagetype");
            this.isLeaf = dyn.getBoolean("isleaf");
            long copyfrom = DimensionNode.getLongCompatible(dyn, "copyfrom");
            this.memberId = copyfrom == 0L ? this.id : copyfrom;
            this.aggoprt = !"bcm_structofextend".equals(dyn.getDynamicObjectType().getName()) ? dyn.getString("aggoprt") : "";
            this.modifyTime = dyn.getDate("modifytime");
            if (properties.get((Object)"modifier") != null) {
                this.modifier = dyn.getString("modifier");
            }
            this.number = dyn.getString("number");
            this.dseq = dyn.getInt("dseq");
            this.nodeType = StorageTypeEnum.SHARE.getOIndex().equals(this.storageType) ? DimNodeType.SHARE_E : DimNodeType.STORE;
        }
    }

    public DimensionNode(DynamicObject dyn, DynamicObject shareDyn) {
        this(dyn);
        if (shareDyn != null) {
            this.dyn = dyn == null ? shareDyn : dyn;
            this.shareDyn = shareDyn;
            this.id = shareDyn.getLong("id");
            this.parent = DimensionNode.getLongCompatible(shareDyn, "parent");
            this.storageType = StorageTypeEnum.SHARE.getOIndex();
            long copyfrom = DimensionNode.getLongCompatible(shareDyn, "copyfrom");
            this.memberId = copyfrom == 0L ? this.id : copyfrom;
            this.isLeaf = this.dyn.getBoolean("isleaf");
            this.aggoprt = shareDyn.getString("aggoprt");
            this.modifyTime = shareDyn.getDate("modifytime");
            DataEntityPropertyCollection properties = shareDyn.getDataEntityType().getProperties();
            if (properties.get((Object)"modifier") != null) {
                this.modifier = shareDyn.getString("modifier");
            }
            this.number = this.dyn.getString("number");
            this.dseq = shareDyn.getInt("dseq");
            this.nodeType = DimNodeType.SHARE_E;
        }
    }

    private static DimensionTree<String, DimensionNode> createDimensionTree(DynamicObject[] members) {
        if (members == null || members.length == 0) {
            return null;
        }
        DimensionTree root = null;
        LinkedHashMap<Long, DimensionTree<String, DimensionNode>> allIdMap = new LinkedHashMap<Long, DimensionTree<String, DimensionNode>>(members.length);
        for (DynamicObject obj : members) {
            long id = DimensionNode.getLongCompatible(obj, "id");
            String number = obj.getString("number");
            DimensionTree<String, DimensionNode> member = new DimensionTree<String, DimensionNode>(number, new DimensionNode(obj));
            allIdMap.put(id, member);
        }
        for (DimensionTree value : allIdMap.values()) {
            DimensionNode node = (DimensionNode)value.getData();
            long pid = node.getParent();
            if (pid != 0L) {
                DimensionTree parent = (DimensionTree)allIdMap.get(pid);
                if (parent == null && root == null) {
                    root = value;
                }
                if (parent == null) continue;
                DimensionNode.addChild(parent, value, true);
                continue;
            }
            root = value;
        }
        return root;
    }

    public static List<DimensionCircleNode> checkDimTreeCircleWithPath(DynamicObject[] objs) {
        DimensionTree<String, DimensionNode> root = DimensionNode.createDimensionTree(objs);
        if (root == null) {
            return Collections.EMPTY_LIST;
        }
        return root.checkCircleWithPath(x -> new DimensionCircleNode(((DimensionNode)x.getData()).getNumber()));
    }

    public static DimensionTree<String, DimensionNode> createDimTreeWithShareRef(DynamicObject[] members) {
        DimensionTree<String, DimensionNode> root = DimensionNode.createDimensionTree(members);
        DimensionTree.sort(root);
        return root;
    }

    private static <K, V> void addChild(DimensionTree<K, V> parent, DimensionTree<K, V> child, boolean setParent) {
        parent.getChildren().add(child);
        if (setParent) {
            child.setParent(parent);
        }
    }

    public static void refChildren(DimensionTree<String, DimensionNode> nodeShared, DimensionTree<String, DimensionNode> nodeStored, int cursor) {
        DimensionNode rootSharedNode = nodeShared.getData();
        if (cursor > 500) {
            return;
        }
        for (DimensionTree<String, DimensionNode> storedChild : nodeStored.getChildren()) {
            DimensionNode storedNode = storedChild.getData();
            DimensionNode sharedNode = new DimensionNode(storedNode.getDyn(), storedNode.getShareDyn());
            DimensionTree<String, DimensionNode> sharedChild = new DimensionTree<String, DimensionNode>(storedNode.getNumber(), sharedNode);
            sharedNode.setParent(rootSharedNode.getId());
            sharedNode.setLeaf(storedNode.isLeaf());
            if (StorageTypeEnum.SHARE.getOIndex().equals(rootSharedNode.getStorageType())) {
                sharedNode.setId(GlobalIdUtil.genGlobalLongId());
                sharedNode.setNodeType(DimNodeType.SHARE_V);
                sharedNode.setStorageType(StorageTypeEnum.SHARE.getOIndex());
                if (Objects.nonNull(sharedNode.getShareDyn())) {
                    sharedNode.setAggoprt(sharedNode.getShareDyn().getString("aggoprt"));
                } else {
                    sharedNode.setAggoprt(sharedNode.getDyn().getString("aggoprt"));
                }
            } else {
                sharedNode.setId(storedNode.getId());
                sharedNode.setStorageType(storedNode.getStorageType());
            }
            DimensionNode.refChildren(sharedChild, storedChild, cursor + 1);
            DimensionNode.addChild(nodeShared, sharedChild, true);
        }
    }

    public static void refChildrenOfDim(DimensionTree<String, DimensionNode> nodeShared, DimensionTree<String, DimensionNode> nodeStored, int cursor, String menberentityid) {
        DimensionNode rootSharedNode = nodeShared.getData();
        if (cursor > 500) {
            return;
        }
        DynamicObjectCollection childs = null;
        if (StorageTypeEnum.SHARE.getOIndex().equals(rootSharedNode.getStorageType())) {
            long sharePId = rootSharedNode.getId();
            QFilter qf = new QFilter("parent", "=", (Object)sharePId);
            childs = QueryServiceHelper.query((String)menberentityid, (String)"id,number", (QFilter[])qf.toArray());
        }
        for (DimensionTree<String, DimensionNode> storedChild : nodeStored.getChildren()) {
            DimensionNode storedNode = storedChild.getData();
            DimensionNode sharedNode = new DimensionNode(storedNode.getDyn(), storedNode.getShareDyn());
            DimensionTree<String, DimensionNode> sharedChild = new DimensionTree<String, DimensionNode>(storedNode.getNumber(), sharedNode);
            sharedNode.setParent(rootSharedNode.getId());
            sharedNode.setLeaf(storedNode.isLeaf());
            if (StorageTypeEnum.SHARE.getOIndex().equals(rootSharedNode.getStorageType())) {
                Optional<DynamicObject> shareNode;
                long shardNodeId = 0L;
                if (childs != null && childs.size() > 0 && (shareNode = childs.stream().filter(x -> x.getString("number").equals(storedNode.getDyn().getString("number"))).findFirst()).isPresent()) {
                    shardNodeId = shareNode.get().getLong("id");
                }
                if (shardNodeId == 0L) {
                    shardNodeId = GlobalIdUtil.genGlobalLongId();
                }
                sharedNode.setId(shardNodeId);
                sharedNode.setNodeType(DimNodeType.SHARE_V);
                sharedNode.setStorageType(StorageTypeEnum.SHARE.getOIndex());
                if (Objects.nonNull(sharedNode.getShareDyn())) {
                    sharedNode.setAggoprt(sharedNode.getShareDyn().getString("aggoprt"));
                } else {
                    sharedNode.setAggoprt(sharedNode.getDyn().getString("aggoprt"));
                }
            } else {
                sharedNode.setId(storedNode.getId());
                sharedNode.setStorageType(storedNode.getStorageType());
            }
            DimensionNode.refChildren(sharedChild, storedChild, cursor + 1);
            DimensionNode.addChild(nodeShared, sharedChild, true);
        }
    }

    public static void updateLongNumber(DimensionTree<String, DimensionNode> tree) {
        tree.dfs(t -> {
            DimensionNode data = (DimensionNode)t.getData();
            String number = data.getNumber();
            DimensionTree parent = t.getParent();
            if (parent == null) {
                String longNumber = data.getLongNumber();
                if (longNumber == null) {
                    data.setLongNumber(number);
                }
            } else {
                String pln = ((DimensionNode)parent.getData()).getLongNumber();
                data.setLongNumber(String.join((CharSequence)"!", pln, number));
            }
        });
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public long getParent() {
        return this.parent;
    }

    public void setParent(long parent) {
        this.parent = parent;
    }

    public boolean isLeaf() {
        return this.isLeaf;
    }

    public void setLeaf(boolean leaf) {
        this.isLeaf = leaf;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public DynamicObject getDyn() {
        return this.dyn;
    }

    public void setDyn(DynamicObject dyn) {
        this.dyn = dyn;
        this.number = dyn.getString("number");
        this.isLeaf = dyn.getBoolean("isleaf");
    }

    public long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(long memberId) {
        this.memberId = memberId;
    }

    public DynamicObject getShareDyn() {
        return this.shareDyn;
    }

    public String getAggoprt() {
        return this.aggoprt;
    }

    public void setAggoprt(String aggoprt) {
        this.aggoprt = aggoprt;
    }

    public String getNumber() {
        return this.number;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public String getLongNumber() {
        return this.longNumber;
    }

    public void setLongNumber(String longNumber) {
        this.longNumber = longNumber;
    }

    public DimNodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(DimNodeType nodeType) {
        this.nodeType = nodeType;
    }

    public Object getPropExtend(String propName) {
        return this.propExtend.get(propName);
    }

    public void setPropExtend(String propName, Object value) {
        this.propExtend.put(propName, value);
    }

    public static long getLongCompatible(DynamicObject dyn, String prop) {
        return Objects.isNull(dyn.get(prop)) ? 0L : (dyn.get(prop) instanceof Long ? dyn.getLong(prop) : dyn.getDynamicObject(prop).getLong("id"));
    }

    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
    }

    public Integer getDseq() {
        return this.dseq;
    }

    public void setDseq(Integer dseq) {
        this.dseq = dseq;
    }
}

