/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.property.BasedataProp;
import kd.fi.bcm.business.upgrade.DimensionCircleNode;
import kd.fi.bcm.business.upgrade.DimensionNode;
import org.apache.commons.collections.CollectionUtils;

public class DimensionTree<K, V> {
    private K key;
    private V data;
    private DimensionTree<K, V> parent;
    private List<DimensionTree<K, V>> children;

    public DimensionTree(K key, V data) {
        this.key = key;
        this.data = data;
        this.children = new ArrayList<DimensionTree<K, V>>(4);
    }

    public static DimensionTree<String, DynamicObject> createTreeFromDyn(DynamicObject[] objs) {
        if (objs == null || objs.length == 0) {
            return null;
        }
        boolean isBaseData = objs[0].getDataEntityType().getProperties().get((Object)"parent") instanceof BasedataProp;
        String parentIdField = isBaseData ? "parent_id" : "parent";
        DimensionTree result = null;
        LinkedHashMap<Long, DimensionTree<String, DynamicObject>> idTreeMap = new LinkedHashMap<Long, DimensionTree<String, DynamicObject>>(16);
        for (DynamicObject obj : objs) {
            long id = obj.getLong("id");
            String number = obj.getString("number");
            DimensionTree<String, DynamicObject> member = new DimensionTree<String, DynamicObject>(number, obj);
            idTreeMap.put(id, member);
        }
        for (DimensionTree value : idTreeMap.values()) {
            DynamicObject obj = (DynamicObject)value.getData();
            long pid = obj.getLong(parentIdField);
            if (pid == 0L) {
                result = value;
                continue;
            }
            DimensionTree parent = (DimensionTree)idTreeMap.get(pid);
            if (parent == null) continue;
            DimensionTree.addChild(parent, value);
        }
        return result;
    }

    private static <K, V> void addChild(DimensionTree<K, V> parent, DimensionTree<K, V> child) {
        List<DimensionTree<K, V>> children = parent.getChildren();
        if (children == null) {
            children = new ArrayList<DimensionTree<K, V>>(10);
            children.add(child);
            parent.setChildren(children);
        } else {
            children.add(child);
        }
        child.setParent(parent);
    }

    public static void main(String[] args) {
        DimensionTree<String, Integer> tree1 = new DimensionTree<String, Integer>("1", 1);
        DimensionTree<String, Integer> tree2 = new DimensionTree<String, Integer>("2", 2);
        DimensionTree<String, Integer> tree3 = new DimensionTree<String, Integer>("3", 3);
        DimensionTree<String, Integer> tree4 = new DimensionTree<String, Integer>("4", 4);
        tree1.getChildren().add(tree2);
        List<DimensionTree<String, Integer>> children = tree2.getChildren();
        children.add(tree3);
        children.add(tree4);
        tree4.getChildren().add(tree1);
    }

    public boolean checkCircle(Function<DimensionTree, DimensionCircleNode> buildCircleNodeFunc) {
        LinkedHashSet<DimensionCircleNode> visited = new LinkedHashSet<DimensionCircleNode>(10);
        return this._checkCircle(visited, buildCircleNodeFunc).isPresent();
    }

    public List<DimensionCircleNode> checkCircleWithPath(Function<DimensionTree, DimensionCircleNode> buildCircleNodeFunc) {
        LinkedHashSet<DimensionCircleNode> visited = new LinkedHashSet<DimensionCircleNode>(10);
        Optional<DimensionCircleNode> keyNode = this._checkCircle(visited, buildCircleNodeFunc);
        if (keyNode.isPresent()) {
            ArrayList<DimensionCircleNode> circlePath = new ArrayList<DimensionCircleNode>(visited);
            circlePath.add(keyNode.get());
            return circlePath;
        }
        return Collections.EMPTY_LIST;
    }

    private Optional<DimensionCircleNode> _checkCircle(Set<DimensionCircleNode> visited, Function<DimensionTree, DimensionCircleNode> buildCircleNodeFunc) {
        DimensionCircleNode curNode = buildCircleNodeFunc.apply(this);
        if (visited.contains(curNode)) {
            return Optional.of(curNode);
        }
        visited.add(curNode);
        for (DimensionTree<K, V> child : this.getChildren()) {
            Optional<DimensionCircleNode> keyNode = super._checkCircle(visited, buildCircleNodeFunc);
            if (!keyNode.isPresent()) continue;
            return keyNode;
        }
        visited.remove(curNode);
        return Optional.empty();
    }

    public void dfs(Consumer<DimensionTree<K, V>> consumer) {
        this.dfsPreOrder(consumer);
    }

    public void dfsPreOrder(Consumer<DimensionTree<K, V>> consumer) {
        consumer.accept(this);
        for (DimensionTree<K, V> child : this.getChildren()) {
            child.dfsPreOrder(consumer);
        }
    }

    public void dfsPostTravel(Consumer<DimensionTree<K, V>> consumer) {
        for (DimensionTree<K, V> child : this.getChildren()) {
            child.dfsPostTravel(consumer);
        }
        consumer.accept(this);
    }

    public void dfsWithoutRoot(BiConsumer<DimensionTree<K, V>, Integer> consumer, Integer startRow) {
        int[] row = new int[]{startRow};
        for (DimensionTree<K, V> child : this.getChildren()) {
            super._dfsWithIdx(consumer, row);
        }
    }

    public void dfsWithIdx(BiConsumer<DimensionTree<K, V>, Integer> consumer, Integer startRow) {
        int[] row = new int[]{startRow};
        this._dfsWithIdx(consumer, row);
    }

    private void _dfsWithIdx(BiConsumer<DimensionTree<K, V>, Integer> consumer, int[] idx) {
        int n = idx[0];
        idx[0] = n + 1;
        consumer.accept(this, n);
        for (DimensionTree<K, V> child : this.getChildren()) {
            super._dfsWithIdx(consumer, idx);
        }
    }

    public void bfs(Consumer<DimensionTree<K, V>> consumer) {
        consumer.accept(this);
        LinkedList<DimensionTree<K, V>> list = new LinkedList<DimensionTree<K, V>>();
        list.addLast(this);
        while (list.size() > 0) {
            DimensionTree next = (DimensionTree)list.removeFirst();
            for (DimensionTree<K, V> child : this.getChildren()) {
                consumer.accept(child);
                list.addLast(child);
            }
        }
    }

    public int count() {
        int[] count = new int[]{0};
        this.dfs(c -> {
            count[0] = count[0] + 1;
        });
        return count[0];
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getData() {
        return this.data;
    }

    public void setData(V data) {
        this.data = data;
    }

    public DimensionTree<K, V> getParent() {
        return this.parent;
    }

    public void setParent(DimensionTree<K, V> parent) {
        this.parent = parent;
    }

    public List<DimensionTree<K, V>> getChildren() {
        return this.children;
    }

    public void setChildren(List<DimensionTree<K, V>> children) {
        this.children = children;
    }

    public String toString() {
        return this.data == null ? "null" : this.data.toString();
    }

    public static void sort(DimensionTree<String, DimensionNode> node) {
        if (node != null && CollectionUtils.isNotEmpty(node.getChildren())) {
            node.getChildren().sort(Comparator.comparingInt(t -> ((DimensionNode)t.getData()).getDseq() == null ? 0 : ((DimensionNode)t.getData()).getDseq()));
            node.getChildren().forEach(c -> DimensionTree.sort(c));
        }
    }
}

