/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.dimension.helper.DimensionServiceHelper;
import kd.fi.bcm.business.dimension.helper.DynamicComputingServiceHelper;
import kd.fi.bcm.business.dimension.predimensionhelper.DimensionXmlFactory;
import kd.fi.bcm.business.olap.dynamic.DynamicOlapHelper;
import kd.fi.bcm.business.script.run.RunScriptBuilder;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.serviceHelper.OlapServiceHelper;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.ConfigCM005UpgradeService;
import kd.fi.bcm.business.upgrade.DimMemberEntity;
import kd.fi.bcm.business.upgrade.DimensionTree;
import kd.fi.bcm.business.upgrade.DimensionXmlReader;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.PairList;
import kd.fi.bcm.common.PresetConstant;
import kd.fi.bcm.common.cache.IDNumberTreeNode;
import kd.fi.bcm.common.cache.MemberReader;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.CslSchemeEnum;
import kd.fi.bcm.common.enums.DimEntityNumEnum;
import kd.fi.bcm.common.enums.config.ConfigEnum;
import kd.fi.bcm.common.enums.dimension.SysDimensionEnum;
import kd.fi.bcm.common.util.QFBuilder;
import kd.fi.bcm.common.util.ThrowableHelper;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DimensionUpgradeIService
extends AbstractUpgradeService {
    private static final ApplicationTypeEnum[] APPS = new ApplicationTypeEnum[]{ApplicationTypeEnum.CM};
    private static final String[] DIMS = new String[]{"Process", "AuditTrail", "Currency"};
    private static final String ENTITY_RATE_ENTITY = "Entity!RateEntity";
    private long modelId;
    private String cubeNumber;
    private long dimensionId;
    private String dimNumber;
    DynamicObject[] rateViewDys;
    DynamicObject[] rateRootDys;
    DynamicObject[] orgCslSchemeDys;
    DynamicObject[] orgViewDys;
    List<Consumer<Long>> saveConsumers = new ArrayList<Consumer<Long>>(3);
    private SAXReader saxReader;

    public Map<String, Object> upgrade(List<Pair<Long, String>> pairs) {
        Set<Long> models = pairs.stream().map(x -> (Long)x.p1).collect(Collectors.toSet());
        this.updateOrgView(models);
        this.updateRateView(models);
        this.addRateRoot(models);
        this.updateOrgCslscheme(models);
        Map<String, Long> dimMap = this.getDimMap(models);
        for (ApplicationTypeEnum app : APPS) {
            String[] stringArray = DIMS;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String dim;
                this.dimNumber = dim = stringArray[i];
                String xmlPath = DimensionXmlFactory.getXmlName(dim, app);
                SAXReader reader = this.getSAXReader();
                try (InputStream resourceAsStream = this.getClass().getResourceAsStream(xmlPath);){
                    Document document = reader.read(resourceAsStream);
                    Element rootElement = document.getRootElement();
                    Element rootMember = null;
                    List elements = rootElement.elements();
                    for (Object element : elements) {
                        Element ele = (Element)element;
                        String name = ele.getName();
                        if (!"membertree".equals(name)) continue;
                        rootMember = ele;
                        break;
                    }
                    if (rootMember == null) continue;
                    IDataEntityType clrType = DimMemberEntity.getDataEntityType(dim);
                    DimensionXmlReader dc = new DimensionXmlReader(clrType);
                    DimMemberEntity newEntity = (DimMemberEntity)dc.readObject(rootMember, null);
                    String entityNumber = DimensionServiceHelper.getDimMembEntityNumByDimNum(dim.toLowerCase(Locale.ENGLISH));
                    MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entityNumber);
                    for (Pair<Long, String> pair : pairs) {
                        this.modelId = (Long)pair.p1;
                        this.cubeNumber = (String)pair.p2;
                        this.dimensionId = dimMap.get(dim + this.modelId);
                        QFilter filter = new QFilter("model", "=", pair.p1);
                        if (newEntity == null) continue;
                        String sel = newEntity.getSelectField();
                        TXHandle handle = TX.required();
                        Throwable throwable = null;
                        try {
                            try {
                                DynamicObject[] load = BusinessDataServiceHelper.load((String)entityNumber, (String)sel, (QFilter[])new QFilter[]{filter}, null);
                                this.saveConsumers.add(this.handleData(dt, clrType, newEntity, load));
                            }
                            catch (Throwable e) {
                                handle.markRollback();
                                throw new RuntimeException(e);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (handle == null) continue;
                            if (throwable != null) {
                                try {
                                    handle.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            handle.close();
                        }
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(ThrowableHelper.printError((Throwable)e), e);
                }
            }
        }
        return null;
    }

    private void updateRateView(Set<Long> models) {
        QFilter qf = new QFilter("number", "in", (Object)new String[]{"DefaultRateScheme", "root"}).and("model", "in", models);
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,model,number", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> ids = new ArrayList<Long>(models);
        HashMap<Long, Long> map = new HashMap<Long, Long>(16);
        for (DynamicObject dynamicObject : dyc) {
            if ("DefaultRateScheme".equals(dynamicObject.getString("number"))) {
                ids.remove(dynamicObject.getLong("model"));
                continue;
            }
            if (!"root".equals(dynamicObject.getString("number"))) continue;
            map.put(dynamicObject.getLong("model"), dynamicObject.getLong("id"));
        }
        DynamicObject[] dynamicObjects = new DynamicObject[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"bcm_cslscheme");
            obj.set("number", (Object)"DefaultRateScheme");
            obj.set("name", (Object)CslSchemeEnum.DefaultRate.getName());
            obj.set("model", (Object)ids.get(i));
            obj.set("isleaf", (Object)1);
            obj.set("isenable", (Object)CslSchemeEnum.DefaultRate.isIsenable());
            obj.set("nodetype", (Object)CslSchemeEnum.DefaultRate.getNodetype());
            obj.set("level", (Object)CslSchemeEnum.DefaultRate.getLevel());
            obj.set("longnumber", (Object)CslSchemeEnum.DefaultRate.getLongnumber());
            RequestContext tx = RequestContext.get();
            obj.set("creater", (Object)tx.getUserId());
            obj.set("modifier", (Object)tx.getUserId());
            obj.set("islegalorgview", (Object)1);
            obj.set("parent", map.get(ids.get(i)));
            obj.set("createdate", (Object)BCMConstant.PRESET_CREATE_TIME);
            obj.set("modifytime", (Object)BCMConstant.PRESET_CREATE_TIME);
            dynamicObjects[i] = obj;
        }
        this.rateViewDys = dynamicObjects;
    }

    private void addRateRoot(Set<Long> models) {
        QFilter qf = new QFilter("number", "=", (Object)"RateEntity").and("model", "in", models);
        DynamicObjectCollection dyc = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,model", (QFilter[])new QFilter[]{qf});
        ArrayList<Long> ids = new ArrayList<Long>(models);
        for (DynamicObject dynamicObject : dyc) {
            ids.remove(dynamicObject.getLong("model"));
        }
        DynamicObject[] dynamicObjects = new DynamicObject[ids.size()];
        for (int i = 0; i < ids.size(); ++i) {
            DynamicObject rateRootMember = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymember");
            DimensionServiceHelper.initDimensionDyObjectWithOrg(rateRootMember);
            rateRootMember.set("name", (Object)ResManager.loadKDString((String)"\u9ed8\u8ba4\u6c47\u7387\u6839\u7ec4\u7ec7", (String)"DimensionUpgradeIService_0", (String)"fi-bcm-business", (Object[])new Object[0]));
            rateRootMember.set("number", (Object)"RateEntity");
            rateRootMember.set("model", (Object)ids.get(i));
            QFilter qFilter = new QFilter("model", "=", (Object)ids.get(i));
            qFilter.and("number", "=", (Object)"Entity");
            DynamicObject col = QueryServiceHelper.queryOne((String)"bcm_dimension", (String)"id", (QFilter[])new QFilter[]{qFilter});
            rateRootMember.set("dimension", col.get("id"));
            DimensionServiceHelper.initDimensionDyObject(rateRootMember);
            BusinessDataWriter.save((IDataEntityType)rateRootMember.getDynamicObjectType(), (Object[])new Object[]{rateRootMember});
            DynamicObject rateTree = BusinessDataServiceHelper.newDynamicObject((String)"bcm_entitymembertree");
            DimensionServiceHelper.initDimensionDyObject(rateTree);
            rateTree.set("model", (Object)ids.get(i));
            rateTree.set("dimension", col.get("id"));
            QFilter filter = new QFilter("model", "=", (Object)ids.get(i)).and("number", "=", (Object)"Entity");
            DynamicObject entity = BusinessDataServiceHelper.loadSingle((String)"bcm_entitymembertree", (String)"id,name", (QFilter[])new QFilter[]{filter});
            rateTree.set("parent", (Object)entity);
            rateTree.set("level", (Object)2);
            rateTree.set("member", (Object)rateRootMember);
            rateTree.set("storagetype", (Object)"4");
            rateTree.set("isleaf", (Object)false);
            rateTree.set("longnumber", (Object)ENTITY_RATE_ENTITY);
            rateTree.set("number", (Object)"RateEntity");
            rateTree.set("name", (Object)ResManager.loadKDString((String)"\u6c47\u7387\u7ec4\u7ec7", (String)"DimensionUpgradeIService_1", (String)"fi-bcm-business", (Object[])new Object[0]));
            rateTree.set("issysmember", (Object)"1");
            rateTree.set("isexchangerate", (Object)true);
            rateTree.set("dseq", (Object)"1000");
            dynamicObjects[i] = rateTree;
            QFilter qFilter1 = new QFilter("id", "=", (Object)ids.get(i));
            DynamicObject model = QueryServiceHelper.queryOne((String)"bcm_model", (String)"number,name", (QFilter[])new QFilter[]{qFilter1});
            OlapServiceHelper.createMember(model.getString("number"), "Entity", "RateEntity", 5, "Entity");
        }
        this.rateRootDys = dynamicObjects;
    }

    private void updateOrgCslscheme(Set<Long> models) {
        QFilter qFilter = new QFilter("model", "in", models);
        QFilter qFilter2 = new QFilter("ISEXCHANGERATE", "=", (Object)"1");
        DynamicObject[] eneitys = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"id,createtime,cslscheme,model,number,parent,level,longnumber,bizchangerds.bizmodifytime,bizchangerds.bizmodifier,bizchangerds.bizeffdate,bizchangerds.changetype", (QFilter[])new QFilter[]{qFilter, qFilter2});
        HashMap<Long, Long> parentIds = new HashMap<Long, Long>(16);
        for (DynamicObject eneity : eneitys) {
            if (!"RateEntity".equals(eneity.getString("number"))) continue;
            parentIds.put(eneity.getLong("model.id"), eneity.getLong("id"));
        }
        QFilter qf2 = new QFilter("number", "=", (Object)"DefaultRateScheme").and("model", "in", models);
        DynamicObjectCollection cslschemes = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,model", (QFilter[])new QFilter[]{qf2});
        DynamicObjectType entityType = eneitys[0].getDynamicObjectCollection("bizchangerds").getDynamicObjectType();
        for (DynamicObject entity : eneitys) {
            if (parentIds.get(entity.getLong("model.id")) == null) continue;
            if (!"RateEntity".equals(entity.getString("number"))) {
                entity.set("longnumber", (Object)("Entity!RateEntity!" + entity.getString("number")));
                entity.set("parent", parentIds.get(entity.getLong("model.id")));
                entity.set("level", (Object)3);
            }
            for (DynamicObject cslscheme : cslschemes) {
                if (entity.getLong("model.id") != cslscheme.getLong("model")) continue;
                entity.set("cslscheme", (Object)cslscheme.getLong("id"));
            }
            if (entity.getDynamicObjectCollection("bizchangerds").size() >= 1 || "RateEntity".equals(entity.getString("number")) || "RatePreset".equals(entity.getString("number"))) continue;
            DynamicObject tmpData = new DynamicObject(entityType);
            tmpData.set("bizmodifytime", (Object)entity.getDate("createtime"));
            tmpData.set("bizmodifier", (Object)1L);
            tmpData.set("bizeffdate", (Object)entity.getDate("createtime"));
            tmpData.set("changetype", (Object)1);
            entity.getDynamicObjectCollection("bizchangerds").add((Object)tmpData);
        }
        this.orgCslSchemeDys = eneitys;
    }

    private void updateOrgView(Set<Long> models) {
        DynamicObject[] load;
        HashMap<Long, Long> modelSchemeMap = new HashMap<Long, Long>(16);
        QFilter[] fitlers = new QFilter[]{new QFilter("model", "in", models), new QFilter("number", "=", (Object)"root"), new QFilter("parent", "=", (Object)0)};
        DynamicObjectCollection dync = QueryServiceHelper.query((String)"bcm_cslscheme", (String)"id,model", (QFilter[])fitlers, null);
        for (DynamicObject dyn : dync) {
            modelSchemeMap.put(dyn.getLong("model"), dyn.getLong("id"));
        }
        QFilter[] efilters = new QFilter[]{new QFilter("model", "in", modelSchemeMap.keySet()), new QFilter("number", "=", (Object)"Entity")};
        for (DynamicObject dyn : load = BusinessDataServiceHelper.load((String)"bcm_entitymembertree", (String)"cslscheme, model", (QFilter[])efilters, null)) {
            dyn.set("cslscheme", modelSchemeMap.get(dyn.getLong("model_id")));
        }
        this.orgViewDys = load;
    }

    private Consumer<Long> handleData(MainEntityType dt, IDataEntityType clrType, final DimMemberEntity entity, final DynamicObject[] load) {
        if ("bcm_processmembertree".equalsIgnoreCase(clrType.getName())) {
            this.backupBeforeMember(load, this.context);
        }
        DimensionTree<String, DynamicObject> root = DimensionTree.createTreeFromDyn(load);
        Map<String, DimensionTree<String, DynamicObject>> oldMap = this.getDimensionTreeMap(root);
        Set<String> newNumbers = this.updateEntityInfoHelper(entity, 1);
        ArrayList<DynamicObject> needUpdates = new ArrayList<DynamicObject>(10);
        final ArrayList<DynamicObject> needNews = new ArrayList<DynamicObject>(10);
        HashSet<String> allNumbers = new HashSet<String>(newNumbers);
        allNumbers.addAll(entity.getReplaceNumbers());
        this.updateDimMember(dt, clrType, entity, oldMap, allNumbers, needUpdates, needNews, 0L);
        entity.setModelNumber(this.cubeNumber);
        entity.setDimNumber(this.dimNumber);
        return new Consumer<Long>(){

            @Override
            public void accept(Long aLong) {
                entity.saveDyn(new ArrayList<DynamicObject>(Arrays.asList(load)), needNews, DimensionUpgradeIService.this.context);
            }
        };
    }

    private void checkData(DimensionTree<String, DynamicObject> root) {
        Map<String, String> map = this.getData(root);
        DimensionTree<String, Map<String, String>> checkTree = new DimensionTree<String, Map<String, String>>(root.getKey(), map);
        this.checkDataHelper(root, checkTree);
        System.out.println();
    }

    private void checkDataHelper(DimensionTree<String, DynamicObject> root, DimensionTree<String, Map<String, String>> checkTree) {
        List<DimensionTree<String, DynamicObject>> children = root.getChildren();
        if (children != null) {
            for (DimensionTree<String, DynamicObject> child : children) {
                Map<String, String> data = this.getData(child);
                DimensionTree<String, Map<String, String>> checkChild = new DimensionTree<String, Map<String, String>>(child.getKey(), data);
                checkChild.setParent(checkTree);
                List cc = checkTree.getChildren();
                if (cc == null) {
                    cc = new ArrayList<DimensionTree<String, Map<String, String>>>(10);
                    cc.add(checkChild);
                    checkTree.setChildren(cc);
                } else {
                    cc.add(checkChild);
                }
                this.checkDataHelper(child, checkChild);
            }
        }
    }

    private Map<String, String> getData(DimensionTree<String, DynamicObject> root) {
        DynamicObject data = root.getData();
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("id", data.getString("id"));
        map.put("number", data.getString("number"));
        map.put("longnumber", data.getString("longnumber"));
        map.put("parent", data.getString("parent_id"));
        map.put("level", data.getString("level"));
        map.put("dseq", data.getString("dseq"));
        map.put("isleaf", data.getString("isleaf"));
        return map;
    }

    private Map<String, DimensionTree<String, DynamicObject>> getDimensionTreeMap(DimensionTree<String, DynamicObject> root) {
        HashMap<String, DimensionTree<String, DynamicObject>> result = new HashMap<String, DimensionTree<String, DynamicObject>>(16);
        result.put(root.getKey(), root);
        List<DimensionTree<String, DynamicObject>> children = root.getChildren();
        if (children != null) {
            for (DimensionTree<String, DynamicObject> child : children) {
                result.putAll(this.getDimensionTreeMap(child));
            }
        }
        return result;
    }

    private Set<String> updateEntityInfoHelper(DimMemberEntity entity, int dseq) {
        HashSet<String> numbers = new HashSet<String>(16);
        numbers.add(entity.getNumber());
        this.updateEntityInfo(entity, dseq);
        int ddseq = 1;
        for (DimMemberEntity child : entity.getChildren()) {
            numbers.addAll(this.updateEntityInfoHelper(child, ddseq++));
        }
        return numbers;
    }

    private Map<String, Long> getDimMap(Set<Long> models) {
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        QFilter[] filters = new QFilter[]{new QFilter("model", "in", models)};
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"NewDimensionUpdateService.getDimMap", (String)"bcm_dimension", (String)"id,number,model", (QFilter[])filters, null);){
            for (Row d : ds) {
                map.put(d.getString("number") + d.getLong("model"), d.getLong("id"));
            }
        }
        return map;
    }

    private void updateDimMember(MainEntityType dt, IDataEntityType clrType, DimMemberEntity newEntity, Map<String, DimensionTree<String, DynamicObject>> oldEntityMap, Set<String> allNumbers, List<DynamicObject> needUpdates, List<DynamicObject> needNews, long parentId) {
        DynamicObject dyn;
        DimensionTree<String, DynamicObject> tree = this.getTreeByMapNumber(newEntity, oldEntityMap);
        if (tree == null) {
            dyn = newEntity.createDyn(dt, clrType);
            needNews.add(dyn);
            dyn.set("parent", (Object)parentId);
            dyn.set("parent_id", (Object)parentId);
        } else {
            dyn = tree.getData();
            boolean needUpdate = newEntity.updateDyn(dyn, clrType);
            if (!needUpdate) {
                long pid = dyn.getLong("parent_id");
                boolean bl = needUpdate = pid != parentId;
            }
            if (needUpdate) {
                needUpdates.add(dyn);
                dyn.set("parent", (Object)parentId);
                dyn.set("parent_id", (Object)parentId);
                List<DimensionTree<String, DynamicObject>> children = tree.getChildren();
                if (children != null) {
                    for (DimensionTree<String, DynamicObject> child : children) {
                        this.updateOldData(needUpdates, allNumbers, child);
                    }
                }
            }
        }
        for (DimMemberEntity child : newEntity.getChildren()) {
            this.updateDimMember(dt, clrType, child, oldEntityMap, allNumbers, needUpdates, needNews, dyn.getLong("id"));
        }
        OlapServiceHelper.syncDimensionShortNumber2Cube(this.context.getCube());
    }

    private DimensionTree<String, DynamicObject> getTreeByMapNumber(DimMemberEntity newEntity, Map<String, DimensionTree<String, DynamicObject>> oldEntityMap) {
        String number;
        Map<String, List<String>> newOldNumberMap = newEntity.getNewOldNumberMap();
        List<String> strs = newOldNumberMap.get(number = newEntity.getNumber());
        if (strs != null) {
            for (String str : strs) {
                DimensionTree<String, DynamicObject> tree = oldEntityMap.get(str);
                if (tree == null) continue;
                return tree;
            }
        }
        return oldEntityMap.get(number);
    }

    private void updateOldData(List<DynamicObject> needUpdates, Set<String> newNumbers, DimensionTree<String, DynamicObject> tree) {
        String key = tree.getKey();
        if (!newNumbers.contains(key)) {
            this.updateDynInfo(tree);
            needUpdates.add(tree.getData());
            List<DimensionTree<String, DynamicObject>> children = tree.getChildren();
            if (children != null) {
                for (DimensionTree<String, DynamicObject> child : children) {
                    this.updateOldData(needUpdates, newNumbers, child);
                }
            }
        }
    }

    private void updateDynInfo(DimensionTree<String, DynamicObject> tree) {
        DynamicObject data = tree.getData();
        DimensionTree<String, DynamicObject> parent = tree.getParent();
        if (parent != null) {
            DynamicObject pdata = parent.getData();
            data.set("level", (Object)(pdata.getInt("level") + 1));
            data.set("longnumber", (Object)String.join((CharSequence)"!", pdata.getString("longnumber"), data.getString("number")));
        }
    }

    private void updateEntityInfo(DimMemberEntity entity, int dseq) {
        entity.setModelId(this.modelId);
        entity.setDimensionId(this.dimensionId);
        entity.setDseq(dseq);
        DimMemberEntity parent = entity.getParent();
        int size = entity.getChildren().size();
        entity.setIsleaf(size == 0);
        if (parent == null) {
            entity.setLevel(1);
            entity.setLongNumber(entity.getNumber());
        } else {
            entity.setLevel(parent.getLevel() + 1);
            entity.setLongNumber(String.join((CharSequence)"!", parent.getLongNumber(), entity.getNumber()));
        }
    }

    private SAXReader getSAXReader() {
        if (this.saxReader == null) {
            this.saxReader = new SAXReader();
        }
        return this.saxReader;
    }

    public DimensionUpgradeIService(List<String> parentNumbers, String number, LocaleString name, UpgradeContext context) {
        super(parentNumbers, number, name, context);
    }

    @Override
    protected void saveData() {
        if (this.isUpgraded(this.context.getModelId())) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])this.orgViewDys);
        SaveServiceHelper.save((DynamicObject[])this.rateViewDys);
        SaveServiceHelper.save((DynamicObject[])this.rateRootDys);
        SaveServiceHelper.save((DynamicObject[])this.orgCslSchemeDys);
        for (Consumer<Long> saveConsumer : this.saveConsumers) {
            saveConsumer.accept(0L);
        }
    }

    @Override
    public void afterSaveData() {
        new ConfigCM005UpgradeService(Lists.newArrayList((Object[])new String[]{"dimension"}), "config", ResManager.getLocaleString((String)"\u7cfb\u7edf\u53c2\u6570", (String)"DimensionUpgradeIService_2", (String)"fi-bcm-business"), this.context).saveData();
        long modelId = this.context.getModelId();
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model", (String)"number");
        String modelCUBE = model.getString("number");
        DynamicComputingServiceHelper.lockUpgradeModelForChangeCM006(modelId);
        DynamicComputingServiceHelper.enableModelCM006(modelId);
        this.synchronizeDimensionMember(modelId, modelCUBE, SysDimensionEnum.Process.getNumber(), "bcm_processmembertree");
        this.synchronizeDimensionMember(modelId, modelCUBE, SysDimensionEnum.AuditTrail.getNumber(), "bcm_audittrialmembertree");
        this.synchronizeDimensionMember(modelId, modelCUBE, SysDimensionEnum.Currency.getNumber(), "bcm_currencymembertree");
        OlapServiceHelper.syncDimensionShortNumber2Cube(modelCUBE);
        this.updateProcessARpt2ARPT(modelId);
        this.updateProcessParentSonProperty(modelId);
        DynamicOlapHelper.setDynamicModel(modelId, modelCUBE, true);
        this.syncEntityParentSonFactors(modelCUBE);
        this.moveCubeHistoryData();
    }

    private void moveCubeHistoryData() {
        if (ConfigServiceHelper.getBoolParam(this.context.getModelId(), "isUpgradeExchangeRate")) {
            this.saveExchangeRate();
        }
        String modelNumber = MemberReader.findModelNumberById((Object)this.context.getModelId());
        Collection yearAllNode = MemberReader.getAllNodeByDimNum((String)PresetConstant.FY_DIM, (String)modelNumber);
        Collection periodAllNode = MemberReader.getAllNodeByDimNum((String)PresetConstant.PERIOD_DIM, (String)modelNumber);
        List yearList = yearAllNode.stream().map(IDNumberTreeNode::getNumber).filter(r -> !r.equals(PresetConstant.FY_DIM)).collect(Collectors.toList());
        List periodList = periodAllNode.stream().map(IDNumberTreeNode::getNumber).filter(r -> !r.equals(PresetConstant.PERIOD_DIM)).collect(Collectors.toList());
        ArrayList<Pair> yearPeriodAllPair = new ArrayList<Pair>(10);
        for (Object yearNumber : yearList) {
            for (String periodNumber : periodList) {
                yearPeriodAllPair.add(Pair.onePair((Object)yearNumber, (Object)periodNumber));
            }
        }
        if (ConfigServiceHelper.getBoolParam(this.context.getModelId(), "isUpgradeCS2IRpt")) {
            Set<String> orgNumNotLeaf = this.getNotLeafMemberNum(this.context.getModelId());
            for (String orgNum : orgNumNotLeaf) {
                for (Pair yearPeriod : yearPeriodAllPair) {
                    RunScriptBuilder run = new RunScriptBuilder(modelNumber);
                    run.addDimensionScope(PresetConstant.ENTITY_DIM, orgNum);
                    run.addDimensionScope(PresetConstant.FY_DIM, (String)yearPeriod.p1);
                    run.addDimensionScope(PresetConstant.PERIOD_DIM, (String)yearPeriod.p2);
                    run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PROCESS_DIM, (Object)"IRpt"));
                    run.appendEqualSign();
                    run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PROCESS_DIM, (Object)"CS"));
                    run.endRunExpress();
                    run.runScript();
                }
            }
        }
        if (ConfigServiceHelper.getBoolParam(this.context.getModelId(), "isUpgradeSRpt2SIRpt")) {
            for (Pair yearPeriod : yearPeriodAllPair) {
                RunScriptBuilder run = new RunScriptBuilder(modelNumber);
                run.addDimensionScope(PresetConstant.FY_DIM, (String)yearPeriod.p1);
                run.addDimensionScope(PresetConstant.PERIOD_DIM, (String)yearPeriod.p2);
                run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PROCESS_DIM, (Object)"SRPT"));
                run.appendEqualSign();
                run.appendV((PairList<String, String>)new PairList().addPair((Object)PresetConstant.PROCESS_DIM, (Object)"SIRPT"));
                run.endRunExpress();
                run.runScript();
            }
        }
    }

    private void saveExchangeRate() {
        QFilter qf = new QFilter("model", "=", (Object)this.context.getModelId());
        qf.and("isexchangerate", "=", (Object)true);
        qf.and("isleaf", "=", (Object)true);
        HashSet numbers = new HashSet();
        QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number", (QFilter[])qf.toArray()).forEach(org -> numbers.add(org.getString("number")));
        RunScriptBuilder run = new RunScriptBuilder(this.context.getCube());
        run.appendV((PairList<String, String>)new PairList().addPair((Object)"AuditTrail", (Object)"ATNone"));
        run.appendEqualSign();
        run.appendV((PairList<String, String>)new PairList().addPair((Object)"AuditTrail", (Object)"EntityInput"));
        run.endRunExpress();
        run.addDimensionScope(PresetConstant.ENTITY_DIM, numbers.toArray(new String[0]));
        run.runScript();
    }

    private Set<String> getNotLeafMemberNum(long modelId) {
        HashSet<Long> parentIds = new HashSet<Long>(16);
        HashSet<String> orgNumsNotLeafNumber = new HashSet<String>(16);
        QFBuilder orgQf = new QFBuilder();
        orgQf.add("model", "=", (Object)modelId);
        DynamicObjectCollection allMembers = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id,parent.id,number", (QFilter[])orgQf.toArray());
        for (DynamicObject member : allMembers) {
            parentIds.add(member.getLong("parent.id"));
        }
        for (DynamicObject member : allMembers) {
            if (!parentIds.contains(member.getLong("id"))) continue;
            orgNumsNotLeafNumber.add(member.getString("number"));
        }
        orgNumsNotLeafNumber.remove("RateEntity");
        orgNumsNotLeafNumber.remove("RatePreset");
        return orgNumsNotLeafNumber;
    }

    private void syncEntityParentSonFactors(String modelNum) {
        QFilter modelQf = new QFilter("model.number", "=", (Object)modelNum).and(new QFilter("status", "!=", (Object)"A"));
        DynamicObjectCollection memCollection = QueryServiceHelper.query((String)"bcm_entitymembertree", (String)"id, number, parent.id, aggoprt, isleaf, storagetype", (QFilter[])new QFilter[]{modelQf});
        DynamicComputingServiceHelper.repairModelByScope(modelNum, DimEntityNumEnum.ENTITY.getNumber(), true, memCollection);
    }

    private void updateProcessParentSonProperty(long modelId) {
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        DynamicObject[] allMembers = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,longnumber,parentchild", (QFilter[])new QFilter[]{modelQf});
        if (allMembers.length > 0) {
            for (DynamicObject dynamicObject : allMembers) {
                String longNumber = dynamicObject.getString("longnumber").toLowerCase(Locale.ENGLISH);
                String number = dynamicObject.getString("number").toLowerCase(Locale.ENGLISH);
                String[] longNumberArray = longNumber.split("!");
                if (longNumberArray.length < 1) {
                    return;
                }
                HashSet longNumberSet = new HashSet(16);
                Collections.addAll(longNumberSet, longNumberArray);
                if (longNumberSet.contains("cctotal") && !longNumberSet.contains("rpt") && !longNumberSet.contains("pc") && !longNumberSet.contains("erpt")) {
                    dynamicObject.set("parentchild", (Object)1);
                    continue;
                }
                if ("tarpt".equals(number) || "tadj".equals(number)) {
                    dynamicObject.set("parentchild", (Object)1);
                    continue;
                }
                dynamicObject.set("parentchild", (Object)0);
            }
        }
        SaveServiceHelper.save((DynamicObject[])allMembers);
    }

    @Override
    protected void readyUpgradeData() {
        if (this.isUpgraded(this.context.getModelId())) {
            return;
        }
        long modelId = this.context.getModelId();
        DynamicObject model = BusinessDataServiceHelper.loadSingle((Object)modelId, (String)"bcm_model", (String)"number");
        String modelCUBE = model.getString("number");
        LinkedHashMultimap<String, Map<String, String>> notSyncMembers = DimensionServiceHelper.getNotSyncDimensionMember(modelId);
        HashMap dimensionGroup = new HashMap(16);
        notSyncMembers.keySet().forEach(k -> {
            List record = notSyncMembers.get(k).stream().filter(x -> x.get("onum") == null).collect(Collectors.toList());
            if (!record.isEmpty()) {
                dimensionGroup.put(k, record);
            }
        });
        for (Map.Entry entry : dimensionGroup.entrySet()) {
            String dimensionNumber = (String)entry.getKey();
            List<String> dysMemberNumber = ((List)entry.getValue()).stream().filter(f -> f.get("num") != null).map(x -> (String)x.get("num")).collect(Collectors.toList());
            if (dysMemberNumber.size() <= 0) continue;
            OlapServiceHelper.batchCreateDimensionMembers(modelCUBE, dimensionNumber, dysMemberNumber.toArray(new String[dysMemberNumber.size()]));
        }
        QFBuilder qfBuilder = new QFBuilder("model.id", "=", (Object)modelId);
        qfBuilder.add("number", "=", (Object)ConfigEnum.CM006.getNumber());
        DynamicObject dy = BusinessDataServiceHelper.loadSingle((String)"bcm_configsetting", (String)"config,model,number", (QFilter[])qfBuilder.toArray());
        if (dy != null && "1".equals(dy.getString("config"))) {
            DynamicOlapHelper.setDynamicModel(this.context.getModelId(), null, false);
        }
        this.upgrade(Lists.newArrayList((Object[])new Pair[]{new Pair((Object)this.context.getModelId(), (Object)this.context.getCube())}));
    }

    private void synchronizeDimensionMember(long modelId, String modelCubeNumber, String DimensionNumber, String DimensionEntity) {
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        DynamicObject[] dys = BusinessDataServiceHelper.load((String)DimensionEntity, (String)"id,number", (QFilter[])modelQf.toArray());
        String[] dysNumber = new String[dys.length];
        for (int i = 0; i < dys.length; ++i) {
            dysNumber[i] = dys[i].getString("number");
        }
        OlapServiceHelper.batchCreateDimensionMembers(modelCubeNumber, DimensionNumber, dysNumber);
    }

    private void backupBeforeMember(DynamicObject[] load, UpgradeContext context) {
        for (DynamicObject dynamicObject : load) {
            if ("PC".equalsIgnoreCase(dynamicObject.getString("number"))) {
                context.getDel_bps().put("PC", dynamicObject.getLong("id"));
            }
            if (!"SIRpt".equalsIgnoreCase(dynamicObject.getString("number"))) continue;
            context.getDel_bps().put("SIRpt", dynamicObject.getLong("id"));
        }
    }

    private void updateProcessARpt2ARPT(long modelId) {
        QFilter modelQf = new QFilter("model.id", "=", (Object)modelId);
        QFilter longNumberQf = new QFilter("longnumber", "like", (Object)"%ARpt%");
        DynamicObject[] needModifyMembers = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,longnumber", (QFilter[])new QFilter[]{modelQf, longNumberQf});
        if (needModifyMembers.length > 0) {
            for (DynamicObject dynamicObject : needModifyMembers) {
                String longNumber = dynamicObject.getString("longnumber");
                if (!StringUtils.isNotEmpty((String)longNumber)) continue;
                String newLongNumber = longNumber.replace("ARpt", "ARPT");
                dynamicObject.set("longnumber", (Object)newLongNumber);
            }
        }
        SaveServiceHelper.save((DynamicObject[])needModifyMembers);
    }

    private boolean isUpgraded(long modelId) {
        QFilter modelFilter = new QFilter("model", "=", (Object)modelId);
        QFilter rptFilter = new QFilter("number", "=", (Object)"Rpt");
        DynamicObjectCollection rptSize = QueryServiceHelper.query((String)"bcm_processmembertree", (String)"number, storagetype", (QFilter[])new QFilter[]{modelFilter, rptFilter});
        return rptSize.size() > 1;
    }
}

