/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.fi.bcm.business.dimension.predimensionhelper.PreDimensionUtil;
import kd.fi.bcm.business.upgrade.DimMemberEntity;
import org.dom4j.Attribute;
import org.dom4j.Element;

public class DimensionXmlReader {
    private static Map<String, Map<String, String>> map;
    private IDataEntityType dt;

    public DimensionXmlReader(IDataEntityType dt) {
        this.dt = dt;
    }

    public Object readObject(Element root, Object entity) {
        if (entity == null) {
            entity = this.dt.createInstance();
        }
        List attributes = root.attributes();
        DataEntityPropertyCollection properties = this.dt.getProperties();
        for (Object attribute : attributes) {
            Attribute attr = (Attribute)attribute;
            String name = attr.getName();
            IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)name);
            if (prop == null) continue;
            Map<String, String> strMap = map.get(name);
            String value = attr.getValue();
            if (strMap != null) {
                value = strMap.get(value);
            }
            prop.setValue(entity, DimMemberEntity.convertValue(prop.getPropertyType(), value));
        }
        List elements = root.elements();
        for (Object element : elements) {
            IDataEntityProperty parentProp;
            Element ele = (Element)element;
            Object child = this.readObject(ele, null);
            IDataEntityProperty childrenProp = (IDataEntityProperty)properties.get((Object)"children");
            if (childrenProp != null) {
                List<Object> list = this.getList(childrenProp, entity);
                list.add(child);
            }
            if ((parentProp = (IDataEntityProperty)properties.get((Object)"parent")) == null) continue;
            parentProp.setValue(child, entity);
        }
        return entity;
    }

    private List<Object> getList(IDataEntityProperty property, Object entity) {
        ArrayList temp = property.getValue(entity);
        if (temp == null) {
            temp = new ArrayList(10);
            property.setValue(entity, temp);
        }
        return temp;
    }

    static {
        try {
            map = PreDimensionUtil.resolveMapping();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

