/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.ApplicationTypeEnum;
import kd.fi.bcm.common.enums.DispatchTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class DispatchDataExtractUpgradeService
extends BcmUpgradeService {
    private static final Log logger = LogFactory.getLog(DispatchDataExtractUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        DataSet modelSet = DB.queryDataSet((String)"DataExtract_bcm_model", (DBRoute)BCMConstant.DBROUTE, (String)"select fid, freporttype from t_bcm_model where fid != 0");
        HashMap<Long, String> id2type = new HashMap<Long, String>(16);
        for (Row row : modelSet) {
            id2type.put(row.getLong("fid"), row.getString("freporttype"));
        }
        if (id2type.size() == 0) {
            return this.success();
        }
        DataSet intelSchedules = DB.queryDataSet((String)"bcm_model_BCM_IntelSchedule", (DBRoute)BCMConstant.DBROUTE, (String)"select fid, fmodelid from T_BCM_IntelSchedule");
        HashMap<Long, String> scheId2type = new HashMap<Long, String>(16);
        for (Row intelSchedule : intelSchedules) {
            Long id = intelSchedule.getLong("fid");
            Long modelId = intelSchedule.getLong("fmodelid");
            String reportType = (String)id2type.get(modelId);
            if (reportType == null) continue;
            scheId2type.put(id, reportType);
        }
        if (scheId2type.size() == 0) {
            return this.success();
        }
        id2type.clear();
        Set scheIds = scheId2type.keySet();
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(16);
        String insertSql = "insert into t_bcm_dspparamentity_s (fsubpageconfig, fid) values (?,?)";
        String upSql = "update t_bcm_dspparamentity_s set fsubpageconfig = ? where fid = ?";
        DataSet intelScheduleEntrys = DB.queryDataSet((String)"DispatchDataExtract_BCM_IntelScheduleEntry_select", (DBRoute)BCMConstant.DBROUTE, (String)"select fid, fexecparamid, fexecoperation from T_BCM_IntelScheduleEntry");
        try (TXHandle tx = TX.required();){
            try {
                for (Row scheduleEntry : intelScheduleEntrys) {
                    String modelReportType;
                    Long id = scheduleEntry.getLong("fid");
                    if (!scheIds.contains(id) || !StringUtils.isNotEmpty((CharSequence)(modelReportType = (String)scheId2type.get(id))) || !"1".equals(modelReportType) && !"2".equals(modelReportType)) continue;
                    modelReportType = "1".equals(modelReportType) ? ApplicationTypeEnum.CM.getAppnum() : ApplicationTypeEnum.RPT.getAppnum();
                    String operation = scheduleEntry.getString("fexecoperation");
                    if (!DispatchTypeEnum.DATA_EXTRACTION.getValue().equals(operation)) continue;
                    Long paramId = scheduleEntry.getLong("fexecparamid");
                    DataSet dspparamentity_s = DB.queryDataSet((String)"DispatchDataExtract_bcm_dspparamentity_s_select", (DBRoute)BCMConstant.DBROUTE, (String)"select fid, fsubpageconfig from t_bcm_dspparamentity_s where fid = ?", (Object[])new Object[]{paramId});
                    if (dspparamentity_s.hasNext()) {
                        Row entry_s = dspparamentity_s.next();
                        if (entry_s.getString("fsubpageconfig") != null && !"".equals(entry_s.getString("fsubpageconfig").trim())) continue;
                        Object[] params = this.getParams(paramId, modelReportType);
                        if (params != null) {
                            updateList.add(params);
                        }
                        if (updateList.size() != 2000) continue;
                        DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, updateList);
                        updateList.clear();
                        continue;
                    }
                    Object[] params = this.getParams(paramId, modelReportType);
                    if (params != null) {
                        insertList.add(params);
                    }
                    if (insertList.size() != 2000) continue;
                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertSql, insertList);
                    insertList.clear();
                }
                if (updateList.size() > 0) {
                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, updateList);
                }
                if (insertList.size() > 0) {
                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertSql, insertList);
                }
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return this.success();
    }

    private Object[] getParams(Long paramId, String modelReportType) {
        DataSet paramEntity = DB.queryDataSet((String)"DispatchDataExtractUpgradeService_bcm_dspparamentity", (DBRoute)BCMConstant.DBROUTE, (String)"select fid, fdatapushschemeid from t_bcm_dspparamentity where fid = ?", (Object[])new Object[]{paramId});
        if (paramEntity.hasNext()) {
            Row param = paramEntity.next();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("datapushscheme", param.getString("fdatapushschemeid"));
            data.put("iscover", "false");
            data.put("appid", modelReportType);
            String jsonData = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{jsonData, paramId};
            return params;
        }
        return null;
    }
}

