/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.DispatchTypeEnum;

public class DispatchDecouplingIntegrationUpgradeService
extends BcmUpgradeService {
    private static final Log logger = LogFactory.getLog(DispatchDecouplingIntegrationUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        DataSet modelSet = DB.queryDataSet((String)"t_bcm_modelUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid from t_bcm_model ");
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        ArrayList<Object[]> insertList = new ArrayList<Object[]>(16);
        String insertSql = "insert into t_bcm_dspparamentity_s (fsubpageconfig,fid) values (?,?)";
        String upSql = "update t_bcm_dspparamentity_s set fsubpageconfig = ? where fid = ?";
        for (Row row : modelSet) {
            Long modelId = row.getLong("fid");
            if (modelId == null || modelId == 0L) {
                logger.error("model is not exist, skip");
                continue;
            }
            DataSet intelSchedules = DB.queryDataSet((String)"T_BCM_IntelScheduleUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid,fname from T_BCM_IntelSchedule where fmodelid = ?", (Object[])new Object[]{modelId});
            for (Row intelSchedule : intelSchedules) {
                Long id = intelSchedule.getLong("fid");
                DataSet intelScheduleEntry = DB.queryDataSet((String)"T_BCM_IntelScheduleEntryUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid,fexecparamid,fexecoperation from T_BCM_IntelScheduleEntry where fid = ?", (Object[])new Object[]{id});
                for (Row scheduleEntry : intelScheduleEntry) {
                    String operation = scheduleEntry.getString("fexecoperation");
                    if (!DispatchTypeEnum.INTEGRATION.getValue().equals(operation)) continue;
                    Long paramId = scheduleEntry.getLong("fexecparamid");
                    DataSet intelScheduleEntry_s = DB.queryDataSet((String)"t_bcm_dspparamentity_sUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid,fsubpageconfig from t_bcm_dspparamentity_s where fid= ?", (Object[])new Object[]{paramId});
                    if (intelScheduleEntry_s.hasNext()) {
                        Row entry_s = intelScheduleEntry_s.next();
                        if (entry_s.getString("fsubpageconfig") != null && !"".equals(entry_s.getString("fsubpageconfig").trim())) continue;
                        Object[] params = this.getParams(paramId);
                        if (params != null) {
                            updateList.add(params);
                        }
                        if (updateList.size() != 1000) continue;
                        DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, updateList);
                        updateList.clear();
                        continue;
                    }
                    Object[] params = this.getParams(paramId);
                    if (params != null) {
                        insertList.add(params);
                    }
                    if (insertList.size() != 1000) continue;
                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertSql, insertList);
                    insertList.clear();
                }
            }
        }
        if (updateList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, updateList);
            updateList.clear();
        }
        if (insertList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertSql, insertList);
            insertList.clear();
        }
        return this.success();
    }

    private Object[] getParams(Long paramId) {
        DataSet paramEntity = DB.queryDataSet((String)"DispatchDecouplingIntegrationUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid,fperiodid,fyearid,fcollectstatus,fmulentity,fscenarioid from t_bcm_dspparamentity where fid = ?", (Object[])new Object[]{paramId});
        DataSet schemeEntity = DB.queryDataSet((String)"DispatchDecouplingIntegrationUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fbasedataid from t_bcm_dspisscheme where fid = ?", (Object[])new Object[]{paramId});
        ArrayList<String> schemes = new ArrayList<String>(8);
        for (Row scheme : schemeEntity) {
            schemes.add(scheme.getString("fbasedataid"));
        }
        String schemeStr = String.join((CharSequence)",", schemes);
        if (paramEntity.hasNext()) {
            Row param = paramEntity.next();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            data.put("collectstatus", param.getString("fcollectstatus"));
            data.put("isscheme", schemeStr);
            data.put("entity", param.getString("fmulentity"));
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, paramId};
            return params;
        }
        return null;
    }
}

