/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.DispatchTypeEnum;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import org.apache.commons.collections.CollectionUtils;

public class DispatchParamUpgradeService
extends BcmUpgradeService {
    private static final WatchLogger log = BcmLogFactory.getWatchLogInstance(DispatchParamUpgradeService.class);
    private static final Map<String, String> SELECT_FIELDS_MAP = new HashMap<String, String>(16);

    @Override
    public Map<String, Object> upgrade() {
        Set modelSet = this.getCmAndRptModel().stream().map(model -> (Long)model.p1).collect(Collectors.toSet());
        for (Long modelId : modelSet) {
            this.doUpdate(modelId);
        }
        return this.success();
    }

    public void doUpdate(Long modelId) {
        HashMultimap operationMap = HashMultimap.create();
        try (DataSet intelScheduleEntrys = DB.queryDataSet((String)"dispatchParamUpgradeService.intelScheduleEntry", (DBRoute)BCMConstant.DBROUTE, (String)"select fid,fexecparamid,fexecoperation from T_BCM_IntelScheduleEntry where fid in ( select fid from T_BCM_IntelSchedule where fmodelid = ? ) ", (Object[])new Object[]{modelId});){
            intelScheduleEntrys.forEach(arg_0 -> DispatchParamUpgradeService.lambda$doUpdate$1((Multimap)operationMap, arg_0));
        }
        if (operationMap.isEmpty()) {
            return;
        }
        HashMap exitsSubConfigMap = new HashMap(16);
        String querySubConfig = "select fid,fsubpageconfig from t_bcm_dspparamentity_s where fid in (%s)";
        try (DataSet configs = DB.queryDataSet((String)"dispatchParamUpgradeService.dspparamentity_s", (DBRoute)BCMConstant.DBROUTE, (String)String.format(querySubConfig, String.join((CharSequence)",", (CharSequence[])operationMap.values().stream().map(Object::toString).toArray(String[]::new))));){
            configs.forEach(r -> exitsSubConfigMap.put(r.getLong("fid"), r.getString("fsubpageconfig")));
        }
        ArrayList updateList = new ArrayList(16);
        ArrayList insertList = new ArrayList(16);
        String insertSql = "insert into t_bcm_dspparamentity_s (fsubpageconfig,fid) values (?,?)";
        String upSql = "update t_bcm_dspparamentity_s set fsubpageconfig = ? where fid = ?";
        Map<String, Map<Long, Collection<Long>>> entryMap = this.queryMultiData(new ArrayList<Long>(operationMap.values()));
        operationMap.asMap().forEach((operation, paramIds) -> {
            String fields = SELECT_FIELDS_MAP.get(operation);
            if (fields != null) {
                try (DataSet paramEntities = DB.queryDataSet((String)"dispatchParamUpgradeService.dspparamentity", (DBRoute)BCMConstant.DBROUTE, (String)String.format("select %s from t_bcm_dspparamentity where fid in (%s) ", fields, String.join((CharSequence)",", (CharSequence[])paramIds.stream().map(Object::toString).toArray(String[]::new))));){
                    paramEntities.forEach(row -> {
                        Long paramId = row.getLong("fid");
                        if (exitsSubConfigMap.containsKey(paramId)) {
                            if (exitsSubConfigMap.get(paramId) == null || ((String)exitsSubConfigMap.get(paramId)).trim().isEmpty()) {
                                Object[] params = this.getParams((Row)row, (String)operation, entryMap);
                                if (params != null) {
                                    updateList.add(params);
                                }
                                if (updateList.size() == 1000) {
                                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, (List)updateList);
                                    updateList.clear();
                                }
                            }
                        } else {
                            Object[] params = this.getParams((Row)row, (String)operation, entryMap);
                            if (params != null) {
                                insertList.add(params);
                            }
                            if (insertList.size() == 1000) {
                                DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertSql, (List)insertList);
                                insertList.clear();
                            }
                        }
                    });
                }
            }
        });
        if (!updateList.isEmpty()) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, updateList);
            updateList.clear();
        }
        if (!insertList.isEmpty()) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertSql, insertList);
            insertList.clear();
        }
    }

    private Map<String, Map<Long, Collection<Long>>> queryMultiData(List<Long> dspParamIds) {
        Serializable templateMap;
        HashMap<String, Map<Long, Collection<Long>>> map = new HashMap<String, Map<Long, Collection<Long>>>(16);
        CharSequence[] suIds = (String[])dspParamIds.stream().map(Object::toString).distinct().toArray(String[]::new);
        String sql = String.format("select fid,fbasedataid from t_bcm_dspparamentry where fid in (%s)", String.join((CharSequence)",", suIds));
        try (DataSet templateEntry = DB.queryDataSet((String)"dispatchParamUpgradeService.template", (DBRoute)BCMConstant.DBROUTE, (String)sql);){
            templateMap = new HashMap<Long, Collection>(16);
            for (Row row : templateEntry) {
                templateMap.computeIfAbsent(row.getLong("fid"), k -> new ArrayList()).add(row.getLong("fbasedataid"));
            }
            map.put(DispatchTypeEnum.FOMULAR.getValue(), (Map<Long, Collection<Long>>)((Object)templateMap));
        }
        String commonPaperSql = String.format("select fid,fbasedataid from t_bcm_dsppapertemplate where fid in (%s) ", String.join((CharSequence)",", suIds));
        DataSet commonPapers = DB.queryDataSet((String)"t_bcm_dsppapertemplate", (DBRoute)BCMConstant.DBROUTE, (String)commonPaperSql);
        templateMap = null;
        try {
            HashMultimap pertemplateMap = HashMultimap.create();
            commonPapers.forEachRemaining(arg_0 -> DispatchParamUpgradeService.lambda$queryMultiData$9((Multimap)pertemplateMap, arg_0));
            map.put(DispatchTypeEnum.CREATE_AUTO_ADJUST.getValue() + "_commonPapers", pertemplateMap.asMap());
        }
        catch (Throwable throwable) {
            templateMap = throwable;
            throw throwable;
        }
        finally {
            if (commonPapers != null) {
                if (templateMap != null) {
                    try {
                        commonPapers.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)templateMap).addSuppressed(throwable);
                    }
                } else {
                    commonPapers.close();
                }
            }
        }
        String investPaperSql = String.format("select fid,fbasedataid from t_bcm_dspinvelimtemplate where fid in (%s) ", String.join((CharSequence)",", suIds));
        DataSet investPapers = DB.queryDataSet((String)"t_bcm_dspinvelimtemplate", (DBRoute)BCMConstant.DBROUTE, (String)investPaperSql);
        Object object = null;
        try {
            HashMultimap invpertemplateMap = HashMultimap.create();
            investPapers.forEachRemaining(arg_0 -> DispatchParamUpgradeService.lambda$queryMultiData$10((Multimap)invpertemplateMap, arg_0));
            map.put(DispatchTypeEnum.CREATE_AUTO_ADJUST.getValue() + "_investPapers", invpertemplateMap.asMap());
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (investPapers != null) {
                if (object != null) {
                    try {
                        investPapers.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    investPapers.close();
                }
            }
        }
        return map;
    }

    private Object[] getParams(Row param, String operation, Map<String, Map<Long, Collection<Long>>> entryMap) {
        if (DispatchTypeEnum.SHAREHOLDINGCALC.getValue().equals(operation)) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            data.put("mergeentity", param.getString("fmergeentity"));
            data.put("staticstock", "1".equals(param.getString("fstaticstockable")) ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            data.put("dynamicstock", "1".equals(param.getString("fdynamicstockable")) ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            data.put("caltype", param.getString("fcaltype"));
            data.put("calrange", param.getString("fcalrange"));
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.CREATE_AUTO_ADJUST.getValue().equals(operation)) {
            Collection<Long> curTemplates;
            Map<Long, Collection<Long>> _investPapers;
            Collection<Long> curTemplates2;
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            data.put("entity", param.getString("fmergeentity"));
            data.put("effectiverange", param.getString("feffectiverange"));
            data.put("mergeset", param.getString("fmergeset"));
            Map<Long, Collection<Long>> _commonPapers = entryMap.get(DispatchTypeEnum.CREATE_AUTO_ADJUST.getValue() + "_commonPapers");
            if (_commonPapers != null && !_commonPapers.isEmpty() && CollectionUtils.isNotEmpty(curTemplates2 = _commonPapers.get(param.getLong("fid")))) {
                data.put("commonpapers", SerializationUtils.serializeToBase64(new HashSet<Long>(curTemplates2)));
            }
            if ((_investPapers = entryMap.get(DispatchTypeEnum.CREATE_AUTO_ADJUST.getValue() + "_investPapers")) != null && !_investPapers.isEmpty() && CollectionUtils.isNotEmpty(curTemplates = _investPapers.get(param.getLong("fid")))) {
                data.put("investedtemplates", SerializationUtils.serializeToBase64(new HashSet<Long>(curTemplates)));
            }
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.COPYINVEST.getValue().equals(operation)) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            data.put("mergeentity", param.getString("fmergeentity"));
            data.put("srcscenario", param.getString("fsrcscenarioid"));
            data.put("yearoffset", param.getString("fyearoffset"));
            data.put("periodoffset", param.getString("fperiodoffset"));
            data.put("effectiverange", param.getString("feffectiverange"));
            data.put("mergeset", param.getString("fmergeset"));
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.MERGE.getValue().equals(operation)) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            data.put("mergeentity", param.getString("fmergeentity"));
            data.put("mergeradiogroup", param.getString("fmergeradiogroup"));
            data.put("ecradiogroup", param.getString("fecradiogroup"));
            data.put("pcradiogroup", param.getString("fpcradiogroup"));
            data.put("chkradiogroup", param.getString("fchkradiogroup"));
            data.put("rightoffsetgroup", param.getString("frightoffsetgroup"));
            data.put("commonpapergroup", "1");
            data.put("intrgroup", "1");
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.PERIODMANAGE.getValue().equals(operation)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            List mulentity = new ArrayList(1);
            try {
                mulentity = (List)SerializationUtils.fromJsonString((String)param.getString("fmulentity"), List.class);
            }
            catch (Exception e) {
                log.error("\u667a\u80fd\u8c03\u5ea6\u66f4\u65b0\u671f\u95f4\u7ba1\u7406\u65e7\u53c2\u6570\uff0c\u591a\u9009\u7ec4\u7ec7\u6570\u636e\u6709\u95ee\u9898\uff0c\u8be5\u6761\u6570\u636e\u7684\u7ec4\u7ec7\u66f4\u65b0\u4e3a\u7a7a\uff0cfid=" + param.getLong("fid") + ", mulentity=" + param.getString("fmulentity"), (Throwable)e);
            }
            data.put("entity", mulentity);
            data.put("optype", param.getString("foptype"));
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.CONTINUE_ENTRY.getValue().equals(operation)) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            data.put("entity", param.getString("fmulentity"));
            String s = SerializationUtils.serializeToBase64(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.CALCULATE.getValue().equals(operation)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            List mulEntity = new ArrayList(1);
            try {
                mulEntity = (List)SerializationUtils.fromJsonString((String)param.getString("fmulentity"), List.class);
            }
            catch (Exception e) {
                log.error(DispatchTypeEnum.CALCULATE.getName() + " : fid=" + param.getLong("fid") + ", mulentity=" + param.getString("fmulentity"), (Throwable)e);
            }
            data.put("entity", mulEntity);
            List mulProcess = new ArrayList(1);
            try {
                mulProcess = (List)SerializationUtils.fromJsonString((String)param.getString("fmulprocess"), List.class);
            }
            catch (Exception e) {
                log.error(DispatchTypeEnum.CALCULATE.getName() + " : fid=" + param.getLong("fid") + ", mulprocess=" + param.getString("fmulprocess"), (Throwable)e);
            }
            data.put("process", mulProcess);
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.MERGEFLOW.getValue().equals(operation)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            List mulentity = new ArrayList(1);
            try {
                mulentity = (List)SerializationUtils.fromJsonString((String)param.getString("fmulentity"), List.class);
            }
            catch (Exception e) {
                log.error(DispatchTypeEnum.MERGEFLOW.getName() + ": fid=" + param.getLong("fid") + ", mulentity=" + param.getString("fmulentity"), (Throwable)e);
            }
            data.put("entity", mulentity);
            data.put("mergeflowstatus", param.getString("fmergeflowstatus"));
            data.put("comfortablecurrency", param.getString("fcomfortablecurrency"));
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.MERGETASK.getValue().equals(operation)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            List mulEntity = new ArrayList(1);
            try {
                mulEntity = (List)SerializationUtils.fromJsonString((String)param.getString("fmulentity"), List.class);
            }
            catch (Exception e) {
                log.error(DispatchTypeEnum.MERGETASK.getName() + " : fid=" + param.getLong("fid") + ", mulentity=" + param.getString("fmulentity"), (Throwable)e);
            }
            data.put("entity", mulEntity);
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.FOMULAR.getValue().equals(operation)) {
            Collection<Long> curTemplates;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            List mulEntity = new ArrayList(1);
            try {
                mulEntity = (List)SerializationUtils.fromJsonString((String)param.getString("fmulentity"), List.class);
            }
            catch (Exception e) {
                log.error(DispatchTypeEnum.CALCULATE.getName() + " : fid=" + param.getLong("fid") + ", mulentity=" + param.getString("fmulentity"), (Throwable)e);
            }
            data.put("entity", mulEntity);
            Map<Long, Collection<Long>> templates = entryMap.get(DispatchTypeEnum.FOMULAR.getValue());
            if (templates != null && !templates.isEmpty() && CollectionUtils.isNotEmpty(curTemplates = templates.get(param.getLong("fid")))) {
                data.put("template", String.join((CharSequence)",", (CharSequence[])curTemplates.stream().map(Object::toString).toArray(String[]::new)));
            }
            data.put("executeorder", "1".equals(param.getString("fisexecuteorder")) ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            data.put("reexecute", "1".equals(param.getString("fisreexecute")) ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        if (DispatchTypeEnum.BEGIN_YEAR_CARRY.getValue().equals(operation)) {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("year", param.getString("fyearid"));
            data.put("period", param.getString("fperiodid"));
            data.put("scenario", param.getString("fscenarioid"));
            List mulEntity = new ArrayList(1);
            try {
                mulEntity = (List)SerializationUtils.fromJsonString((String)param.getString("fmulentity"), List.class);
            }
            catch (Exception e) {
                log.error(DispatchTypeEnum.CALCULATE.getName() + " : fid=" + param.getLong("fid") + ", mulentity=" + param.getString("fmulentity"), (Throwable)e);
            }
            data.put("entity", mulEntity);
            String s = SerializationUtils.toJsonString(data);
            Object[] params = new Object[]{s, param.getLong("fid")};
            return params;
        }
        return null;
    }

    private static /* synthetic */ void lambda$queryMultiData$10(Multimap invpertemplateMap, Row investPaper) {
        invpertemplateMap.put((Object)investPaper.getLong("fid"), (Object)investPaper.getLong("fbasedataid"));
    }

    private static /* synthetic */ void lambda$queryMultiData$9(Multimap pertemplateMap, Row commonPaper) {
        pertemplateMap.put((Object)commonPaper.getLong("fid"), (Object)commonPaper.getLong("fbasedataid"));
    }

    private static /* synthetic */ void lambda$doUpdate$1(Multimap operationMap, Row row) {
        operationMap.put((Object)row.getString("fexecoperation"), (Object)row.getLong("fexecparamid"));
    }

    static {
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.SHAREHOLDINGCALC.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmergeentity,fcaltype,fcalrange,fstaticstockable,fdynamicstockable ");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.COPYINVEST.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmergeentity,fsrcscenarioid,fyearoffset,fperiodoffset,feffectiverange,fmergeset ");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.MERGE.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmergeentity,fmergeradiogroup,fecradiogroup,fpcradiogroup,fchkradiogroup,frightoffsetgroup ");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.PERIODMANAGE.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmulentity,foptype ");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.CONTINUE_ENTRY.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmulentity");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.CALCULATE.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmulentity,fmulprocess");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.MERGEFLOW.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmulentity,fmergeflowstatus,fcomfortablecurrency");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.MERGETASK.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmulentity");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.FOMULAR.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmulentity,fisexecuteorder,fisreexecute");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.CREATE_AUTO_ADJUST.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmergeentity,feffectiverange,fmergeset");
        SELECT_FIELDS_MAP.put(DispatchTypeEnum.BEGIN_YEAR_CARRY.getValue(), " fid,fperiodid,fyearid,fscenarioid,fmulentity");
    }
}

