/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.security.SecureRandom;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.util.GlobalIdUtil;
import org.apache.commons.lang3.StringUtils;

public class DocumentAttachedUpgradeService
extends BcmUpgradeService {
    private static final Log logger = LogFactory.getLog(DocumentAttachedUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        DataSet modelSet = DB.queryDataSet((String)"DocumentAttachedUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid from t_bcm_model");
        for (Row row : modelSet) {
            Long modelId = row.getLong("fid");
            if (modelId == null || modelId == 0L) {
                logger.error("model is not exist, skip");
                continue;
            }
            DataSet docs = DB.queryDataSet((String)"DocumentAttachedUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid,furl,fname,fcreatorid,fcreatetime from t_bcm_docmodel where fmodelid = ? and ftype = '0'", (Object[])new Object[]{modelId});
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_bas_attachment");
            insertSql.append(" (fid, fnumber,fbilltype,finterid,fcreatetime,fcreatemen,fmodifytime,fmodifymen,ffileid,fattachmentname,fextname,fattachmentsize,fattachmentpanel,faliasfilename)");
            insertSql.append(" VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?);");
            ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(16);
            for (Row doc : docs) {
                int lastIndexOf;
                Object[] insertParams = new Object[14];
                insertParams[0] = GlobalIdUtil.genGlobalLongId();
                insertParams[1] = this.generateUid();
                insertParams[2] = "bcm_document";
                insertParams[3] = doc.getLong("fid");
                Date fcreatetime = doc.getDate("fcreatetime");
                if (fcreatetime == null) {
                    fcreatetime = new Timestamp(System.currentTimeMillis());
                }
                insertParams[4] = fcreatetime;
                insertParams[5] = doc.getLong("fcreatorid");
                insertParams[6] = fcreatetime;
                insertParams[7] = doc.getLong("fcreatorid");
                insertParams[8] = doc.getString("furl");
                String name = doc.getString("fname");
                insertParams[9] = name;
                String extname = "";
                if (StringUtils.isNotEmpty((CharSequence)name) && (lastIndexOf = name.lastIndexOf(".")) != -1) {
                    extname = name.substring(lastIndexOf + 1, name.length());
                }
                insertParams[10] = extname;
                insertParams[11] = "20001";
                insertParams[12] = "attchment";
                insertParams[13] = name;
                insertParamsList.add(insertParams);
            }
            if (insertParamsList.isEmpty()) continue;
            TXHandle tx = TX.required((String)"DocumentAttachedUpgradeService");
            Throwable throwable = null;
            try {
                try {
                    DB.executeBatch((DBRoute)new DBRoute("basedata"), (String)insertSql.toString(), insertParamsList);
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.log.error("DocumentAttachedUpgradeService error", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
        return this.success();
    }

    public String generateUid() {
        return "rc-upload-" + System.currentTimeMillis() + "-" + new SecureRandom().nextInt(100);
    }
}

