/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.db.SQLBuilder4RDB;

public class DocumentUpgradeService
extends BcmUpgradeService {
    private static final Log logger = LogFactory.getLog(DocumentUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        DataSet modelSet = DB.queryDataSet((String)"DocumentUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid from t_bcm_model");
        for (Row row : modelSet) {
            Long modelId = row.getLong("fid");
            if (modelId == null || modelId == 0L) {
                logger.error("model is not exist, skip");
                continue;
            }
            DataSet docs = DB.queryDataSet((String)"DocumentUpgradeService", (DBRoute)BCMConstant.DBROUTE, (String)"select fid,fname from t_bcm_docmodel where fmodelid = ?", (Object[])new Object[]{modelId});
            String reportName = ResManager.loadKDString((String)"\u62a5\u8868\u7f16\u5236", (String)"DocumentManagePlugin_1", (String)"fi-bcm-formplugin", (Object[])new Object[0]);
            SQLBuilder4RDB updateSql = new SQLBuilder4RDB();
            updateSql.append("update t_bcm_docmodel set fnumber = ? where fid = ?");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
            for (Row doc : docs) {
                String name = doc.getString("fname");
                long id = doc.getLong("fid");
                if (reportName.equals(name)) {
                    paramList.add(new Object[]{"doc_report", id});
                    continue;
                }
                paramList.add(new Object[]{"doc" + id, id});
            }
            if (paramList.isEmpty()) continue;
            TXHandle tx = TX.required((String)"DocumentUpgradeService");
            Throwable throwable = null;
            try {
                try {
                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql.toString(), paramList);
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.log.error("DocumentUpgradeService error", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tx == null) continue;
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tx.close();
            }
        }
        return this.success();
    }
}

