/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;

public class EnumItemSeqUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        String sql = "select fid, fmodelid,fdimensionid from t_bcm_enumitem order by fmodelid,fdimensionid,fid";
        DataSet rows = DB.queryDataSet((String)"select_all_enum_item", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        HashMap<Long, LinkedList> modelMaps = new HashMap<Long, LinkedList>(16);
        while (rows.hasNext()) {
            Row rowData = rows.next();
            LinkedList ids = modelMaps.computeIfAbsent(rowData.getLong("fmodelid"), k -> new LinkedList());
            ids.add(rowData.getLong("fid"));
        }
        if (modelMaps.isEmpty()) {
            return this.success();
        }
        ArrayList paramsList = new ArrayList(16);
        String upSql = "update t_bcm_enumitem set fseq = ? where fid = ?";
        modelMaps.forEach((k, v) -> {
            AtomicInteger seq = new AtomicInteger(1);
            v.forEach(id -> {
                Object[] param = new Object[]{seq.getAndIncrement(), id};
                paramsList.add(param);
                if (paramsList.size() == 1000) {
                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, (List)paramsList);
                    paramsList.clear();
                }
            });
        });
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, paramsList);
            paramsList.clear();
        }
        return this.success();
    }
}

