/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;

public class EnumValueDseqUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        String sql = "select fid, fenumitemid, fseq from t_bcm_enumvalue where fseq is null or fseq = 0 order by fid";
        DataSet rows = DB.queryDataSet((String)"select_all_enum_value", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        HashMap<Long, Map> eiId2evId2Seq = new HashMap<Long, Map>(16);
        HashMap eiId2evIds = new HashMap(16);
        while (rows.hasNext()) {
            Row rowData = rows.next();
            Map evId2Seq = eiId2evId2Seq.computeIfAbsent(rowData.getLong("fenumitemid"), k -> new HashMap(16));
            List evIds = eiId2evIds.computeIfAbsent(rowData.getLong("fenumitemid"), k -> new ArrayList(16));
            evId2Seq.put(rowData.getLong("fid"), rowData.getInteger("fseq"));
            evIds.add(rowData.getLong("fid"));
        }
        if (eiId2evId2Seq.size() == 0 || eiId2evIds.size() == 0) {
            return this.success();
        }
        for (Map.Entry next : eiId2evIds.entrySet()) {
            Long key = (Long)next.getKey();
            List value = (List)next.getValue();
            List sortedEvs = value.stream().sorted().collect(Collectors.toList());
            eiId2evIds.put(key, sortedEvs);
        }
        for (Map.Entry next : eiId2evIds.entrySet()) {
            List evIds = (List)next.getValue();
            Map evIds2Seq = (Map)eiId2evId2Seq.get(next.getKey());
            if (evIds2Seq == null || evIds2Seq.size() == 0) continue;
            int seq = 1;
            for (Long evId : evIds) {
                evIds2Seq.put(evId, seq);
                ++seq;
            }
        }
        String upSql = "update t_bcm_enumvalue set fseq = ? where fid = ?";
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        for (Map evId2Seq : eiId2evId2Seq.values()) {
            for (Map.Entry next : evId2Seq.entrySet()) {
                Object[] param = new Object[]{next.getValue(), next.getKey()};
                paramsList.add(param);
                if (paramsList.size() != 1000) continue;
                DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, paramsList);
                paramsList.clear();
            }
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)upSql, paramsList);
            paramsList.clear();
        }
        return this.success();
    }
}

