/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class ExchangeRateFieldSettingUpgradeService
extends BcmUpgradeService {
    private static final Log logger = LogFactory.getLog(ExchangeRateFieldSettingUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        Object member2;
        List<Pair<Long, String>> allModels = this.getCmAndRptModel();
        if (allModels.isEmpty()) {
            return this.success();
        }
        Set modelIds = allModels.stream().map(s -> (Long)s.p1).collect(Collectors.toSet());
        String queryClosingRateSql = "select fid,fmodelid,fnumber from t_bcm_structofaccount where fnumber = 'ClosingRate' and fmodelid in ( " + Joiner.on((String)",").join(modelIds) + ")";
        HashMap<Long, Long> closingRateIdMap = new HashMap<Long, Long>(16);
        try (DataSet result = DB.queryDataSet((String)"queryClosingRate", (DBRoute)BCMConstant.DBROUTE, (String)queryClosingRateSql);){
            for (Object member2 : result) {
                Long modelId = member2.getLong("fmodelid");
                Long closingRateId = member2.getLong("fid");
                closingRateIdMap.put(modelId, closingRateId);
            }
        }
        String currentSettingDataSql = "select fid,fmodelid from t_bcm_ratefieldsetting";
        HashSet<Long> existModelIdSet = new HashSet<Long>(16);
        DataSet result = DB.queryDataSet((String)"queryExistModelId", (DBRoute)BCMConstant.DBROUTE, (String)currentSettingDataSql);
        member2 = null;
        try {
            for (Row member3 : result) {
                existModelIdSet.add(member3.getLong("fmodelid"));
            }
        }
        catch (Throwable throwable) {
            member2 = throwable;
            throw throwable;
        }
        finally {
            if (result != null) {
                if (member2 != null) {
                    try {
                        result.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)member2).addSuppressed(throwable);
                    }
                } else {
                    result.close();
                }
            }
        }
        ArrayList<Object[]> insertParamsList = new ArrayList<Object[]>(16);
        long creatorId = RequestContext.getOrCreate().getCurrUserId();
        Date now = TimeServiceHelper.now();
        for (Map.Entry entry : closingRateIdMap.entrySet()) {
            if (entry.getKey() == null || entry.getValue() == null || existModelIdSet.contains(entry.getKey())) continue;
            Object[] insertParams = new Object[]{GlobalIdUtil.genGlobalLongId(), entry.getKey(), "excval", entry.getValue(), 0, creatorId, now};
            insertParamsList.add(insertParams);
        }
        if (insertParamsList.size() > 0) {
            StringBuilder insertSql = new StringBuilder();
            insertSql.append("INSERT INTO t_bcm_ratefieldsetting");
            insertSql.append(" (fid,fmodelid,fsourcefield,faccountid,fseq,fcreatorid,fcreatetime)");
            insertSql.append(" VALUES(?,?,?,?,?,?,?);");
            try (TXHandle tx = TX.required((String)"exchangeRateFieldSetting");){
                try {
                    DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)insertSql.toString(), insertParamsList);
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error("ExchangeRateFieldSettingUpgradeService error", (Throwable)e);
                    throw new KDBizException(e.getMessage());
                }
            }
        }
        return this.success();
    }
}

