/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.enums.integration.IntegrateProductEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.ThrowableHelper;

public class ISSchemeExtendsTableUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        String sql = "select 1 from t_bcm_upgraderecord where fupgradetype=? ";
        Object[] params = new SqlParameter[]{new SqlParameter(":fupgradetype", 12, (Object)"isextendstable")};
        boolean upgraded = (Boolean)DB.query((DBRoute)BCMConstant.DBROUTE, (String)sql, (Object[])params, ResultSet::next);
        if (!upgraded) {
            try (TXHandle tx = TX.required((String)"ISSchemeExtendsTableUpgradeService");){
                try {
                    String sqlInsert = "insert into t_bcm_upgraderecord(fid,fupgradetype,fupgradetime) values(?,?,?)";
                    Object[] params1 = new Object[]{GlobalIdUtil.genGlobalLongId(), "isextendstable", new Date()};
                    DB.execute((DBRoute)BCMConstant.DBROUTE, (String)sqlInsert, (Object[])params1);
                    String sql4Product = "select fid from t_bcm_isproduct where fnumber=? ";
                    Object[] params4Product = new SqlParameter[]{new SqlParameter(":fnumber", 12, (Object)IntegrateProductEnum.XExtendProduct.getNumber())};
                    Long xId = (Long)DB.query((DBRoute)BCMConstant.DBROUTE, (String)sql4Product, (Object[])params4Product, rs -> {
                        if (rs.next()) {
                            return rs.getLong("fid");
                        }
                        return null;
                    });
                    if (!ObjectUtils.isEmpty((Object)xId)) {
                        String sql4Schemes = "select fid,fextendstable from t_bcm_isscheme where fissrcid=? ";
                        Object[] params4Schemes = new SqlParameter[]{new SqlParameter(":fissrcid", -5, (Object)xId)};
                        ArrayList schemeParamList = new ArrayList(10);
                        DB.query((DBRoute)BCMConstant.DBROUTE, (String)sql4Schemes, (Object[])params4Schemes, rs -> {
                            while (rs.next()) {
                                Object[] oneParam = new Object[]{"T_DS_".concat(rs.getString("fextendstable")), rs.getLong("fid")};
                                schemeParamList.add(oneParam);
                            }
                            return null;
                        });
                        if (schemeParamList.size() > 0) {
                            String sqlUpdate = "update t_bcm_isscheme set fextendstable = ? where fid = ?";
                            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sqlUpdate, schemeParamList);
                        }
                    }
                }
                catch (Exception e) {
                    tx.markRollback();
                    this.log.error("ISSchemeExtendsTableUpgradeService error", (Throwable)e);
                    throw new KDBizException(ThrowableHelper.generateFirstThreadCauseMessageInfo((Throwable)e, (int)30));
                }
            }
        }
        return this.success();
    }
}

