/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.invest.InvestServiceHelper;
import kd.fi.bcm.business.invest.changecase.InvChangeTypeServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.upgrade.InvRelationTypeCombo2BaseDataUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.common.enums.OrgBizChangeTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class InvChangeTypeResetUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"InvChangeTypeResetUpgradeService");){
            Set<Long> modelIds = this.getAllModel();
            if (modelIds.isEmpty()) {
                Map<String, Object> map = this.result();
                return map;
            }
            try {
                this.upgradeChangeTypeBymodels(modelIds);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvChangeTypeResetUpgradeService error", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return this.result();
    }

    public void upgradeChangeTypeBymodels(Set<Long> modelIds) {
        modelIds.remove(0L);
        InvRelationTypeCombo2BaseDataUpgradeService.changeNumberIfAreadyUsed(modelIds);
        Set<String> defaultTypes = InvChangeTypeServiceHelper.DEFAULT_DATA_MAPPER.stream().map(mapper -> (String)mapper.p1).collect(Collectors.toSet());
        Tuple<Map<Long, List<String>>, Table<Long, String, List<Long>>, Map<Long, Set<Long>>> mapTablePair = this.queryDefaultData(modelIds, defaultTypes);
        Map modelDefaultType = (Map)mapTablePair.p1;
        Table changeTypeNum2Id = (Table)mapTablePair.p2;
        HashSet srcModelIds = Sets.newHashSet(modelIds);
        List<Object> defaultData = new ArrayList(16);
        modelDefaultType.entrySet().stream().filter(map -> ((List)map.getValue()).size() == defaultTypes.size() && new HashSet((Collection)map.getValue()).containsAll(defaultTypes)).map(Map.Entry::getKey).forEach(modelIds::remove);
        if (!modelIds.isEmpty()) {
            defaultData = InvChangeTypeServiceHelper.setDefaultChangeTypeNew(modelIds);
        }
        Map<String, Object[]> defaultMap = defaultData.stream().collect(Collectors.toMap(k -> k[3] + "->" + k[1], v -> v));
        this.fixSharerelaChangeType(defaultMap, (Table<Long, String, List<Long>>)changeTypeNum2Id, srcModelIds, defaultTypes);
        this.fixRefChangeType(defaultMap, (Table<Long, String, List<Long>>)changeTypeNum2Id, srcModelIds, defaultTypes);
        this.fixDynamicStockratioChangeType(defaultMap, (Table<Long, String, List<Long>>)changeTypeNum2Id, srcModelIds, defaultTypes);
        if (!modelIds.isEmpty()) {
            HashSet<Long> deleteIds = new HashSet<Long>(16);
            modelIds.forEach(modelId -> changeTypeNum2Id.row(modelId).values().forEach(deleteIds::addAll));
            ((Map)mapTablePair.p3).values().forEach(deleteIds::addAll);
            if (!deleteIds.isEmpty()) {
                this.deleteDefaultData(deleteIds);
            }
        }
        srcModelIds.forEach(InvestServiceHelper::clearInvChangetypeSettingCache);
        new InvRelationTypeCombo2BaseDataUpgradeService().doInit(srcModelIds);
    }

    private Map<String, Object> result() {
        return this.success();
    }

    private void deleteDefaultData(Set<Long> ids) {
        SQLBuilder4RDB deleteSql = new SQLBuilder4RDB();
        deleteSql.append("delete from t_bcm_invchangetype where ").append("  fid in (").append(Joiner.on((String)",").join(ids)).append(")");
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)deleteSql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<Map<Long, List<String>>, Table<Long, String, List<Long>>, Map<Long, Set<Long>>> queryDefaultData(Set<Long> modelIds, Set<String> defaultTypes) {
        HashMap<Long, List> result = new HashMap<Long, List>(16);
        HashMap<Long, Set> changeTypeIds = new HashMap<Long, Set>(16);
        HashBasedTable changeTypeNum2Id = HashBasedTable.create();
        if (modelIds == null || modelIds.isEmpty()) {
            return Tuple.create(result, (Object)changeTypeNum2Id, changeTypeIds);
        }
        SQLBuilder4RDB selectSql = new SQLBuilder4RDB();
        selectSql.append("select fid,fmodelid,fnumber,fisdefault from t_bcm_invchangetype where fmodelid in (").append(Joiner.on((String)",").join(modelIds)).append(") and fnumber in ('").append(String.join((CharSequence)"','", defaultTypes)).append("')");
        DataSet ds = DB.queryDataSet((String)"query_model_invchangetype", (DBRoute)BCMConstant.DBROUTE, (String)selectSql.toString(), null);
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                Long fmodelid = row.getLong("fmodelid");
                Long fid = row.getLong("fid");
                String fnumber = row.getString("fnumber");
                String fisdefault = row.getString("fisdefault");
                if ("1".equals(fisdefault)) {
                    List typeNumber = result.computeIfAbsent(fmodelid, list -> new ArrayList(16));
                    typeNumber.add(fnumber);
                    ArrayList<Long> longs = (ArrayList<Long>)changeTypeNum2Id.get((Object)fmodelid, (Object)fnumber);
                    if (Objects.isNull(longs)) {
                        longs = new ArrayList<Long>(16);
                    }
                    longs.add(fid);
                    changeTypeNum2Id.put((Object)fmodelid, (Object)fnumber, longs);
                    continue;
                }
                Set typeIds = changeTypeIds.computeIfAbsent(fmodelid, set -> new HashSet(16));
                typeIds.add(fid);
            }
        }
        catch (Exception e) {
            this.log.error("count model invchangetype fail:", (Throwable)e);
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (Exception e) {
                    this.log.error("db close fail:", (Throwable)e);
                }
            }
        }
        return Tuple.create(result, (Object)changeTypeNum2Id, changeTypeIds);
    }

    private void fixSharerelaChangeType(Map<String, Object[]> defaultMap, Table<Long, String, List<Long>> changeTypeNum2Id, Set<Long> modelIds, Set<String> defaultTypes) {
        StringBuilder oldRelaDataSql = new StringBuilder("select rela.fid,rela.fmodelid,changetype.fnumber   from t_bcm_invsharerela  rela , t_bcm_invchangetype changetype where rela.finvchangetypeid=changetype.fid ");
        oldRelaDataSql.append("and changetype.fnumber in ('").append(String.join((CharSequence)"','", defaultTypes)).append("')");
        if (CollectionUtils.isNotEmpty(modelIds)) {
            oldRelaDataSql.append(" and rela.fmodelid in ").append("(").append(Joiner.on((String)",").join(modelIds)).append(")");
        }
        String updateSql = "update t_bcm_invsharerela set finvchangetypeid = ? where fid = ?";
        DataSet dataSet = DB.queryDataSet((String)"select_gettmpData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)oldRelaDataSql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelid = row.getLong("fmodelid");
            Long fid = row.getLong("fid");
            String changetypenumber = row.getString("fnumber");
            StringBuilder key = new StringBuilder(String.valueOf(modelid)).append("->").append(changetypenumber);
            Object[] param = new Object[2];
            Optional<Object[]> optional = Optional.ofNullable(defaultMap.get(key.toString()));
            Optional<Object> optional1 = Optional.ofNullable(changeTypeNum2Id.get((Object)modelid, (Object)changetypenumber));
            if (optional.isPresent()) {
                param[0] = optional.get()[0];
            } else {
                if (!optional1.isPresent()) continue;
                param[0] = ((List)optional1.get()).get(0);
            }
            param[1] = fid;
            paramsList.add(param);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramsList);
            paramsList.clear();
        }
    }

    private void fixRefChangeType(Map<String, Object[]> defaultMap, Table<Long, String, List<Long>> changeTypeNum2Id, Set<Long> modelIds, Set<String> defaultTypes) {
        StringBuilder oldRelaDataSql = new StringBuilder("select refchangetype.fid,refchangetype.fmodelid,changetype.fnumber   from t_bcm_invchangetype  refchangetype , t_bcm_invchangetype changetype where refchangetype.frelatedchangetypeid=changetype.fid ");
        oldRelaDataSql.append("and changetype.fnumber in ('").append(String.join((CharSequence)"','", defaultTypes)).append("')");
        if (CollectionUtils.isNotEmpty(modelIds)) {
            oldRelaDataSql.append(" and refchangetype.fmodelid in ").append("(").append(Joiner.on((String)",").join(modelIds)).append(")");
        }
        String updateSql = "update t_bcm_invchangetype set frelatedchangetypeid = ? where fid = ?";
        DataSet dataSet = DB.queryDataSet((String)"select_gettmpData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)oldRelaDataSql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelid = row.getLong("fmodelid");
            Long fid = row.getLong("fid");
            String changetypenumber = row.getString("fnumber");
            StringBuilder key = new StringBuilder(String.valueOf(modelid)).append("->").append(changetypenumber);
            Object[] param = new Object[2];
            Optional<Object[]> optional = Optional.ofNullable(defaultMap.get(key.toString()));
            Optional<Object> optional1 = Optional.ofNullable(changeTypeNum2Id.get((Object)modelid, (Object)changetypenumber));
            if (optional.isPresent()) {
                param[0] = optional.get()[0];
            } else {
                if (!optional1.isPresent()) continue;
                param[0] = ((List)optional1.get()).get(0);
            }
            param[1] = fid;
            paramsList.add(param);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramsList);
            paramsList.clear();
        }
    }

    private void fixDynamicStockratioChangeType(Map<String, Object[]> defaultMap, Table<Long, String, List<Long>> changeTypeNum2Id, Set<Long> srcModelIds, Set<String> defaultTypes) {
        StringBuilder oldRelaDataSql = new StringBuilder("select stockratio.fid,stockratio.fmodelid,changetype.fnumber   from t_bcm_dynamicstockratio  stockratio , t_bcm_invchangetype changetype where stockratio.finvchangetypeid=changetype.fid ");
        oldRelaDataSql.append("and changetype.fnumber in ('").append(String.join((CharSequence)"','", defaultTypes)).append("')");
        if (CollectionUtils.isNotEmpty(srcModelIds)) {
            oldRelaDataSql.append(" and stockratio.fmodelid in ").append("(").append(Joiner.on((String)",").join(srcModelIds)).append(")");
        }
        String updateSql = "update t_bcm_dynamicstockratio set finvchangetypeid = ? where fid = ?";
        DataSet dataSet = DB.queryDataSet((String)"select_gettmpData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)oldRelaDataSql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelid = row.getLong("fmodelid");
            Long fid = row.getLong("fid");
            String changetypenumber = row.getString("fnumber");
            StringBuilder key = new StringBuilder(String.valueOf(modelid)).append("->").append(changetypenumber);
            Object[] param = new Object[2];
            Optional<Object[]> optional = Optional.ofNullable(defaultMap.get(key.toString()));
            Optional<Object> optional1 = Optional.ofNullable(changeTypeNum2Id.get((Object)modelid, (Object)changetypenumber));
            if (optional.isPresent()) {
                param[0] = optional.get()[0];
            } else {
                if (!optional1.isPresent()) continue;
                param[0] = ((List)optional1.get()).get(0);
            }
            param[1] = fid;
            paramsList.add(param);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramsList);
            paramsList.clear();
        }
    }

    private Set<Long> getAllModel() {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(16);
        String sql = "select fid from T_BCM_MODEL where fid != 0 ";
        DataSet rows = DB.queryDataSet((String)"queryAllModelId", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (rows.hasNext()) {
            Row next = rows.next();
            Long id = next.getLong("fid");
            ids.add(id);
        }
        return ids;
    }

    public void deleteDirtyDataOfInv(Long modelId) {
        int n;
        Map<String, List<DynamicObject>> num2Dys;
        Set repeatNums;
        if (modelId == 0L) {
            return;
        }
        QFilter qf = new QFilter("model", "=", (Object)modelId);
        List defNumsAll = Arrays.stream(OrgBizChangeTypeEnum.values()).map(x -> x.getCode()).collect(Collectors.toList());
        QFilter qfNum = new QFilter("number", "in", defNumsAll);
        DynamicObject[] invChangetypes = BusinessDataServiceHelper.load((String)"bcm_invchangetype", (String)"id, number, creator.id, modifier.id, isdefault", (QFilter[])new QFilter[]{qf, qfNum});
        if (invChangetypes.length == 0) {
            this.upgradeChangeTypeBymodels(Sets.newHashSet((Object[])new Long[]{modelId}));
            invChangetypes = BusinessDataServiceHelper.load((String)"bcm_invchangetype", (String)"id, number, creator.id, modifier.id, isdefault", (QFilter[])new QFilter[]{qf, qfNum});
        }
        if ((repeatNums = (num2Dys = Arrays.stream(invChangetypes).collect(Collectors.groupingBy(ele -> ele.getString("number")))).values().stream().filter(x -> x.size() > 1).collect(Collectors.toSet())).size() == 0) {
            return;
        }
        HashMap map = new HashMap(16);
        num2Dys.forEach((k, v) -> {
            long id = ((DynamicObject)v.get(0)).getLong("id");
            v.forEach(ele -> {
                long othId = ele.getLong("id");
                if (othId != id) {
                    map.put(othId, id);
                }
            });
        });
        DynamicObject[] invshares = BusinessDataServiceHelper.load((String)"bcm_invsharerela", (String)"invchangetype.id", (QFilter[])qf.toArray());
        if (invshares.length != 0) {
            DynamicObject[] dynamicObjectArray = invshares;
            int n2 = dynamicObjectArray.length;
            for (n = 0; n < n2; ++n) {
                DynamicObject invshare;
                Long oldInvId = (invshare = dynamicObjectArray[n]).getLong("invchangetype.id");
                Long newInvId = (Long)map.get(oldInvId);
                invshare.set("invchangetype", (Object)(newInvId == null ? oldInvId : newInvId));
            }
        }
        SaveServiceHelper.save((DynamicObject[])invshares);
        DynamicObject[] invDyStos = BusinessDataServiceHelper.load((String)"bcm_dynamicstockratio", (String)"invchangetype.id", (QFilter[])qf.toArray());
        if (invDyStos.length != 0) {
            DynamicObject[] dynamicObjectArray = invDyStos;
            n = dynamicObjectArray.length;
            for (int invshare = 0; invshare < n; ++invshare) {
                DynamicObject invDySto;
                Long oldInvId = (invDySto = dynamicObjectArray[invshare]).getLong("invchangetype.id");
                Long newInvId = (Long)map.get(oldInvId);
                invDySto.set("invchangetype", (Object)(newInvId == null ? oldInvId : newInvId));
            }
        }
        SaveServiceHelper.save((DynamicObject[])invDyStos);
        Set invIds = map.keySet();
        QFilter qfIds = new QFilter("id", "in", invIds);
        DeleteServiceHelper.delete((String)"bcm_invchangetype", (QFilter[])new QFilter[]{qfIds});
        HashSet referIds = new HashSet(map.values());
        referIds.addAll(num2Dys.values().stream().filter(x -> x.size() == 1).map(y -> ((DynamicObject)y.get(0)).getLong("id")).collect(Collectors.toSet()));
        List<DynamicObject> referDys = Arrays.stream(invChangetypes).filter(ele -> referIds.contains(ele.getLong("id"))).collect(Collectors.toList());
        long currUserId = RequestContext.get().getCurrUserId();
        referDys.forEach(ele -> {
            if (0L == ele.getLong("creator.id")) {
                ele.set("creator", (Object)currUserId);
            }
            if (0L == ele.getLong("modifier.id")) {
                ele.set("modifier", (Object)currUserId);
            }
            if (!ele.getBoolean("isdefault")) {
                ele.set("isdefault", (Object)true);
            }
        });
        SaveServiceHelper.save((DynamicObject[])referDys.toArray(new DynamicObject[0]));
        Set<String> invNums = num2Dys.keySet();
        if (!invNums.containsAll(defNumsAll)) {
            this.upgradeChangeTypeBymodels(Sets.newHashSet((Object[])new Long[]{modelId}));
        }
    }
}

