/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.base.Joiner;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.cache.PromptWordCacheNew;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.lang.Lang;
import kd.fi.bcm.business.invest.changecase.InvChangeTypeServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Tuple;
import kd.fi.bcm.common.db.SQLBuilder4RDB;
import kd.fi.bcm.common.enums.MultiLangEnumBridge;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class InvChangeTypeShareUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"InvChangeTypeUpgradeService");){
            HashSet modelIds = Sets.newHashSet((Object[])new Long[]{0L});
            Map<Long, Long> modelCount = this.queryDefaultData(modelIds);
            int size = this.getOldMapper().size();
            modelCount.entrySet().stream().filter(map -> ((Long)map.getValue()).intValue() >= size).map(Map.Entry::getKey).forEach(modelIds::remove);
            if (modelIds.isEmpty()) {
                Map<String, Object> map2 = this.result();
                return map2;
            }
            try {
                this.deleteDefaultData(modelIds);
                InvChangeTypeServiceHelper.setDefaultChangeType(modelIds);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvChangeTypeUpgradeService error", (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
        }
        return this.result();
    }

    private Map<String, Object> result() {
        this.fillMultiLang();
        return this.success();
    }

    private void fillMultiLang() {
        Map<String, String> oldMapper = this.getOldMapper();
        String sql2DefaultData = "select fid,fnumber from t_bcm_invchangetype where fnumber in ('" + String.join((CharSequence)"','", oldMapper.keySet()) + "')";
        DataSet changeTypeSet = DB.queryDataSet((String)"select_getDefaultData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)sql2DefaultData);
        HashMap id2Number = Maps.newHashMap();
        while (changeTypeSet != null && changeTypeSet.hasNext()) {
            Row next = changeTypeSet.next();
            id2Number.put(next.getString("fid"), next.getString("fnumber"));
        }
        String sql2MultiLang = "select fid from t_bcm_invchangetype_l where fid in (" + String.join((CharSequence)",", id2Number.keySet()) + ")";
        DataSet multiLangSet = DB.queryDataSet((String)"select_getDefaultDataL_000", (DBRoute)DBRoute.of((String)"bcm"), (String)sql2MultiLang);
        HashSet multiLangQuery = Sets.newHashSet();
        while (multiLangSet != null && multiLangSet.hasNext()) {
            multiLangQuery.add(multiLangSet.next().getString("fid"));
        }
        multiLangQuery.forEach(id -> {
            String cfr_ignored_0 = (String)id2Number.remove(id);
        });
        if (id2Number.isEmpty()) {
            return;
        }
        List<Tuple<String, MultiLangEnumBridge, String>> defaultDataMapper = InvChangeTypeServiceHelper.DEFAULT_DATA_MAPPER;
        HashBasedTable table = HashBasedTable.create();
        Lang[] allLang = Lang.values();
        for (Tuple<String, MultiLangEnumBridge, String> tuple : defaultDataMapper) {
            String number2 = (String)tuple.p1;
            MultiLangEnumBridge p2 = (MultiLangEnumBridge)tuple.p2;
            String description = p2.getDescription();
            String resourceID = p2.getResourceID();
            String systemType = p2.getSystemType();
            for (Lang lang : allLang) {
                this.addWhenNonNull((HashBasedTable<String, Lang, String>)table, number2, description, resourceID, systemType, lang);
            }
        }
        ArrayList items = Lists.newArrayList();
        id2Number.forEach((id, number) -> {
            Map row = table.row(number);
            row.keySet().forEach(lang -> {
                Object[] param = new Object[4];
                param[1] = Long.valueOf(id);
                param[2] = lang.toString();
                param[3] = row.get(lang);
                items.add(param);
            });
        });
        String[] pks = GlobalIdUtil.genStringIds((int)items.size());
        for (int i = 0; i < pks.length; ++i) {
            ((Object[])items.get((int)i))[0] = pks[i];
        }
        String insertSql = "INSERT INTO t_bcm_invchangetype_l (fpkid, fid, flocaleid, fname) VALUES(?, ?, ?, ?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, (List)items);
    }

    private void deleteDefaultLangData(Set<Long> modelIds) {
        SQLBuilder4RDB deleteSql = new SQLBuilder4RDB();
        deleteSql.append("delete from t_bcm_invchangetype_l where fid in (select fid from t_bcm_invchangetype where fmodelid in (").append(Joiner.on((String)",").join(modelIds)).append("))");
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)deleteSql.toString());
    }

    private void addWhenNonNull(HashBasedTable<String, Lang, String> table, String number, String description, String resourceID, String systemType, Lang lang) {
        String promptWordCN = PromptWordCacheNew.getPromptWord((String)description, (String)resourceID, (Lang)lang, (String)systemType, (Object[])new Object[0]);
        if (Objects.nonNull(promptWordCN)) {
            table.put((Object)number, (Object)lang, (Object)promptWordCN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, Long> queryDefaultData(Set<Long> modelIds) {
        HashMap<Long, Long> result = new HashMap<Long, Long>(16);
        if (modelIds == null || modelIds.isEmpty()) {
            return result;
        }
        SQLBuilder4RDB selectSql = new SQLBuilder4RDB();
        selectSql.append("select fmodelid,count(fmodelid) as changetypecount from t_bcm_invchangetype where fmodelid in (").append(Joiner.on((String)",").join(modelIds)).append(") and fisdefault = '1' group by fmodelid");
        DataSet ds = DB.queryDataSet((String)"query_model_invchangetype", (DBRoute)BCMConstant.DBROUTE, (String)selectSql.toString(), null);
        try {
            while (ds != null && ds.hasNext()) {
                Row row = ds.next();
                result.put(row.getLong("fmodelid"), row.getLong("changetypecount"));
            }
        }
        catch (Exception e) {
            this.log.error("count model invchangetype fail:", (Throwable)e);
        }
        finally {
            if (ds != null) {
                try {
                    ds.close();
                }
                catch (Exception e) {
                    this.log.error("db close fail:", (Throwable)e);
                }
            }
        }
        return result;
    }

    private void deleteDefaultData(Set<Long> modelIds) {
        SQLBuilder4RDB deleteSql = new SQLBuilder4RDB();
        deleteSql.append("delete from t_bcm_invchangetype where fmodelid in (").append(Joiner.on((String)",").join(modelIds)).append(")");
        DB.execute((DBRoute)BCMConstant.DBROUTE, (String)deleteSql.toString());
    }

    private Map<String, String> getOldMapper() {
        HashMap<String, String> mp = new HashMap<String, String>();
        mp.put("BD001", "1");
        mp.put("BD002", "8");
        mp.put("BD003", "2");
        mp.put("BD004", "3");
        mp.put("BD005", "6");
        mp.put("BD006", "4");
        mp.put("BD007", "5");
        mp.put("BD008", "a");
        mp.put("BD009", "b");
        mp.put("BD010", "9");
        mp.put("BD011", "10");
        mp.put("BD012", "11");
        mp.put("BD013", "12");
        mp.put("BD014", "13");
        return mp;
    }
}

