/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.spread.formula.ExcelFormulaPaserHelper;
import kd.fi.bcm.spread.formula.expr.BinaryOperationExpr;
import kd.fi.bcm.spread.formula.expr.Expression;
import kd.fi.bcm.spread.formula.expr.FunctionExpr;
import kd.fi.bcm.spread.formula.expr.StringExpr;

public class InvElimRuleExprUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        String atExpr = "AT.ATTotal";
        try {
            DynamicObject[] allDatas = this.getInvElimList();
            if (allDatas.length > 0) {
                ArrayList<DynamicObject> saveDatas = new ArrayList<DynamicObject>();
                AtomicBoolean atbool = new AtomicBoolean(false);
                for (DynamicObject dyn : allDatas) {
                    DynamicObjectCollection entry = dyn.getDynamicObjectCollection("invelimtplentry");
                    boolean needSave = false;
                    for (DynamicObject row : entry) {
                        String exprsrc = row.getString("ruleexprsource");
                        Expression exprs = ExcelFormulaPaserHelper.parse((String)exprsrc);
                        atbool.set(false);
                        this.handlerExpression(exprs, atExpr, atbool);
                        if (!atbool.get()) continue;
                        needSave = true;
                        row.set("ruleexprsource", (Object)exprs.toString());
                    }
                    if (!needSave) continue;
                    saveDatas.add(dyn);
                }
                if (!saveDatas.isEmpty()) {
                    SaveServiceHelper.save((DynamicObject[])saveDatas.toArray(new DynamicObject[0]));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.success();
    }

    private void handlerExpression(Expression exprs, String at, AtomicBoolean atbool) {
        if (exprs instanceof FunctionExpr) {
            List params;
            boolean hasAT;
            FunctionExpr funcexpr = (FunctionExpr)exprs;
            String func = funcexpr.getFuncionName().toUpperCase(Locale.ENGLISH);
            if ("V".equals(func) && !(hasAT = (params = funcexpr.getParameters()).stream().anyMatch(o -> {
                if (o instanceof StringExpr) {
                    String str = ((StringExpr)o).getValue();
                    return str.startsWith("AT.");
                }
                return false;
            }))) {
                params.add(1, new StringExpr(at));
                atbool.set(true);
            }
        } else if (exprs instanceof BinaryOperationExpr) {
            this.handlerExpression(((BinaryOperationExpr)exprs).getLeft(), at, atbool);
            this.handlerExpression(((BinaryOperationExpr)exprs).getRight(), at, atbool);
        }
    }

    private DynamicObject[] getInvElimList() {
        QFilter qf = new QFilter("invelimtplentry.ruleexprsource", "is not null", null);
        qf.and("invelimtplentry.ruleexprsource", "!=", (Object)"");
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"bcm_invelimtemplate", (String)"id,billno,name,invelimtplentry.ruleexprsource", (QFilter[])qf.toArray());
        return datas;
    }
}

