/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.lang.Lang;
import kd.fi.bcm.business.invest.changecase.InvChangeTypeServiceHelper;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.constant.invest.sharerela.InvRelationTypeConstant;
import kd.fi.bcm.common.enums.invest.InvRelaTypeEnum;
import kd.fi.bcm.common.util.LongUtil;
import org.apache.commons.collections.CollectionUtils;

public class InvRelationTypeCombo2BaseDataUpgradeService
extends BcmUpgradeService {
    private String lang = Lang.get().toString();
    private long user = RequestContext.get().getCurrUserId();
    private Date now = new Date();
    private GlobalIdDistributer idDistributor = new GlobalIdDistributer();
    private Map<String, Pair<Boolean, Map<String, String>>> number2Names = new HashMap<String, Pair<Boolean, Map<String, String>>>(32);

    @Override
    public Map<String, Object> upgrade() {
        try {
            Set<Long> allModel = this.getAllModel();
            this.upgradeChangeTypeByModel(allModel);
            return this.success();
        }
        catch (Exception e) {
            return this.fail(e);
        }
    }

    public void upgradeChangeTypeByModel(Set<Long> allModel) {
    }

    public static void changeNumberIfAreadyUsed(Set<Long> allModel) {
        if (CollectionUtils.isEmpty(allModel)) {
            return;
        }
        String sql = "select fid,fmodelid,fnumber from t_bcm_invchangetype where fnumber in ('BD998','BD999') and fisdefault = '0' ";
        String updateSql = "UPDATE t_bcm_invchangetype SET fnumber=? WHERE fid=?";
        ArrayList<Object[]> items = new ArrayList<Object[]>(16);
        ArrayList<Object[]> structItems = new ArrayList<Object[]>(16);
        DataSet rs = DB.queryDataSet((String)"select_getDefaultData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        Map<Object, Object> old2New = new HashMap(16);
        while (rs.hasNext()) {
            Row next = rs.next();
            Long id = next.getLong("fid");
            String number = next.getString("fnumber");
            String modelId = next.getString("fmodelid");
            if (!allModel.contains(LongUtil.toLong((Object)modelId))) continue;
            old2New = InvRelationTypeCombo2BaseDataUpgradeService.getOld2NewMap(modelId);
            Object[] objects = new Object[]{old2New.get(number), id};
            items.add(objects);
        }
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        String structSql = "select biz.fchangetype,biz.fentityid,changetype.fid,changetype.fmodelid from t_bcm_entitybizrecord  biz join  t_bcm_structofent ent  on biz.fid=ent.fid\n    join t_bcm_invchangetype changetype on biz.fchangetype = changetype.fnumber and  changetype.fmodelid = ent.fmodelid\n    where   changetype.fnumber in ('BD998','BD999') and changetype.fisdefault = '0'";
        String updateStructSql = "UPDATE t_bcm_entitybizrecord SET fchangetype=? WHERE fentityid=?";
        DataSet structRs = DB.queryDataSet((String)"select_getDefaultData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)structSql);
        while (structRs.hasNext()) {
            Row row = structRs.next();
            String changeType = row.getString("fchangetype");
            Long entityId = row.getLong("fentityid");
            Long modelId = row.getLong("fmodelid");
            if (!allModel.contains(modelId)) continue;
            Object[] structObjects = new Object[2];
            old2New = InvRelationTypeCombo2BaseDataUpgradeService.getOld2NewMap(String.valueOf(modelId));
            structObjects[0] = old2New.get(changeType);
            structObjects[1] = entityId;
            structItems.add(structObjects);
        }
        if (!items.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateSql, items);
        }
        if (!structItems.isEmpty()) {
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)updateStructSql, structItems);
        }
    }

    private static Map<String, String> getOld2NewMap(String modelId) {
        return (Map)ThreadCache.get((Object)("getOld2NewMap" + modelId), () -> {
            String sql = "select fnumber from t_bcm_invchangetype where fnumber like 'BD%' and fmodelid = " + modelId;
            DataSet rs = DB.queryDataSet((String)"select_getDefaultData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
            long maxNumber = 15L;
            while (rs.hasNext()) {
                Row next = rs.next();
                String number = next.getString("fnumber");
                String num = number.substring(2);
                Long aLong = LongUtil.toLong((Object)num);
                maxNumber = Math.max(maxNumber, aLong);
            }
            if (maxNumber == 997L | maxNumber == 998L) {
                maxNumber = 1000L;
            }
            String pre = String.valueOf(maxNumber).length() == 2 ? "BD0" : "BD";
            HashMap<String, String> old2New = new HashMap<String, String>(16);
            old2New.put("BD998", pre + (maxNumber + 1L));
            old2New.put("BD999", pre + (maxNumber + 2L));
            return old2New;
        });
    }

    public void doInit(Set<Long> allModel) {
        Set<Long> updateModelIds = this.getUpdateModel(allModel);
        HashMap commonChangeTypeDesc = new HashMap(16);
        InvChangeTypeServiceHelper.getTranslateMap(InvChangeTypeServiceHelper.DEFAULT_DATA_MAPPER, (number, translate) -> {
            Map<String, String> translateMap = translate.entrySet().stream().collect(Collectors.toMap(k -> ((Lang)k.getKey()).toString(), v -> (String)v.getValue(), (v1, v2) -> v1));
            commonChangeTypeDesc.put(number, translateMap);
        });
        PlatUtil.executeWithTXNew(tx -> {
            ArrayList<String> batchIds = new ArrayList<String>(128);
            for (Long modelId : updateModelIds) {
                batchIds.add(String.valueOf(modelId));
                this.updateThenClearIfTrue(commonChangeTypeDesc, batchIds, batchIds.size() > 100);
            }
            this.updateThenClearIfTrue(commonChangeTypeDesc, batchIds, !batchIds.isEmpty());
        });
    }

    private void updateThenClearIfTrue(Map<String, Map<String, String>> commonChangeTypeDesc, List<String> batchIds, boolean isUpdate) {
        if (isUpdate) {
            Set<String> commonNumbers = commonChangeTypeDesc.keySet();
            Table<String, String, Map<String, String>> changeTypeDesc = this.changeTypeDesc(batchIds, commonNumbers);
            Table<String, String, Pair<Boolean, Map<String, String>>> relationDesc = this.staticRelationDesc(batchIds);
            ArrayList<Object[]> items = new ArrayList<Object[]>(16);
            ArrayList<Object[]> itemsL = new ArrayList<Object[]>(16);
            ArrayList<Object[]> itemsRlt = new ArrayList<Object[]>(16);
            ArrayList<Object[]> itemsEntry = new ArrayList<Object[]>(16);
            StringJoiner paperTempIds = new StringJoiner(",");
            HashBasedTable number2Id = HashBasedTable.create();
            for (String modelId : batchIds) {
                Map changeType2Rlt = changeTypeDesc.column((Object)modelId);
                this.changeType2Rlt(items, itemsL, modelId, changeType2Rlt);
                this.changeType2Rlt(items, itemsL, modelId, commonChangeTypeDesc);
                Map staticRlt = relationDesc.row((Object)modelId);
                Map row = number2Id.column((Object)modelId);
                this.staticRlt(items, itemsL, modelId, staticRlt, row);
            }
            this.buildItems((Table<String, String, Long>)number2Id, (paramsRlt, paramsEntry) -> {
                itemsRlt.add((Object[])paramsRlt);
                itemsEntry.add((Object[])paramsEntry);
                paperTempIds.add(String.valueOf(paramsRlt[1]));
            });
            String invRLTInsert = "INSERT INTO t_bcm_invrelatype (fid, fnumber, fname, fstatus, fmodelid, fcategorized, fcreaterid, fmodifierid, fcreatetime, fmodifytime, fseq) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            String invRLTInsertL = "INSERT INTO t_bcm_invrelatype_l (fpkid, fid, flocaleid, fname) VALUES(?, ?, ?, ?) ";
            String relationInsert = "INSERT INTO t_bcm_papertemplate_rlt (fpkid, fid, fbasedataid) VALUES(?, ?, ?)";
            String entryUpdate = "UPDATE t_bcm_invsheetentry SET frelationtypeid=?  WHERE ftemplateid=? ";
            if (paperTempIds.length() > 0) {
                String relationClean = "DELETE FROM t_bcm_papertemplate_rlt WHERE fid in (" + paperTempIds + ")";
                DB.execute((DBRoute)DBRoute.of((String)"bcm"), (String)relationClean);
            }
            this.doSaveIfNotEmpty(items, () -> DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)invRLTInsert, (List)items));
            this.doSaveIfNotEmpty(itemsL, () -> DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)invRLTInsertL, (List)itemsL));
            this.doSaveIfNotEmpty(itemsRlt, () -> DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)relationInsert, (List)itemsRlt));
            this.doSaveIfNotEmpty(itemsEntry, () -> DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)entryUpdate, (List)itemsEntry));
            batchIds.clear();
        }
    }

    private void doSaveIfNotEmpty(List<Object[]> item, Runnable runner) {
        if (!item.isEmpty()) {
            runner.run();
        }
    }

    private void changeType2Rlt(List<Object[]> items, List<Object[]> itemsL, String modelId, Map<String, Map<String, String>> changeType2Rlt) {
        changeType2Rlt.forEach((number, names) -> {
            Object[] params = this.getParams(modelId, (String)number);
            params[5] = InvRelationTypeConstant.CatalogEnum.change_type.getCode();
            params[3] = InvRelationTypeConstant.StatusEnum.ENABLE.getCode();
            params[10] = 0;
            this.multiLanguages(itemsL, (Map<String, String>)names, params);
            items.add(params);
        });
    }

    private void staticRlt(List<Object[]> items, List<Object[]> itemsL, String modelId, Map<String, Pair<Boolean, Map<String, String>>> staticRlt, Map<String, Long> row) {
        staticRlt.forEach((number, pair) -> {
            Boolean status = (Boolean)pair.p1;
            Map names = (Map)pair.p2;
            Object[] params = this.getParams(modelId, (String)number);
            params[5] = InvRelationTypeConstant.CatalogEnum.relation.getCode();
            params[3] = status != false ? 1 : 0;
            params[10] = this.getSeq(params[1]);
            this.multiLanguages(itemsL, names, params);
            items.add(params);
            row.computeIfAbsent((String)params[1], key -> (Long)params[0]);
        });
    }

    private int getSeq(Object param) {
        int i = LongUtil.toLong((Object)param).intValue();
        switch (i) {
            case 1: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 4;
            }
        }
        return i;
    }

    private Object[] getParams(String modelId, String number) {
        Object[] params = new Object[11];
        params[0] = this.idDistributor.getLongId();
        params[1] = number;
        params[4] = LongUtil.toLong((Object)modelId);
        params[6] = this.user;
        params[7] = this.user;
        params[8] = this.now;
        params[9] = this.now;
        return params;
    }

    private void multiLanguages(List<Object[]> itemsL, Map<String, String> names, Object[] params) {
        names.forEach((localeId, des) -> {
            if (this.lang.equals(localeId)) {
                params[2] = des;
            }
            Object[] paramsL = new Object[]{this.idDistributor.getStringId(), params[0], localeId, des};
            itemsL.add(paramsL);
        });
    }

    private void buildItems(Table<String, String, Long> number2Id, BiConsumer<Object[], Object[]> consumer) {
        Set modelIds = number2Id.columnKeySet();
        if (modelIds.isEmpty()) {
            return;
        }
        String paperSql = "select finvrelationtype,fmodelid,fid from t_bcm_papertemplate where fmodelid in (" + String.join((CharSequence)",", modelIds) + ")";
        DataSet changeTypeRs = DB.queryDataSet((String)"select_papertemplate_000", (DBRoute)DBRoute.of((String)"bcm"), (String)paperSql);
        while (changeTypeRs.hasNext()) {
            Row next = changeTypeRs.next();
            String modelId = next.getString("fmodelid");
            String invRelationType = next.getString("finvrelationtype");
            Long id = next.getLong("fid");
            Long typeId = (Long)number2Id.get((Object)invRelationType, (Object)modelId);
            if (typeId == null) continue;
            Object[] paramsRlt = new Object[]{this.idDistributor.getLongId(), id, typeId};
            Object[] paramsEntry = new Object[]{typeId, id};
            consumer.accept(paramsRlt, paramsEntry);
        }
    }

    private Table<String, String, Pair<Boolean, Map<String, String>>> staticRelationDesc(List<String> modelIds) {
        HashBasedTable collector = HashBasedTable.create();
        if (modelIds.isEmpty()) {
            return collector;
        }
        Map<String, Pair<Boolean, Map<String, String>>> number2Names = this.initDefaultStaticRelation();
        HashMap<String, String> id2Model = new HashMap<String, String>(16);
        String staticRelationTypeSql = "select fdirecteown,findireownsum,findireownmul,finshareeown,fintrashareeown,fmodelid,fid FROM t_bcm_invrelationset A where fmodelid in (" + String.join((CharSequence)",", modelIds) + ")";
        DataSet settingRs = DB.queryDataSet((String)"select_invrelationset_000", (DBRoute)DBRoute.of((String)"bcm"), (String)staticRelationTypeSql);
        while (settingRs.hasNext()) {
            Row next = settingRs.next();
            String modelId = next.getString("fmodelid");
            Boolean directEOwn = next.getBoolean("fdirecteown");
            this.collect(number2Names, (Table<String, String, Pair<Boolean, Map<String, String>>>)collector, modelId, directEOwn, InvRelaTypeEnum.DirectRelaType.getType());
            Boolean inDirEOwnSum = next.getBoolean("findireownsum");
            this.collect(number2Names, (Table<String, String, Pair<Boolean, Map<String, String>>>)collector, modelId, inDirEOwnSum, InvRelaTypeEnum.INDirectRelaType.getType());
            Boolean finDirEOwnMul = next.getBoolean("findireownmul");
            this.collect(number2Names, (Table<String, String, Pair<Boolean, Map<String, String>>>)collector, modelId, finDirEOwnMul, InvRelaTypeEnum.MultiRelaType.getType());
            Boolean finShareEOwn = next.getBoolean("finshareeown");
            this.collect(number2Names, (Table<String, String, Pair<Boolean, Map<String, String>>>)collector, modelId, finShareEOwn, InvRelaTypeEnum.SameLevelRelaType.getType());
            Boolean finTraShareEOwn = next.getBoolean("fintrashareeown");
            this.collect(number2Names, (Table<String, String, Pair<Boolean, Map<String, String>>>)collector, modelId, finTraShareEOwn, InvRelaTypeEnum.MinRelaType.getType());
            String id = next.getString("fid");
            id2Model.put(id, modelId);
        }
        this.userDefineReplace(number2Names, (Table<String, String, Pair<Boolean, Map<String, String>>>)collector, id2Model);
        for (String modelId : modelIds) {
            number2Names.forEach((arg_0, arg_1) -> InvRelationTypeCombo2BaseDataUpgradeService.lambda$staticRelationDesc$15((Table)collector, modelId, arg_0, arg_1));
        }
        return collector;
    }

    private void userDefineReplace(Map<String, Pair<Boolean, Map<String, String>>> number2Names, Table<String, String, Pair<Boolean, Map<String, String>>> collector, Map<String, String> id2Model) {
        Map multiLanguageMap;
        if (id2Model.isEmpty()) {
            return;
        }
        HashMap<String, String> defineOwnTypeMap = new HashMap<String, String>(3);
        defineOwnTypeMap.put("defineeown1", InvRelaTypeEnum.CustomRelaType1.getType());
        defineOwnTypeMap.put("defineeown2", InvRelaTypeEnum.CustomRelaType2.getType());
        defineOwnTypeMap.put("defineeown3", InvRelaTypeEnum.CustomRelaType3.getType());
        HashMap<String, Pair> entryId2key = new HashMap<String, Pair>(16);
        String defineSql = "select fdefineeown,fname,fisselected,fid,fentryid from t_bcm_invrelationdefine where fid in (" + String.join((CharSequence)",", id2Model.keySet()) + ")";
        DataSet defineRs = DB.queryDataSet((String)"select_invrelationdefine_000", (DBRoute)DBRoute.of((String)"bcm"), (String)defineSql);
        while (defineRs.hasNext()) {
            Row next = defineRs.next();
            String id = next.getString("fid");
            String entryId = next.getString("fentryid");
            String name = next.getString("fname");
            String defineEOwn = next.getString("fdefineeown");
            String type = (String)defineOwnTypeMap.get(defineEOwn);
            Boolean isSelected = next.getBoolean("fisselected");
            String modelId = id2Model.get(id);
            multiLanguageMap = this.collect(number2Names, collector, modelId, isSelected, type);
            multiLanguageMap.put((String)this.lang, (String)name);
            entryId2key.put(entryId, Pair.onePair((Object)modelId, (Object)type));
        }
        if (entryId2key.isEmpty()) {
            return;
        }
        String defineSqlL = "SELECT fpkid, flocaleid, fname, fentryid FROM t_bcm_invrelationdefine_l WHERE fentryid IN (" + String.join((CharSequence)",", entryId2key.keySet()) + ")";
        DataSet defineLRs = DB.queryDataSet((String)"select_invrelationdefine_l_000", (DBRoute)DBRoute.of((String)"bcm"), (String)defineSqlL);
        while (defineLRs.hasNext()) {
            Row next = defineLRs.next();
            String localeId = next.getString("flocaleid");
            String name = next.getString("fname");
            String entryId = next.getString("fentryid");
            Pair pair = (Pair)entryId2key.get(entryId);
            Pair config = (Pair)collector.get(pair.p1, pair.p2);
            if (config == null) continue;
            multiLanguageMap = (Map)config.p2;
            multiLanguageMap.put(localeId, name);
        }
    }

    private Map<String, Pair<Boolean, Map<String, String>>> initDefaultStaticRelation() {
        if (!this.number2Names.isEmpty()) {
            return this.number2Names;
        }
        ArrayList defaultRelaTypeEnums = Lists.newArrayList((Object[])new InvRelaTypeEnum[]{InvRelaTypeEnum.DirectRelaType, InvRelaTypeEnum.MinRelaType, InvRelaTypeEnum.INDirectRelaType, InvRelaTypeEnum.MultiRelaType, InvRelaTypeEnum.SameLevelRelaType});
        for (InvRelaTypeEnum typeEnum : InvRelaTypeEnum.values()) {
            Map translate = typeEnum.getTranslate();
            HashMap names = new HashMap(4);
            translate.forEach((k, v) -> names.put(k.toString(), v));
            this.number2Names.put(typeEnum.getType(), (Pair<Boolean, Map<String, String>>)Pair.onePair((Object)defaultRelaTypeEnums.contains(typeEnum), names));
        }
        return this.number2Names;
    }

    private Map<String, String> collect(Map<String, Pair<Boolean, Map<String, String>>> number2Names, Table<String, String, Pair<Boolean, Map<String, String>>> collector, String modelId, Boolean status, String type) {
        Pair<Boolean, Map<String, String>> booleanMapPair = number2Names.get(type);
        HashMap multiLanguages = Maps.newHashMap((Map)((Map)booleanMapPair.p2));
        collector.put((Object)modelId, (Object)type, (Object)Pair.onePair((Object)status, (Object)multiLanguages));
        return multiLanguages;
    }

    private Table<String, String, Map<String, String>> changeTypeDesc(List<String> modelIds, Set<String> commonNumbers) {
        HashBasedTable collector = HashBasedTable.create();
        if (modelIds.isEmpty()) {
            return collector;
        }
        String changeTypeDefault = "select fnumber,fid,fname,fmodelid from t_bcm_invchangetype where fmodelid in (" + String.join((CharSequence)",", modelIds) + ") ";
        DataSet changeTypeRs = DB.queryDataSet((String)"select_invchangetype_000", (DBRoute)DBRoute.of((String)"bcm"), (String)changeTypeDefault);
        HashMap<String, Pair> id2Number = new HashMap<String, Pair>(16);
        while (changeTypeRs.hasNext()) {
            Row next = changeTypeRs.next();
            String defName = next.getString("fname");
            String number = next.getString("fnumber");
            if (commonNumbers.contains(number)) continue;
            String id = next.getString("fid");
            String modelId = next.getString("fmodelid");
            id2Number.put(id, Pair.onePair((Object)modelId, (Object)number));
            Map number2names = collector.column((Object)modelId);
            Map localeName = number2names.computeIfAbsent(number, key -> new HashMap());
            localeName.put(this.lang, defName);
        }
        Set<String> ids = id2Number.keySet();
        this.collectLocaleNameByIds(ids, (arg_0, arg_1) -> InvRelationTypeCombo2BaseDataUpgradeService.lambda$changeTypeDesc$19(id2Number, (Table)collector, arg_0, arg_1));
        return collector;
    }

    private void collectLocaleNameByIds(Set<String> ids, BiConsumer<String, Pair<String, String>> collectNameFunc) {
        if (ids.isEmpty()) {
            return;
        }
        String changeTypeL = "select fid,fname,flocaleid from t_bcm_invchangetype_l where fid in (" + String.join((CharSequence)",", ids) + ")";
        DataSet changeTypeLRs = DB.queryDataSet((String)"select_invchangetypeL_000", (DBRoute)DBRoute.of((String)"bcm"), (String)changeTypeL);
        while (changeTypeLRs.hasNext()) {
            Row next = changeTypeLRs.next();
            String localeId = next.getString("flocaleid");
            String name = next.getString("fname");
            String id = next.getString("fid");
            collectNameFunc.accept(id, (Pair<String, String>)Pair.onePair((Object)localeId, (Object)name));
        }
    }

    private Set<Long> getUpdateModel(Set<Long> allModel) {
        if (allModel.isEmpty()) {
            return allModel;
        }
        String updatedSql = "select fmodelid from t_bcm_invrelatype where fnumber ='" + InvRelaTypeEnum.DirectRelaType.getType() + "' ";
        DataSet updatedRs = DB.queryDataSet((String)"select_invrelatype_000", (DBRoute)DBRoute.of((String)"bcm"), (String)updatedSql);
        while (updatedRs.hasNext()) {
            Row next = updatedRs.next();
            Long modelId = next.getLong("fmodelid");
            allModel.remove(modelId);
        }
        return allModel;
    }

    private Set<Long> getAllModel() {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(16);
        String sql = "select fid from T_BCM_MODEL where fid != 0 ";
        DataSet rows = DB.queryDataSet((String)"queryAllModelId", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (rows.hasNext()) {
            Row next = rows.next();
            Long id = next.getLong("fid");
            ids.add(id);
        }
        return ids;
    }

    private static /* synthetic */ void lambda$changeTypeDesc$19(Map id2Number, Table collector, String id, Pair localeIdNamePair) {
        Pair pair = (Pair)id2Number.get(id);
        String modelId = (String)pair.p1;
        String number = (String)pair.p2;
        Map localeName = collector.column((Object)modelId).computeIfAbsent(number, key -> new HashMap(16));
        localeName.put(localeIdNamePair.p1, localeIdNamePair.p2);
    }

    private static /* synthetic */ void lambda$staticRelationDesc$15(Table collector, String modelId, String k, Pair v) {
        if (collector.get((Object)modelId, (Object)k) == null) {
            collector.put((Object)modelId, (Object)k, (Object)Pair.onePair((Object)v.p1, (Object)Maps.newHashMap((Map)((Map)v.p2))));
        }
    }
}

