/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.fi.bcm.business.invest.sheet.GlobalIdDistributer;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.util.PlatUtil;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.computing.util.BatchProcessHelper;

public class InvRltEffectTempUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        this.doUpgrade(this.queryAllModel());
        return this.success();
    }

    public void doUpgrade(Collection<Long> modelIds) {
        Iterator<Long> iterator = modelIds.iterator();
        LinkedList<String> batch = new LinkedList<String>();
        while (iterator.hasNext()) {
            Long modelId = iterator.next();
            batch.add(String.valueOf(modelId));
            this.upgradeIfTrue(batch.size() == 10, batch);
        }
        this.upgradeIfTrue(!batch.isEmpty(), batch);
    }

    private void upgradeIfTrue(boolean isUpgrade, List<String> modelIds) {
        if (isUpgrade) {
            Pair<Map<String, Long>, Multimap<Long, String>> pair = this.queryRltByModel(modelIds);
            if (((Multimap)pair.p2).isEmpty()) {
                return;
            }
            List<String> needUpdateRltIds = this.findNeedUpgrade(pair);
            this.old2NewTable(needUpdateRltIds);
            modelIds.clear();
        }
    }

    private List<String> findNeedUpgrade(Pair<Map<String, Long>, Multimap<Long, String>> pair) {
        Map id2Model = (Map)pair.p1;
        Multimap model2Ids = (Multimap)pair.p2;
        BatchProcessHelper.batchConsume(new ArrayList(id2Model.keySet()), (int)5000, group -> {
            String sql = "select fid from t_bcm_invrlteffecttemp where fid in (%1$s)";
            String finalSql = String.format(sql, String.join((CharSequence)",", group));
            DataSet rs = DB.queryDataSet((String)"select_Rlt_temp_001", (DBRoute)DBRoute.of((String)"bcm"), (String)finalSql);
            while (rs.hasNext()) {
                Row row = rs.next();
                String id = row.getString("fid");
                Long modelId = id2Model.getOrDefault(id, 0L);
                model2Ids.removeAll((Object)modelId);
            }
        });
        LinkedList<String> rltIds = new LinkedList<String>();
        model2Ids.forEach((k, v) -> rltIds.add((String)v));
        return rltIds;
    }

    private void old2NewTable(Collection<String> needUpdateRltIds) {
        if (needUpdateRltIds.isEmpty()) {
            return;
        }
        LinkedList modelIds = new LinkedList();
        GlobalIdDistributer idBuilder = new GlobalIdDistributer();
        BatchProcessHelper.batchConsume(new ArrayList<String>(needUpdateRltIds), (int)5000, group -> {
            String querySql = "select fid,fpkid,fbasedataid from t_bcm_invrelation_temp where fid in (%1$s)";
            String finalSql = String.format(querySql, String.join((CharSequence)",", group));
            DataSet rs = DB.queryDataSet((String)"select_Rlt_temp_000", (DBRoute)DBRoute.of((String)"bcm"), (String)finalSql);
            while (rs.hasNext()) {
                Row next = rs.next();
                Object[] row = new Object[]{next.getLong("fid"), idBuilder.getLongId(), next.getLong("fbasedataid")};
                modelIds.add(row);
            }
        });
        BatchProcessHelper.batchConsume(new ArrayList<String>(needUpdateRltIds), (int)5000, group -> {
            String querySqlDy = "select fid,fpkid,fbasedataid from t_bcm_dynstockratiotemp where fid in (%1$s)";
            String finalSqlDy = String.format(querySqlDy, String.join((CharSequence)",", group));
            DataSet rsDy = DB.queryDataSet((String)"select_RltDy_temp_000", (DBRoute)DBRoute.of((String)"bcm"), (String)finalSqlDy);
            while (rsDy.hasNext()) {
                Row next = rsDy.next();
                Object[] row = new Object[]{next.getLong("fid"), idBuilder.getLongId(), next.getLong("fbasedataid")};
                modelIds.add(row);
            }
        });
        String insertSql = "INSERT INTO t_bcm_invrlteffecttemp (fid, fentryid, fseq, ftemtype, ftempid, fisexcept, fgroupid) VALUES(?, ?, 0, 'bcm_invelimtemplatebase', ?, '0', 0)";
        if (!modelIds.isEmpty()) {
            PlatUtil.executeWithTXNew(tx -> DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, (List)modelIds));
        }
    }

    private List<Long> queryAllModel() {
        String sql = "select fid from t_bcm_model";
        DataSet rs = DB.queryDataSet((String)"select_model_000", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        LinkedList<Long> modelIds = new LinkedList<Long>();
        while (rs.hasNext()) {
            Row next = rs.next();
            Long id = next.getLong("fid");
            modelIds.add(id);
        }
        return modelIds;
    }

    private Pair<Map<String, Long>, Multimap<Long, String>> queryRltByModel(Collection<String> modelStrIds) {
        String sql = "select fid,fmodelid from t_bcm_invrelation where fmodelid in (%1$s)";
        String finalSql = String.format(sql, String.join((CharSequence)",", modelStrIds));
        HashMap<String, Long> id2Model = new HashMap<String, Long>(16);
        HashMultimap model2Ids = HashMultimap.create();
        try (DataSet ds = DB.queryDataSet((String)"select_InvRlt_000", (DBRoute)DBRoute.of((String)"bcm"), (String)finalSql);){
            while (ds.hasNext()) {
                Row next = ds.next();
                Long modelId = next.getLong("fmodelid");
                String id = next.getString("fid");
                id2Model.put(id, modelId);
                model2Ids.put((Object)modelId, (Object)id);
            }
        }
        String sqlDy = "select fid,fmodelid from t_bcm_dynamicstockratio where fmodelid in (%1$s)";
        String finalSqlDy = String.format(sqlDy, String.join((CharSequence)",", modelStrIds));
        try (DataSet rsDy = DB.queryDataSet((String)"select_InvRltDy_000", (DBRoute)DBRoute.of((String)"bcm"), (String)finalSqlDy);){
            while (rsDy.hasNext()) {
                Row next = rsDy.next();
                Long modelId = next.getLong("fmodelid");
                String id = next.getString("fid");
                id2Model.put(id, modelId);
                model2Ids.put((Object)modelId, (Object)id);
            }
        }
        return Pair.onePair(id2Model, (Object)model2Ids);
    }
}

