/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.business.util.LanguageUtil;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class InvShareCaseUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"InvShareCaseUpgradeService");){
            List<Long> modelIds = this.getAllModel();
            if (modelIds.isEmpty()) {
                Map<String, Object> map = this.success();
                return map;
            }
            try {
                Map<Long, Long> setting = this.queryModelHadSetting();
                modelIds.removeAll(setting.keySet());
                HashMap<Long, Long> model2Setting = new HashMap<Long, Long>(modelIds.size());
                long[] pks = GlobalIdUtil.genGlobalLongIds((int)modelIds.size());
                for (int i = 0; i < modelIds.size(); ++i) {
                    model2Setting.put(modelIds.get(i), pks[i]);
                }
                this.upgradeStockData(model2Setting);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvShareCaseUpgradeService error", (Throwable)e);
                Map<String, Object> map = this.fail(e);
                return map;
            }
        }
        return this.success();
    }

    private void upgradeStockData(Map<Long, Long> model2Setting) {
        Map<Long, Long> setting = this.queryModelHadSetting();
        this.upgradeStockData(setting, model2Setting);
    }

    public void upgradeStockData(Map<Long, Long> setting, Map<Long, Long> settingNew) {
        this.initDefaultShareCase(settingNew);
        settingNew.putAll(setting);
        this.updateStockData(settingNew, "t_bcm_invsharerela");
        this.updateStockData(settingNew, "t_bcm_invsharerela_rpt");
        this.updateStockData(settingNew, "t_bcm_invstructurereport");
    }

    private void updateStockData(Map<Long, Long> model2Setting, String table) {
        String updateSql = "update " + table + " set fsharecaseid = ? where fmodelid = ? and (fsharecaseid is null or fsharecaseid = 0)";
        Set<Long> modelIds = model2Setting.keySet();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(modelIds.size());
        for (Map.Entry<Long, Long> model : model2Setting.entrySet()) {
            Object[] params = new Object[]{model.getValue(), model.getKey()};
            paramList.add(params);
        }
        if (!paramList.isEmpty()) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)updateSql, paramList);
        }
    }

    public void initDefaultShareCase(Map<Long, Long> model2Setting) {
        ArrayList<Object[]> items = new ArrayList<Object[]>(16);
        ArrayList itemsL = new ArrayList(16);
        Set<Long> modelIds = model2Setting.keySet();
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = TimeServiceHelper.now();
        String defaultName = ResManager.loadKDString((String)"\u9ed8\u8ba4\u65b9\u6848", (String)"InvShareCaseUpgradeService_0", (String)"fi-bcm-business", (Object[])new Object[0]);
        String defaultRemark = ResManager.loadKDString((String)"\u7cfb\u7edf\u9ed8\u8ba4\u914d\u7f6e", (String)"InvShareCaseUpgradeService_1", (String)"fi-bcm-business", (Object[])new Object[0]);
        Map<Lang, String> name = LanguageUtil.getTranslate(defaultName, "InvShareCaseUpgradeService_0", "fi-bcm-business");
        Map<Lang, String> remark = LanguageUtil.getTranslate(defaultRemark, "InvShareCaseUpgradeService_1", "fi-bcm-business");
        String[] pksL = GlobalIdUtil.genStringIds((int)(modelIds.size() * name.size()));
        AtomicInteger row = new AtomicInteger(0);
        for (Map.Entry<Long, Long> model : model2Setting.entrySet()) {
            Object[] params = new Object[]{model.getValue(), model.getKey(), "defaultInvest", name.get(Lang.get()), "0", remark.get(Lang.get()), currUserId, now, currUserId, now};
            items.add(params);
            name.forEach((lang, des) -> {
                Object[] paramsL = new Object[]{pksL[row.getAndIncrement()], model.getValue(), lang, des, remark.get(lang)};
                itemsL.add(paramsL);
            });
        }
        if (!items.isEmpty()) {
            String insertSql = "INSERT INTO t_bcm_invsharecase (fid, fmodelid, fnumber, fname,  fscope, fremark, fcreatorid, fcreatetime, fmodifierid, fmodifytime) VALUES(?,?,?,?,?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, items);
        }
        if (!itemsL.isEmpty()) {
            String insertSql2 = "INSERT INTO t_bcm_invsharecase_l (fpkid, fid, flocaleid, fname, fremark) VALUES(?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql2, itemsL);
        }
    }

    private Map<Long, Long> queryModelHadSetting() {
        String querySetting = "select fid,fmodelid from t_bcm_invsharecase where fnumber = 'defaultInvest'";
        DataSet setting = DB.queryDataSet((String)"select_querySetting_000", (DBRoute)DBRoute.of((String)"bcm"), (String)querySetting);
        HashMap<Long, Long> model2Setting = new HashMap<Long, Long>(16);
        while (setting.hasNext()) {
            Row next = setting.next();
            Long modelId = next.getLong("fmodelid");
            Long id = next.getLong("fid");
            model2Setting.put(modelId, id);
        }
        return model2Setting;
    }

    private List<Long> getAllModel() {
        QFilter qf = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection models = QueryServiceHelper.query((String)"bcm_model", (String)"id", (QFilter[])qf.toArray());
        List<Long> ids = models.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
        models.clear();
        return ids;
    }
}

