/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;

public class InvShareRelaUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try {
            Set<Long> modelids = this.getAllModel();
            int lmt = 100;
            List<Set<Long>> mdidsgrp = this.getGroupList(modelids, lmt);
            for (Set<Long> ids : mdidsgrp) {
                DynamicObject[] datas = this.getInvShareRela(ids);
                if (datas.length == 0) continue;
                Map<String, List<DynamicObject>> invGrpMap = Arrays.stream(datas).collect(Collectors.groupingBy(t -> t.getString("model.id") + t.getString("investeecompany.id")));
                for (List<DynamicObject> lst : invGrpMap.values()) {
                    lst.sort(Comparator.comparing(t -> t.getDate("investdate")));
                    BigDecimal changescale = lst.get(lst.size() - 1).getBigDecimal("changescale");
                    if (BigDecimal.ZERO.compareTo(changescale) < 0) continue;
                    this.calculateChangeScale(lst);
                }
                SaveServiceHelper.save((DynamicObject[])datas);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.success();
    }

    private void calculateChangeScale(List<DynamicObject> data) {
        Map<String, List<DynamicObject>> date2dysMap = data.stream().collect(Collectors.groupingBy(dyn -> dyn.getString("shareholder.id")));
        BigDecimal nowScale = null;
        BigDecimal curSharescale = null;
        for (List<DynamicObject> dys : date2dysMap.values()) {
            nowScale = BigDecimal.ZERO;
            for (int i = 0; i < dys.size(); ++i) {
                curSharescale = dys.get(i).getBigDecimal("sharescale");
                dys.get(i).set("changescale", (Object)curSharescale.subtract(nowScale));
                nowScale = curSharescale;
            }
        }
    }

    private DynamicObject[] getInvShareRela(Set<Long> modelids) {
        QFilter qf = new QFilter("model", "in", modelids);
        String selector = "id,model,shareholder,investeecompany,sharescale,investdate,changescale";
        return BusinessDataServiceHelper.load((String)"bcm_invsharerela", (String)selector, (QFilter[])qf.toArray());
    }

    private Set<Long> getAllModel() {
        QFilter qf = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection models = QueryServiceHelper.query((String)"bcm_model", (String)"id", (QFilter[])qf.toArray());
        Set<Long> ids = models.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        models.clear();
        return ids;
    }

    private List<Set<Long>> getGroupList(Set<Long> ids, int lmt) {
        int sz = ids.size();
        int num = sz / lmt;
        num = sz % lmt == 0 ? num : num + 1;
        List<Set<Long>> splitList = ((Stream)Stream.iterate(0, n -> n + 1).limit(num).parallel()).map(a -> ((Stream)ids.stream().skip(a * lmt).limit(lmt).parallel()).collect(Collectors.toSet())).collect(Collectors.toList());
        return splitList;
    }
}

