/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import org.apache.commons.lang.StringUtils;

public class InvSheetTemplateDefDimUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"InvSheetTemplateDefDimUpgradeService");){
            try {
                this.upgradeByModel(0L);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvSheetTemplateDefDimUpgradeService error", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("error", e.getMessage()), new Object[0]);
            }
        }
        return super.upgrade();
    }

    public void upgradeByModel(Long modelId) {
        Map<String, String> userDefineFieldMapping = this.getUserDefineFieldMapping(modelId);
        Map<String, Long> userDefineDefaulMemberMapping = this.getUserDefineDefaulMember(modelId, userDefineFieldMapping);
        this.updateTempleLossValues(modelId, userDefineFieldMapping, userDefineDefaulMemberMapping);
    }

    private void updateTempleLossValues(Long modelId, Map<String, String> userDefineFieldMapping, Map<String, Long> userDefineDefaulMemberMapping) {
        String updateSql1 = "update t_bcm_invsheetrow set";
        String updateSql2 = " and fid in (\n    select fid\n    from t_bcm_invsheetentry\n    where ftemplateid in (select paper.fid\n                          from t_bcm_papertemplate paper\n                                   join t_bcm_papertplcatalog catalog on paper.ftemplatecatalog = catalog.fid\n                          where paper.fmodelid = " + modelId + " and catalog.flongnumber like 'root.InvElim%'));";
        StringBuilder updateSql = new StringBuilder();
        userDefineFieldMapping.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            String index = key.substring(key.length() - 1);
            String setSql = " fuserdefine" + index + "=" + userDefineDefaulMemberMapping.get((String)entry.getValue() + "None");
            String whereSql = " where fuserdefine" + index + " = 0";
            updateSql.append(updateSql1);
            updateSql.append(setSql);
            updateSql.append(whereSql);
            updateSql.append(updateSql2);
            updateSql.append("\n");
        });
        if (!StringUtils.isBlank((String)updateSql.toString())) {
            DB.execute((DBRoute)BCMConstant.DBROUTE, (String)updateSql.toString());
        }
    }

    private Map<String, String> getUserDefineFieldMapping(Long modelId) {
        String dimDefaultSql = "select fid,fnumber,ffieldmapped from t_bcm_dimension where fmodelid=? and fissysdimension='0';";
        DataSet rows = DB.queryDataSet((String)"DefDimUpgrade", (DBRoute)BCMConstant.DBROUTE, (String)dimDefaultSql, (Object[])new Object[]{modelId});
        HashMap<String, String> userDefineFieldMapped = new HashMap<String, String>(16);
        while (rows != null && rows.hasNext()) {
            Row row = rows.next();
            userDefineFieldMapped.put(row.getString("ffieldmapped"), row.getString("fnumber"));
        }
        return userDefineFieldMapped;
    }

    private Map<String, Long> getUserDefineDefaulMember(Long modelId, Map<String, String> userDefineFieldMapping) {
        HashMap<String, Long> userDefineFieldMapped = new HashMap<String, Long>(16);
        StringJoiner stringJoiner = new StringJoiner(",");
        userDefineFieldMapping.entrySet().forEach(entry -> stringJoiner.add("'" + (String)entry.getValue() + "None'"));
        if (!StringUtils.isBlank((String)stringJoiner.toString())) {
            String dimDefaultSql = "select fid,fnumber from t_bcm_structofdefined where fmodelid=? and fnumber in (" + stringJoiner.toString() + ");";
            DataSet rows = DB.queryDataSet((String)"DefDimUpgrade", (DBRoute)BCMConstant.DBROUTE, (String)dimDefaultSql, (Object[])new Object[]{modelId});
            while (rows != null && rows.hasNext()) {
                Row row = rows.next();
                userDefineFieldMapped.put(row.getString("fnumber"), row.getLong("fid"));
            }
        }
        return userDefineFieldMapped;
    }
}

