/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.common.enums.ExtendDimGroupType;
import kd.fi.bcm.common.enums.TemplateCatalogEnum;
import kd.fi.bcm.common.util.GlobalIdUtil;
import kd.fi.bcm.common.util.UserUtils;

public class InvSheetTemplateUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"InvSheetTemplateUpgradeService");){
            try {
                List<Long> modelHadUpgrade = this.getModelHadUpgrade();
                Map<Long, ExtendMember> idMap = this.upgradePaperThenGetIdMap(modelHadUpgrade);
                this.initExtModel(idMap);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvSheetTemplateUpgradeService error", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("error", e.getMessage()), new Object[0]);
            }
        }
        return super.upgrade();
    }

    private Map<Long, ExtendMember> upgradePaperThenGetIdMap(List<Long> modelHadUpgrade) {
        HashMap<Long, Long> modelIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, ExtendMember> idMap = new HashMap<Long, ExtendMember>(16);
        String sql2 = "select fid,fnumber,fname,fmodelid from t_bcm_structofextend where flevel = 2 and fgrouptype = '" + ExtendDimGroupType.EQUITY.getIndex() + "'";
        DataSet dataSet = DB.queryDataSet((String)"select_getDefaultData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)sql2);
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            long modelId = row.getLong("fmodelid");
            if (modelHadUpgrade.contains(modelId)) continue;
            long id = row.getLong("fid");
            String number = row.getString("fnumber");
            String name = row.getString("fname");
            if ("INVEST".equals(number)) {
                modelIdMap.put(modelId, id);
            }
            ExtendMember extendMember = new ExtendMember(0L, modelId, number, name);
            idMap.put(id, extendMember);
        }
        this.fillExtModelId(idMap);
        this.updatePaperTemplate(modelIdMap, idMap);
        return idMap;
    }

    private void updatePaperTemplate(Map<Long, Long> modelIdMap, Map<Long, ExtendMember> idMap) {
        String longNumber = TemplateCatalogEnum.INVELIM.getLongnumber();
        String sql = "select tbp.fid,tbp.fextdimid,tbp.fmodelid from t_bcm_papertemplate tbp ,t_bcm_papertplcatalog tbp2 where tbp.ftemplatecatalog = tbp2.fid and (tbp2.flongnumber = '" + longNumber + "' or tbp2.flongnumber like '" + longNumber + ".%')";
        String updateSql = "UPDATE t_bcm_papertemplate SET fextdimid=? WHERE fid=?";
        DataSet dataSet = DB.queryDataSet((String)"select_getDefaultData_001", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        while (dataSet != null && dataSet.hasNext()) {
            ExtendMember extendMember;
            Row row = dataSet.next();
            Long id = row.getLong("fid");
            Long extDimId = row.getLong("fextdimid");
            Long modelId = row.getLong("fmodelid");
            if (extDimId == 0L) {
                extDimId = modelIdMap.get(modelId);
            }
            if (Objects.isNull(extendMember = idMap.get(extDimId))) continue;
            paramsList.add(new Object[]{extendMember.getId(), id});
            this.saveBatch(paramsList, updateSql);
        }
        this.saveAll(paramsList, updateSql);
    }

    private void fillExtModelId(Map<Long, ExtendMember> idMap) {
        long[] extModelIds = GlobalIdUtil.genGlobalLongIds((int)idMap.size());
        int i = 0;
        for (ExtendMember extendMember : idMap.values()) {
            extendMember.setId(extModelIds[i++]);
        }
    }

    private List<Long> getModelHadUpgrade() {
        ArrayList<Long> modelIds = new ArrayList<Long>(16);
        String sql = "select tbs.fmodelid fmodelid from t_bcm_structofextend tbs ,t_bcm_extendsmodel tbe where tbs.fid = tbe.fextendsgroup and tbs.fgrouptype = '" + ExtendDimGroupType.EQUITY.getIndex() + "'";
        DataSet dataSet = DB.queryDataSet((String)"select_getDefaultData_002", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (dataSet != null && dataSet.hasNext()) {
            Row next = dataSet.next();
            modelIds.add(next.getLong("fmodelid"));
        }
        return modelIds;
    }

    private void initExtModel(Map<Long, ExtendMember> idMap) {
        if (idMap.isEmpty()) {
            return;
        }
        Map<Long, List<Pair<String, String>>> group2Name = this.getGroup2Name(idMap.keySet());
        Map<Long, List<Long>> group2ExtendMemberIds = this.getGroup2ExtendMemberIds(idMap.keySet());
        Date date = new Date();
        ArrayList<Object[]> modelParamList = new ArrayList<Object[]>(idMap.size());
        String modelSql = "INSERT INTO t_bcm_extendsmodel (fid, fmodelid, fnumber, fname, fextendsgroup, fdescription, fstatus, fenable, fcreatorid, fmodifierid, fcreatetime, fmodifytime) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> modelParamLList = new ArrayList<Object[]>(16);
        String modelLSql = "INSERT INTO t_bcm_extendsmodel_l (fpkid, fid, flocaleid, fname, fdescription) VALUES(?,?,?,?,?)";
        ArrayList<Object[]> fieldParamList = new ArrayList<Object[]>(16);
        String fieldSql = "INSERT INTO t_bcm_extmodelfield (fid, fextfield, fseq, fisnecessary, funiquecheck, fextmodelid) VALUES(?,?,?,?,?,?)";
        for (Map.Entry<Long, ExtendMember> extendEntry : idMap.entrySet()) {
            Long extendsGroupId = extendEntry.getKey();
            ExtendMember extendMember = extendEntry.getValue();
            Long id = extendMember.getId();
            Long modelId = extendMember.getModel();
            Object[] modelParam = new Object[]{id, modelId, extendMember.getNumber(), extendMember.getName(), extendsGroupId, "", "C", "1", UserUtils.getUserId(), UserUtils.getUserId(), date, date};
            modelParamList.add(modelParam);
            List<Pair<String, String>> list = group2Name.get(extendsGroupId);
            String[] stringIds = GlobalIdUtil.genStringIds((int)list.size());
            for (int i = 0; i < list.size(); ++i) {
                Pair<String, String> pair = list.get(i);
                Object[] objects = new Object[]{stringIds[i], id, pair.p1, pair.p2, ""};
                modelParamLList.add(objects);
                this.saveBatch(modelParamLList, modelLSql);
            }
            List extendMemberIds = group2ExtendMemberIds.getOrDefault(extendsGroupId, new ArrayList());
            long[] extModelIds = GlobalIdUtil.genGlobalLongIds((int)extendMemberIds.size());
            for (int i = 0; i < extendMemberIds.size(); ++i) {
                long extendMemberId = (Long)extendMemberIds.get(i);
                Object[] fieldParam = new Object[]{extModelIds[i], extendMemberId, i, true, false, id};
                fieldParamList.add(fieldParam);
                this.saveBatch(fieldParamList, fieldSql);
            }
            this.saveBatch(modelParamList, modelSql);
        }
        this.saveAll(fieldParamList, fieldSql);
        this.saveAll(modelParamLList, modelLSql);
        this.saveAll(modelParamList, modelSql);
    }

    private Map<Long, List<Long>> getGroup2ExtendMemberIds(Set<Long> groupIds) {
        String sql = "select fid,fparentid from t_bcm_structofextend where flevel =3 and fparentid in (%s) order by fseq ";
        HashMap<Long, List<Long>> group2ExtendMemberIds = new HashMap<Long, List<Long>>(16);
        StringJoiner joiner = new StringJoiner(",");
        for (Long groupId : groupIds) {
            joiner.add(groupId.toString());
        }
        String querySql = String.format(sql, joiner);
        DataSet dataSet = DB.queryDataSet((String)"select_getDefaultData_003", (DBRoute)DBRoute.of((String)"bcm"), (String)querySql);
        while (dataSet != null && dataSet.hasNext()) {
            Row next = dataSet.next();
            Long id = next.getLong("fid");
            Long parentId = next.getLong("fparentid");
            List idList = group2ExtendMemberIds.computeIfAbsent(parentId, key -> new ArrayList());
            idList.add(id);
        }
        return group2ExtendMemberIds;
    }

    private Map<Long, List<Pair<String, String>>> getGroup2Name(Set<Long> groupIds) {
        String sql = "select fid,flocaleid ,fname from t_bcm_structofextend_l where fid in (%s)";
        HashMap<Long, List<Pair<String, String>>> group2Name = new HashMap<Long, List<Pair<String, String>>>(16);
        StringJoiner joiner = new StringJoiner(",");
        for (Long groupId : groupIds) {
            joiner.add(groupId.toString());
        }
        String querySql = String.format(sql, joiner);
        DataSet dataSet = DB.queryDataSet((String)"select_getDefaultData_004", (DBRoute)DBRoute.of((String)"bcm"), (String)querySql);
        while (dataSet != null && dataSet.hasNext()) {
            Row next = dataSet.next();
            Long id = next.getLong("fid");
            String localeId = next.getString("flocaleid");
            String name = next.getString("fname");
            List pairList = group2Name.computeIfAbsent(id, key -> new ArrayList());
            pairList.add(Pair.onePair((Object)localeId, (Object)name));
        }
        return group2Name;
    }

    private void saveBatch(List<Object[]> fieldParamList, String fieldSql) {
        if (fieldParamList.size() > 2000) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)fieldSql, fieldParamList);
            fieldParamList.clear();
        }
    }

    private void saveAll(List<Object[]> paramList, String sql) {
        if (paramList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, paramList);
            paramList.clear();
        }
    }

    private static class ExtendMember {
        private long id;
        private long model;
        private Object number;
        private Object name;

        public ExtendMember(long id, long model, Object number, Object name) {
            this.id = id;
            this.model = model;
            this.number = number;
            this.name = name;
        }

        public long getId() {
            return this.id;
        }

        public long getModel() {
            return this.model;
        }

        public Object getNumber() {
            return this.number;
        }

        public Object getName() {
            return this.name;
        }

        public void setId(long id) {
            this.id = id;
        }
    }
}

