/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.util.StringUtils;
import kd.fi.bcm.business.allinone.service.thread.ThreadPoolService;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.Pair;
import kd.fi.bcm.spread.common.util.DateTimeUtils;

public class InvStructureUpgradeService
extends BcmUpgradeService {
    private UpgradeDataCache upgradeDataCache = new UpgradeDataCache();

    @Override
    public Map<String, Object> upgrade() {
        try {
            Set<Long> allModel = this.getAllModel();
            this.upgradeDataCache.setDefSpYChangesType(this.getDefSpYChangesType());
            this.upgradeDataCache.setStartChanges(Lists.newArrayList((Object[])new String[]{"BD001", "1"}));
            this.upgradeDataCache.setBetweenChanges(Lists.newArrayList((Object[])new String[]{"BD000", "BD009", "7", "10"}));
            ArrayList<Long> batchBig = new ArrayList<Long>(16);
            ArrayList<Long> batch = new ArrayList<Long>(16);
            for (Long modeId : allModel) {
                batchBig.add(modeId);
                if (batchBig.size() != 1000) continue;
                this.bigBatch(batchBig, batch);
            }
            if (!batchBig.isEmpty()) {
                this.bigBatch(batchBig, batch);
            }
            if (!batch.isEmpty()) {
                this.smallBatch(batch);
            }
            this.doDelete();
            return this.success();
        }
        catch (Exception e) {
            return this.fail(e);
        }
    }

    private void doDelete() {
        Set<Long> mergeStructInfoId = this.upgradeDataCache.getMergeStructInfoId();
        if (mergeStructInfoId.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(mergeStructInfoId.size());
        String sql = "delete from t_bcm_mergestructinfo where fid = ? ";
        for (Long id : mergeStructInfoId) {
            Object[] param = new Object[]{id};
            params.add(param);
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)sql, params);
    }

    private void smallBatch(List<Long> batch) {
        CountDownLatch latch = new CountDownLatch(1);
        ThreadPoolService.runInSyncThread(() -> {
            this.upgradeDataCache.setModel2MergeStructInfo(this.getMergeStructInfosB(batch));
            latch.countDown();
        });
        this.upgradeDataCache.setModel2Org(this.getAllOrgB(batch));
        this.await(latch);
        CountDownLatch latchOut = this.upgradeDataCache.getLatch();
        if (Objects.nonNull(latchOut)) {
            this.await(latchOut);
        }
        for (Long modelId : batch) {
            this.pickInfoId(modelId);
        }
        batch.clear();
    }

    private void await(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            this.log.error((Throwable)e);
        }
    }

    private void pickInfoId(Long modelId) {
        List orgList = this.upgradeDataCache.getModel2Org().getOrDefault(modelId, Collections.emptyList());
        Set spYChangesTypes = this.upgradeDataCache.getModel2SpYChangesType().getOrDefault(modelId, Collections.emptySet());
        HashMap<String, List<Object>> oui2Overtime = new HashMap<String, List<Object>>(orgList.size());
        Calendar calendar = Calendar.getInstance();
        for (Org org : orgList) {
            String pNumber = org.getParentNumber();
            String number = org.getNumber();
            if ("Entity".equals(number)) continue;
            String key = this.getOUI(pNumber, number);
            List<OrgBizChange> bizChanges = org.getOrgBizChanges();
            if (bizChanges == null) {
                return;
            }
            ArrayList<Pair> overTime = new ArrayList<Pair>(16);
            for (OrgBizChange bizChange : bizChanges) {
                String changeType = bizChange.getChangeType();
                Date effDate = bizChange.getEffDate();
                Date expDate = bizChange.getExpDate();
                if (effDate == null) {
                    return;
                }
                if (this.upgradeDataCache.getStartChanges().contains(changeType)) {
                    calendar.clear();
                    calendar.setTime(effDate);
                    calendar.add(2, -1);
                    overTime.add(Pair.onePair(null, (Object)calendar.getTime()));
                    continue;
                }
                if (this.upgradeDataCache.getBetweenChanges().contains(changeType)) {
                    overTime.add(Pair.onePair((Object)effDate, (Object)expDate));
                    continue;
                }
                if (!this.upgradeDataCache.getDefSpYChangesType().contains(changeType) && !spYChangesTypes.contains(changeType)) continue;
                calendar.clear();
                calendar.setTime(effDate);
                calendar.set(2, 11);
                overTime.add(Pair.onePair((Object)calendar.getTime(), (Object)expDate));
            }
            List<OrgNameChange> orgNameChanges = org.getOrgNameChanges();
            if (orgNameChanges == null) {
                return;
            }
            if (orgNameChanges.size() == 1) {
                OrgNameChange orgNameChange = orgNameChanges.get(0);
                Date effDate = orgNameChange.getEffDate();
                calendar.clear();
                calendar.setTime(effDate);
                calendar.add(2, -1);
                overTime.add(Pair.onePair(null, (Object)calendar.getTime()));
            }
            oui2Overtime.put(key, overTime);
        }
        Set<Long> rmIds = this.upgradeDataCache.getMergeStructInfoId();
        Map yId2Number = this.upgradeDataCache.getModel2YearIdMap().getOrDefault(modelId, Collections.emptyMap());
        Map perId2MD = this.upgradeDataCache.getModel2PerIdDateMap().getOrDefault(modelId, Collections.emptyMap());
        List mergeStructInfos = this.upgradeDataCache.getModel2MergeStructInfo().getOrDefault(modelId, Collections.emptyList());
        for (MergeStructInfo mergeStructInfo : mergeStructInfos) {
            String firstDay;
            Date firstDate;
            long id = mergeStructInfo.getId();
            String orgNumber = mergeStructInfo.getOrgNumber();
            String orgPNumber = mergeStructInfo.getOrgParentNumber();
            long year = mergeStructInfo.getYearId();
            long period = mergeStructInfo.getPeriodId();
            String yearString = (String)yId2Number.get(year);
            String dateString = (String)perId2MD.get(period);
            if (yearString == null || dateString == null || Objects.isNull(firstDate = this.parseDate(firstDay = yearString.concat("-").concat(dateString)))) continue;
            String key = this.getOUI(orgPNumber, orgNumber);
            List pairs = oui2Overtime.getOrDefault(key, Collections.emptyList());
            for (Pair pair : pairs) {
                if (pair.p1 == null && pair.p2 != null && !firstDate.after((Date)pair.p2)) {
                    rmIds.add(id);
                }
                if (pair.p2 == null && pair.p1 != null && firstDate.after((Date)pair.p1)) {
                    rmIds.add(id);
                }
                if (pair.p1 == null || pair.p2 == null || !firstDate.after((Date)pair.p1) || firstDate.after((Date)pair.p2)) continue;
                rmIds.add(id);
            }
        }
    }

    private void bigBatch(List<Long> batchBig, List<Long> batch) {
        List modelIds = batchBig.stream().map(String::valueOf).collect(Collectors.toList());
        CountDownLatch latch = new CountDownLatch(3);
        this.upgradeDataCache.setLatch(latch);
        ThreadPoolService.runInSyncThread(() -> {
            this.upgradeDataCache.setModel2SpYChangesType(this.getSpYChangesTypeB(modelIds));
            latch.countDown();
        });
        ThreadPoolService.runInSyncThread(() -> {
            this.upgradeDataCache.setModel2YearIdMap(this.getYearIdMapB(modelIds));
            latch.countDown();
        });
        ThreadPoolService.runInSyncThread(() -> {
            this.upgradeDataCache.setModel2PerIdDateMap(this.getPerIdMapB(modelIds));
            latch.countDown();
        });
        for (Long modelId : batchBig) {
            batch.add(modelId);
            if (batch.size() != 10) continue;
            this.smallBatch(batch);
        }
        batchBig.clear();
    }

    private Date parseDate(String firstDay) {
        Date firstDate = null;
        try {
            firstDate = DateTimeUtils.parseDate((String)firstDay);
        }
        catch (ParseException e) {
            this.log.error((Throwable)e);
        }
        return firstDate;
    }

    private String getOUI(String pNumber, String number) {
        return pNumber + "|" + number;
    }

    private Set<String> getDefSpYChangesType() {
        HashSet<String> changeType = new HashSet<String>(16);
        String sql = "select fnumber from t_bcm_invchangetype where fchange = '2' and fmodelid = 0 ";
        DataSet rows = DB.queryDataSet((String)"queryDefSpYChangesType", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (rows.hasNext()) {
            Row next = rows.next();
            changeType.add(next.getString("fnumber"));
        }
        changeType.add("4");
        changeType.add("6");
        return changeType;
    }

    private Map<Long, Set<String>> getSpYChangesTypeB(List<String> modelIds) {
        HashMap<Long, Set<String>> model2ChangeType = new HashMap<Long, Set<String>>(16);
        String sql = "select fnumber,fmodelid from t_bcm_invchangetype where fchange = '2' and fmodelid in (" + String.join((CharSequence)",", modelIds) + ")";
        DataSet rows = DB.queryDataSet((String)"querySpYChangesType", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (rows.hasNext()) {
            Row next = rows.next();
            String number = next.getString("fnumber");
            Long modelId = next.getLong("fmodelid");
            Set changeTypes = model2ChangeType.computeIfAbsent(modelId, k -> new HashSet(16));
            changeTypes.add(number);
        }
        return model2ChangeType;
    }

    private Map<Long, Map<Long, String>> getYearIdMapB(List<String> modelIds) {
        HashMap<Long, Map<Long, String>> model2Mapping = new HashMap<Long, Map<Long, String>>(500);
        String sql = "select fid,fmodelid,fnumber from T_BCM_StructOfFY where flongnumber like 'Year!AllYear!%' and fmodelid in (" + String.join((CharSequence)",", modelIds) + ")";
        DataSet rows = DB.queryDataSet((String)"queryYearId", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (rows.hasNext()) {
            Row next = rows.next();
            Long id = next.getLong("fid");
            Long modelId = next.getLong("fmodelid");
            String number = next.getString("fnumber");
            Map yId2Number = model2Mapping.computeIfAbsent(modelId, k -> new HashMap(16));
            if (StringUtils.isBlank((String)number)) continue;
            yId2Number.put(id, number.substring(2));
        }
        return model2Mapping;
    }

    private Map<Long, Map<Long, String>> getPerIdMapB(List<String> modelIds) {
        HashMap<Long, Map<Long, String>> model2Mapping = new HashMap<Long, Map<Long, String>>(500);
        String sql = "select fid,fmodelid,feffmonth,feffday from T_BCM_StructOfPeriod where fmodelid in (" + String.join((CharSequence)",", modelIds) + ")";
        DataSet rows = DB.queryDataSet((String)"queryPerIdMap", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (rows.hasNext()) {
            Row next = rows.next();
            long id = next.getLong("fid");
            long modelId = next.getLong("fmodelid");
            String month = next.getString("feffmonth");
            String day = next.getString("feffday");
            Map perId2MD = model2Mapping.computeIfAbsent(modelId, k -> new HashMap(16));
            month = month.length() == 1 ? "0" + month : month;
            day = day.length() == 1 ? "0" + day : day;
            String firstDay = month.concat("-").concat(day);
            perId2MD.put(id, firstDay);
        }
        return model2Mapping;
    }

    private Map<Long, List<MergeStructInfo>> getMergeStructInfosB(List<Long> modelIds) {
        HashMap<Long, List<MergeStructInfo>> model2MergeStructInfo = new HashMap<Long, List<MergeStructInfo>>(16);
        List params = modelIds.stream().map(String::valueOf).collect(Collectors.toList());
        String sql = "select fid,forgnumber,forgpnumber,fyearid,fperiodid,fmodelid from t_bcm_mergestructinfo where fmodelid in (" + String.join((CharSequence)",", params) + ")";
        DataSet rows = DB.queryDataSet((String)"queryOrg", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (rows.hasNext()) {
            Row next = rows.next();
            Long id = next.getLong("fid");
            String orgNumber = next.getString("forgnumber");
            String orgParentNumber = next.getString("forgpnumber");
            Long yearId = next.getLong("fyearid");
            Long periodId = next.getLong("fperiodid");
            MergeStructInfo mergeStructInfo = new MergeStructInfo(id, orgNumber, orgParentNumber, yearId, periodId);
            Long modelId = next.getLong("fmodelid");
            List mergeStructInfos = model2MergeStructInfo.computeIfAbsent(modelId, k -> new ArrayList(16));
            mergeStructInfos.add(mergeStructInfo);
        }
        return model2MergeStructInfo;
    }

    private Map<Long, List<Org>> getAllOrgB(List<Long> modelIds) {
        HashMap<String, Org> id2Org = new HashMap<String, Org>(16);
        HashMap<String, String> id2ParentId = new HashMap<String, String>(16);
        LinkedList<Org> orgList = new LinkedList<Org>();
        List params = modelIds.stream().map(String::valueOf).collect(Collectors.toList());
        String orgSql = "select fid,fparentid,fmodelid,fnumber from t_bcm_structofent where flongnumber not like 'Entity!RateEntity%' and fmemberid !=0 and fmodelid in (" + String.join((CharSequence)",", params) + ")";
        DataSet orgRows = DB.queryDataSet((String)"queryOrg", (DBRoute)DBRoute.of((String)"bcm"), (String)orgSql);
        while (orgRows.hasNext()) {
            Row next = orgRows.next();
            String number = next.getString("fnumber");
            String id2 = next.getString("fid");
            String parentId = next.getString("fparentid");
            Long modelId = next.getLong("fmodelid");
            id2ParentId.put(id2, parentId);
            Org org2 = new Org(id2, number, modelId);
            id2Org.put(id2, org2);
            orgList.add(org2);
        }
        orgList.forEach(org -> {
            String parentId = id2ParentId.getOrDefault(org.getId(), "");
            String parentNumber = id2Org.getOrDefault(parentId, new Org("", "", 0L)).getNumber();
            org.setParentNumber(parentNumber);
        });
        HashSet<String> orgId = new HashSet<String>(1000);
        id2Org.forEach((id, org) -> {
            orgId.add((String)id);
            this.fillOrgIfTrue(orgId.size() == 1000, orgId, id2Org);
        });
        this.fillOrgIfTrue(!orgId.isEmpty(), orgId, id2Org);
        return orgList.stream().collect(Collectors.groupingBy(Org::getModelId));
    }

    private void fillOrgIfTrue(boolean isFill, Set<String> orgId, Map<String, Org> id2Org) {
        if (!isFill) {
            return;
        }
        String bizSql = "select fid,feffdate,fexpdate,fchangetype from t_bcm_entitybizrecord where fid in (" + String.join((CharSequence)",", orgId) + ")";
        DataSet bizChangeRows = DB.queryDataSet((String)"queryOrgBizChange", (DBRoute)DBRoute.of((String)"bcm"), (String)bizSql);
        while (bizChangeRows.hasNext()) {
            Row next = bizChangeRows.next();
            String id = next.getString("fid");
            Date effDate = next.getDate("feffdate");
            Date expDate = next.getDate("fexpdate");
            String changeType = next.getString("fchangetype");
            OrgBizChange orgBizChange = new OrgBizChange(effDate, expDate, changeType);
            Org org = id2Org.get(id);
            if (org == null) continue;
            org.addOrgBizChange(orgBizChange);
        }
        String nameSql = "select fid,feffdate,fexpdate from t_bcm_entitynamerecord where fid in (" + String.join((CharSequence)",", orgId) + ")";
        DataSet nameChangeRows = DB.queryDataSet((String)"queryOrgNameChange", (DBRoute)DBRoute.of((String)"bcm"), (String)nameSql);
        while (nameChangeRows.hasNext()) {
            Row next = nameChangeRows.next();
            String id = next.getString("fid");
            Date effDate = next.getDate("feffdate");
            Date expDate = next.getDate("fexpdate");
            OrgNameChange orgNameChange = new OrgNameChange(effDate, expDate);
            Org org = id2Org.get(id);
            if (org == null) continue;
            org.addOrgNameChange(orgNameChange);
        }
        orgId.clear();
    }

    private Set<Long> getAllModel() {
        LinkedHashSet<Long> ids = new LinkedHashSet<Long>(16);
        String sql = "select fid from T_BCM_MODEL where fid != 0 ";
        DataSet rows = DB.queryDataSet((String)"queryAllModelId", (DBRoute)DBRoute.of((String)"bcm"), (String)sql);
        while (rows.hasNext()) {
            Row next = rows.next();
            Long id = next.getLong("fid");
            ids.add(id);
        }
        return ids;
    }

    static class MergeStructInfo {
        private Long id;
        private String orgNumber;
        private String orgParentNumber;
        private Long yearId;
        private Long periodId;

        public MergeStructInfo(Long id, String orgNumber, String orgParentNumber, Long yearId, Long periodId) {
            this.id = id;
            this.orgNumber = orgNumber;
            this.orgParentNumber = orgParentNumber;
            this.yearId = yearId;
            this.periodId = periodId;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getOrgNumber() {
            return this.orgNumber;
        }

        public void setOrgNumber(String orgNumber) {
            this.orgNumber = orgNumber;
        }

        public String getOrgParentNumber() {
            return this.orgParentNumber;
        }

        public void setOrgParentNumber(String orgParentNumber) {
            this.orgParentNumber = orgParentNumber;
        }

        public Long getYearId() {
            return this.yearId;
        }

        public void setYearId(Long yearId) {
            this.yearId = yearId;
        }

        public Long getPeriodId() {
            return this.periodId;
        }

        public void setPeriodId(Long periodId) {
            this.periodId = periodId;
        }
    }

    static class OrgNameChange {
        private Date effDate;
        private Date expDate;

        public OrgNameChange(Date effDate, Date expDate) {
            this.effDate = effDate;
            this.expDate = expDate;
        }

        public Date getEffDate() {
            return this.effDate;
        }

        public Date getExpDate() {
            return this.expDate;
        }
    }

    static class OrgBizChange {
        private Date effDate;
        private Date expDate;
        private String changeType;

        public OrgBizChange(Date effDate, Date expDate, String changeType) {
            this.effDate = effDate;
            this.expDate = expDate;
            this.changeType = changeType;
        }

        public Date getEffDate() {
            return this.effDate;
        }

        public Date getExpDate() {
            return this.expDate;
        }

        public String getChangeType() {
            return this.changeType;
        }
    }

    static class Org {
        private String id;
        private String number;
        private String parentNumber;
        private Long modelId;
        private List<OrgBizChange> orgBizChanges;
        private List<OrgNameChange> orgNameChanges;

        public Org(String id, String number, Long modelId) {
            this.id = id;
            this.number = number;
            this.modelId = modelId;
        }

        public String getId() {
            return this.id;
        }

        public String getNumber() {
            return this.number;
        }

        public String getParentNumber() {
            return this.parentNumber;
        }

        public void setParentNumber(String parentNumber) {
            this.parentNumber = parentNumber;
        }

        public Long getModelId() {
            return this.modelId;
        }

        public List<OrgBizChange> getOrgBizChanges() {
            return this.orgBizChanges;
        }

        public void addOrgBizChange(OrgBizChange orgBizChange) {
            if (this.orgBizChanges == null) {
                this.orgBizChanges = new ArrayList<OrgBizChange>(16);
            }
            this.orgBizChanges.add(orgBizChange);
        }

        public List<OrgNameChange> getOrgNameChanges() {
            return this.orgNameChanges;
        }

        public void addOrgNameChange(OrgNameChange orgNameChange) {
            if (this.orgNameChanges == null) {
                this.orgNameChanges = new ArrayList<OrgNameChange>(16);
            }
            this.orgNameChanges.add(orgNameChange);
        }
    }

    static class UpgradeDataCache {
        private Set<Long> mergeStructInfoId = new HashSet<Long>(16);
        private Set<String> defSpYChangesType;
        private Map<Long, Set<String>> model2SpYChangesType;
        private Map<Long, List<Org>> model2Org;
        private Map<Long, List<MergeStructInfo>> model2MergeStructInfo;
        private Map<Long, Map<Long, String>> model2PerIdDateMap;
        private Map<Long, Map<Long, String>> model2YearIdMap;
        private List<String> startChanges;
        private List<String> betweenChanges;
        private CountDownLatch latch;

        UpgradeDataCache() {
        }

        public Set<String> getDefSpYChangesType() {
            return this.defSpYChangesType;
        }

        public void setDefSpYChangesType(Set<String> defSpYChangesType) {
            this.defSpYChangesType = defSpYChangesType;
        }

        public Map<Long, Set<String>> getModel2SpYChangesType() {
            return this.model2SpYChangesType;
        }

        public void setModel2SpYChangesType(Map<Long, Set<String>> model2SpYChangesType) {
            this.model2SpYChangesType = model2SpYChangesType;
        }

        public Map<Long, List<Org>> getModel2Org() {
            return this.model2Org;
        }

        public void setModel2Org(Map<Long, List<Org>> model2Org) {
            this.model2Org = model2Org;
        }

        public Map<Long, List<MergeStructInfo>> getModel2MergeStructInfo() {
            return this.model2MergeStructInfo;
        }

        public void setModel2MergeStructInfo(Map<Long, List<MergeStructInfo>> model2MergeStructInfo) {
            this.model2MergeStructInfo = model2MergeStructInfo;
        }

        public Map<Long, Map<Long, String>> getModel2PerIdDateMap() {
            return this.model2PerIdDateMap;
        }

        public void setModel2PerIdDateMap(Map<Long, Map<Long, String>> model2PerIdDateMap) {
            this.model2PerIdDateMap = model2PerIdDateMap;
        }

        public Map<Long, Map<Long, String>> getModel2YearIdMap() {
            return this.model2YearIdMap;
        }

        public void setModel2YearIdMap(Map<Long, Map<Long, String>> model2YearIdMap) {
            this.model2YearIdMap = model2YearIdMap;
        }

        public List<String> getStartChanges() {
            return this.startChanges;
        }

        public void setStartChanges(List<String> startChanges) {
            this.startChanges = startChanges;
        }

        public List<String> getBetweenChanges() {
            return this.betweenChanges;
        }

        public void setBetweenChanges(List<String> betweenChanges) {
            this.betweenChanges = betweenChanges;
        }

        public Set<Long> getMergeStructInfoId() {
            return this.mergeStructInfoId;
        }

        public void setMergeStructInfoId(Set<Long> mergeStructInfoId) {
            this.mergeStructInfoId = mergeStructInfoId;
        }

        public CountDownLatch getLatch() {
            return this.latch;
        }

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }
    }
}

