/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;

public class InvTemplateMcAndIcUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"InvTemplateMcAndIcUpgradeService");){
            try {
                Map<Long, Long> mcnoneMap = this.getMCnoneMap(null);
                Map<Long, Long> icnoneMap = this.getICnoneMap(null);
                this.updataMcnoneIds(mcnoneMap, null);
                this.updataIcnoneIds(icnoneMap, null);
                this.updataPaperMcnoneIds(mcnoneMap, null);
                this.updataPaperIcnoneIds(icnoneMap, null);
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_invelimtplentry set fmycompanyid = 32 where fcbmycompany ='1' and fmycompanyid=0;");
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_invelimtplentry set fintercompanyid = 32 where fcbintercompany ='1' and fintercompanyid=0; ");
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_invelimtplentry set fmycompanyid = 33 where fcbmycompany ='2' and fmycompanyid=0; ");
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_invelimtplentry set fintercompanyid = 33 where fcbintercompany ='2' and fintercompanyid=0;");
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_invsheetrow set fmycompanyid = 32 where fcbmycompany ='1' and fmycompanyid=0;");
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_invsheetrow set fintercompanyid = 32 where fcbintercompany ='1' and fintercompanyid=0;");
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_invsheetrow set fmycompanyid = 33 where fcbmycompany ='2' and fmycompanyid=0;");
                DB.execute((DBRoute)BCMConstant.DBROUTE, (String)"update t_bcm_invsheetrow set fintercompanyid = 33 where fcbintercompany ='2' and fintercompanyid=0;");
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvTemplateRelationTypeUpgradeService error", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("error", e.getMessage()), new Object[0]);
            }
        }
        return super.upgrade();
    }

    private void updataMcnoneIds(Map<Long, Long> mcnoneMap, Long modeId) {
        StringBuilder tmpquerysql = new StringBuilder("select invtpl.fid,invtpl.fmodelid,inventry.fentryid from  t_bcm_invelimtemplate invtpl join t_bcm_invelimtplentry inventry on invtpl.fid=inventry.fid  where fcbmycompany ='3' and fmycompanyid=0");
        if (modeId != null) {
            tmpquerysql.append(" and invtpl.fmodelid= ").append(modeId).append(";");
        }
        String sql = "update t_bcm_invelimtplentry  set fmycompanyid=? where fentryid=? ";
        DataSet dataSet = DB.queryDataSet((String)"select_gettmpData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)tmpquerysql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelid = row.getLong("fmodelid");
            Long fentryid = row.getLong("fentryid");
            Object[] param = new Object[2];
            Optional<Long> optional = Optional.ofNullable(mcnoneMap.get(modelid));
            if (!optional.isPresent()) continue;
            param[0] = optional.get();
            param[1] = fentryid;
            paramsList.add(param);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, paramsList);
            paramsList.clear();
        }
    }

    private void updataPaperMcnoneIds(Map<Long, Long> mcnoneMap, Long modeId) {
        StringBuilder tmpquerysql = new StringBuilder("select invtpl.fid,invtpl.fmodelid,inventry.fentryid from  t_bcm_invsheetentry invtpl join t_bcm_invsheetrow inventry on invtpl.fid=inventry.fid  where fcbmycompany ='3' and fmycompanyid=0 ");
        if (modeId != null) {
            tmpquerysql.append(" and invtpl.fmodelid= ").append(modeId).append(";");
        }
        String sql = "update t_bcm_invsheetrow  set fmycompanyid=? where fentryid=? ";
        DataSet dataSet = DB.queryDataSet((String)"select_gettmpData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)tmpquerysql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelid = row.getLong("fmodelid");
            Long fentryid = row.getLong("fentryid");
            Object[] param = new Object[2];
            Optional<Long> optional = Optional.ofNullable(mcnoneMap.get(modelid));
            if (!optional.isPresent()) continue;
            param[0] = optional.get();
            param[1] = fentryid;
            paramsList.add(param);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, paramsList);
            paramsList.clear();
        }
    }

    private void updataPaperIcnoneIds(Map<Long, Long> icnoneMap, Long modeId) {
        StringBuilder tmpquerysql = new StringBuilder("select invtpl.fid,invtpl.fmodelid,inventry.fentryid from  t_bcm_invsheetentry invtpl join t_bcm_invsheetrow inventry on invtpl.fid=inventry.fid  where fcbintercompany ='3'  and fintercompanyid=0");
        if (modeId != null) {
            tmpquerysql.append(" and invtpl.fmodelid= ").append(modeId).append(";");
        }
        String sql = "update t_bcm_invsheetrow  set fintercompanyid=? where fentryid=? ";
        DataSet dataSet = DB.queryDataSet((String)"select_gettmpData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)tmpquerysql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelid = row.getLong("fmodelid");
            Long fentryid = row.getLong("fentryid");
            Object[] param = new Object[2];
            Optional<Long> optional = Optional.ofNullable(icnoneMap.get(modelid));
            if (!optional.isPresent()) continue;
            param[0] = optional.get();
            param[1] = fentryid;
            paramsList.add(param);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, paramsList);
            paramsList.clear();
        }
    }

    private void updataIcnoneIds(Map<Long, Long> icnoneMap, Long modeId) {
        StringBuilder tmpquerysql = new StringBuilder("select invtpl.fid,invtpl.fmodelid,inventry.fentryid from  t_bcm_invelimtemplate invtpl join t_bcm_invelimtplentry inventry on invtpl.fid=inventry.fid  where fcbintercompany ='3' and fintercompanyid=0");
        if (modeId != null) {
            tmpquerysql.append(" and invtpl.fmodelid= ").append(modeId).append(";");
        }
        String sql = "update t_bcm_invelimtplentry  set fintercompanyid=? where fentryid=? ";
        DataSet dataSet = DB.queryDataSet((String)"select_gettmpData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)tmpquerysql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelid = row.getLong("fmodelid");
            Long fentryid = row.getLong("fentryid");
            Object[] param = new Object[2];
            Optional<Long> optional = Optional.ofNullable(icnoneMap.get(modelid));
            if (!optional.isPresent()) continue;
            param[0] = optional.get();
            param[1] = fentryid;
            paramsList.add(param);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, paramsList);
            paramsList.clear();
        }
    }

    private Map<Long, Long> getMCnoneMap(Long model) {
        StringBuilder typesql = new StringBuilder("select fmodelid,fid,fnumber from t_bcm_structofmycompany where  fnumber='MCNone'");
        if (model != null) {
            typesql.append(" and fmodelid =").append(model).append(";");
        }
        DataSet dataSet = DB.queryDataSet((String)"select_getMcnoneData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)typesql.toString());
        HashMap<Long, Long> typeMap = new HashMap<Long, Long>(16);
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelId = row.getLong("fmodelid");
            Long memberId = row.getLong("fid");
            if (typeMap.containsKey(modelId)) continue;
            typeMap.put(modelId, memberId);
        }
        return typeMap;
    }

    private Map<Long, Long> getICnoneMap(Long model) {
        StringBuilder typesql = new StringBuilder("select fmodelid,fid,fnumber from t_bcm_structoficentity where  fnumber='ICNone'");
        if (model != null) {
            typesql.append(" and fmodelid =").append(model).append(";");
        }
        DataSet dataSet = DB.queryDataSet((String)"select_getIcnoneData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)typesql.toString());
        HashMap<Long, Long> typeMap = new HashMap<Long, Long>(16);
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            Long modelId = row.getLong("fmodelid");
            Long memberId = row.getLong("fid");
            if (typeMap.containsKey(modelId)) continue;
            typeMap.put(modelId, memberId);
        }
        return typeMap;
    }

    public void upgradeByModel(Long model) {
        try (TXHandle tx = TX.required((String)"InvTemplateRelationTypeUpgradeService");){
            try {
                Map<Long, Long> mcnoneMap = this.getMCnoneMap(model);
                Map<Long, Long> icnoneMap = this.getICnoneMap(model);
                this.updataMcnoneIds(mcnoneMap, model);
                this.updataIcnoneIds(icnoneMap, model);
                this.updataPaperMcnoneIds(mcnoneMap, model);
                this.updataPaperIcnoneIds(icnoneMap, model);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvTemplateRelationTypeUpgradeService error", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("error", e.getMessage()), new Object[0]);
            }
        }
    }
}

