/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.BCMConstant;
import org.apache.commons.lang.StringUtils;

public class InvTemplateRelationTypeUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try (TXHandle tx = TX.required((String)"InvTemplateRelationTypeUpgradeService");){
            try {
                Map<Long, Map<String, Long>> invtypeMap = this.getInvtypeMap(null);
                this.updataInvrelatypeIds(invtypeMap, null);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvTemplateRelationTypeUpgradeService error", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("error", e.getMessage()), new Object[0]);
            }
        }
        return super.upgrade();
    }

    private void updataInvrelatypeIds(Map<Long, Map<String, Long>> invtypeMap, Long modeId) {
        StringBuilder tmpquerysql = new StringBuilder("select fid,fmodelid,finvrelatype from  t_bcm_invelimtemplate    where finvrelatypeid=0 ");
        if (modeId != null) {
            tmpquerysql.append(" and fmodelid= ").append(modeId).append(";");
        }
        String sql = "update t_bcm_invelimtemplate  set finvrelatypeid=? where fid=? ";
        DataSet dataSet = DB.queryDataSet((String)"select_gettmpData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)tmpquerysql.toString());
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>();
        while (dataSet != null && dataSet.hasNext()) {
            Row row = dataSet.next();
            String invrelatype = row.getString("finvrelatype");
            if (StringUtils.isBlank((String)invrelatype)) continue;
            Long modelid = row.getLong("fmodelid");
            Long fid = row.getLong("fid");
            Object[] param = new Object[2];
            Optional<Long> optional = Optional.ofNullable(invtypeMap.get(modelid)).map(map -> (Long)map.get(invrelatype));
            if (!optional.isPresent()) continue;
            param[0] = optional.get();
            param[1] = fid;
            paramsList.add(param);
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)BCMConstant.DBROUTE, (String)sql, paramsList);
            paramsList.clear();
        }
    }

    private Map<Long, Map<String, Long>> getInvtypeMap(Long model) {
        StringBuilder typesql = new StringBuilder("select fmodelid,fid,fnumber from t_bcm_invrelatype where fcategorized='0'");
        if (model != null) {
            typesql.append(" and fmodelid =").append(model).append(";");
        }
        DataSet dataSet = DB.queryDataSet((String)"select_getinvralatypetData_000", (DBRoute)DBRoute.of((String)"bcm"), (String)typesql.toString());
        HashMap<Long, Map<String, Long>> invrelatypeMap = new HashMap<Long, Map<String, Long>>(16);
        while (dataSet != null && dataSet.hasNext()) {
            HashMap<String, Long> typeMap;
            Row row = dataSet.next();
            Long modelId = row.getLong("fmodelid");
            Long typeId = row.getLong("fid");
            String typeNumber = row.getString("fnumber");
            if (invrelatypeMap.containsKey(modelId)) {
                typeMap = (HashMap<String, Long>)invrelatypeMap.get(modelId);
                typeMap.put(typeNumber, typeId);
                continue;
            }
            typeMap = new HashMap<String, Long>(16);
            typeMap.put(typeNumber, typeId);
            invrelatypeMap.put(modelId, typeMap);
        }
        return invrelatypeMap;
    }

    public void upgradeByModel(Long model) {
        try (TXHandle tx = TX.required((String)"InvTemplateRelationTypeUpgradeService");){
            try {
                Map<Long, Map<String, Long>> invtypeMap = this.getInvtypeMap(model);
                this.updataInvrelatypeIds(invtypeMap, model);
            }
            catch (Exception e) {
                tx.markRollback();
                this.log.error("InvTemplateRelationTypeUpgradeService error", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("error", e.getMessage()), new Object[0]);
            }
        }
    }
}

