/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.serviceHelper.ConfigServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.util.QFBuilder;

public class InvelimTemplateUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        this.doUpgrade();
        return this.success();
    }

    public void doUpgrade() {
        QFBuilder qf = new QFBuilder();
        qf.add("process", "=", (Object)0L);
        DynamicObject dy = BusinessDataServiceHelper.newDynamicObject((String)"bcm_invelimtemplate");
        DataEntityPropertyCollection properties = dy.getDataEntityType().getProperties();
        if (properties.containsKey((Object)"model") && properties.containsKey((Object)"process") && properties.containsKey((Object)"adjustment")) {
            DynamicObject[] temps = BusinessDataServiceHelper.load((String)"bcm_invelimtemplate", (String)"model,process,adjustment", (QFilter[])qf.toArray());
            ArrayListMultimap model2Temps = ArrayListMultimap.create();
            for (DynamicObject temp : temps) {
                model2Temps.put((Object)temp.getLong("model.id"), (Object)temp);
            }
            qf.clear();
            qf.add("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"EOE", "EJE", "IRpt"}));
            DynamicObject[] processes = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,model,number", (QFilter[])qf.toArray());
            HashBasedTable mnps = HashBasedTable.create();
            for (DynamicObject process : processes) {
                mnps.put((Object)process.getLong("model.id"), (Object)process.getString("number"), (Object)process);
            }
            for (Long modelID : model2Temps.keySet()) {
                boolean cm02 = ConfigServiceHelper.getBoolParam(modelID, "CM02");
                for (DynamicObject temp : model2Temps.get((Object)modelID)) {
                    boolean isGenerate = temp.getBoolean("adjustment");
                    DynamicObject process = this.getProcess(modelID, isGenerate ? "IRpt" : (cm02 ? "EOE" : "EJE"), (Table<Long, String, DynamicObject>)mnps);
                    temp.set("process", (Object)process.getLong("id"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])temps);
        }
    }

    public DynamicObject getProcess(Long modelId, String processNumber, Table<Long, String, DynamicObject> mnps) {
        return (DynamicObject)mnps.get((Object)modelId, (Object)processNumber);
    }
}

