/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.AbstractUpgradeService;
import kd.fi.bcm.business.upgrade.UpgradeContext;
import kd.fi.bcm.common.enums.StorageTypeEnum;

public class InvlimTempUpgradeService
extends AbstractUpgradeService {
    DynamicObject[] dys;

    public InvlimTempUpgradeService(List<String> parentNumber, String number, LocaleString name, UpgradeContext context) {
        super(parentNumber, number, name, context);
    }

    @Override
    public void readyUpgradeData() {
        String properties = "adjustment,process,invelimtplentry,invelimtplentry.audittrail,invelimtplentry.ruleexprsource";
        QFilter filter = new QFilter("model.id", "=", (Object)this.context.getModelId());
        this.dys = BusinessDataServiceHelper.load((String)"bcm_invelimtemplate", (String)properties, (QFilter[])new QFilter[]{filter});
        QFilter filter2 = new QFilter("storagetype", "!=", (Object)StorageTypeEnum.SHARE.getOIndex());
        QFilter atFilter = new QFilter("number", "=", (Object)"AutoJournal");
        DynamicObject atDy = BusinessDataServiceHelper.loadSingle((String)"bcm_audittrialmembertree", (String)"id,number", (QFilter[])new QFilter[]{filter, atFilter, filter2});
        QFilter bpFilter = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"EOE", "EJE", "ERAdj"}));
        DynamicObject[] bpDys = BusinessDataServiceHelper.load((String)"bcm_processmembertree", (String)"id,number", (QFilter[])new QFilter[]{filter, bpFilter, filter2});
        HashMap<String, DynamicObject> num2BpDy = new HashMap<String, DynamicObject>(4);
        for (DynamicObject bpDy : bpDys) {
            num2BpDy.put(bpDy.getString("number"), bpDy);
        }
        for (DynamicObject dy : this.dys) {
            DynamicObjectCollection invelimtplentry = dy.getDynamicObjectCollection("invelimtplentry");
            boolean isAdj = dy.getBoolean("adjustment");
            if (isAdj) {
                DynamicObject eradj = (DynamicObject)num2BpDy.get("ERAdj");
                if (eradj != null) {
                    dy.set("process", (Object)eradj);
                }
            } else {
                DynamicObject eoe = (DynamicObject)num2BpDy.get("EOE");
                if (eoe != null) {
                    dy.set("process", (Object)eoe);
                } else {
                    DynamicObject eje = (DynamicObject)num2BpDy.get("EJE");
                    if (eje != null) {
                        dy.set("process", (Object)eje);
                    }
                }
            }
            for (DynamicObject entry : invelimtplentry) {
                if (atDy == null) continue;
                entry.set("audittrail", (Object)atDy);
            }
        }
    }

    @Override
    protected void saveData() {
        SaveServiceHelper.save((DynamicObject[])this.dys);
    }
}

