/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;

public class InvrelationUpgradeService
extends BcmUpgradeService {
    @Override
    public Map<String, Object> upgrade() {
        try {
            Set<Long> modelids = this.getAllModel();
            int lmt = 100;
            List<Set<Long>> mdidsgrp = this.getGroupList(modelids, lmt);
            for (Set<Long> ids : mdidsgrp) {
                DynamicObject[] datas = this.getInvrelation(ids);
                if (datas.length <= 0) continue;
                for (DynamicObject dyn : datas) {
                    boolean ismodified = dyn.getBoolean("ismodified");
                    BigDecimal confirmScale = dyn.getBigDecimal("confirmscale");
                    BigDecimal equvscale = dyn.getBigDecimal("equvscale");
                    if (ismodified) continue;
                    if (equvscale == null) {
                        equvscale = BigDecimal.ZERO;
                    }
                    dyn.set("ismodified", (Object)(equvscale.compareTo(confirmScale) != 0 ? 1 : 0));
                }
                SaveServiceHelper.save((DynamicObject[])datas);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.success();
    }

    private Set<Long> getAllModel() {
        QFilter qf = new QFilter("1", "=", (Object)1);
        DynamicObjectCollection models = QueryServiceHelper.query((String)"bcm_model", (String)"id", (QFilter[])qf.toArray());
        Set<Long> ids = models.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        models.clear();
        return ids;
    }

    private DynamicObject[] getInvrelation(Set<Long> modelids) {
        String[] invrelatypes = new String[]{"1", "3"};
        QFilter qf = new QFilter("invrelatype", "in", (Object)invrelatypes);
        qf.and("model", "in", modelids);
        String selector = "id,invrelatype,confirmscale,minconfirmscale,equvscale,ismodified";
        return BusinessDataServiceHelper.load((String)"bcm_invrelation", (String)selector, (QFilter[])qf.toArray());
    }

    private List<Set<Long>> getGroupList(Set<Long> ids, int lmt) {
        int sz = ids.size();
        int num = sz / lmt;
        num = sz % lmt == 0 ? num : num + 1;
        List<Set<Long>> splitList = ((Stream)Stream.iterate(0, n -> n + 1).limit(num).parallel()).map(a -> ((Stream)ids.stream().skip(a * lmt).limit(lmt).parallel()).collect(Collectors.toSet())).collect(Collectors.toList());
        return splitList;
    }
}

