/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.bcm.business.upgrade;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.fi.bcm.business.upgrade.BcmUpgradeService;
import kd.fi.bcm.common.log.BcmLogFactory;
import kd.fi.bcm.common.log.WatchLogger;
import kd.fi.bcm.common.util.GlobalIdUtil;

public class LinkAdjustScenarioUpgradeService
extends BcmUpgradeService {
    protected static WatchLogger logger = BcmLogFactory.getWatchLogInstance(LinkAdjustScenarioUpgradeService.class);

    @Override
    public Map<String, Object> upgrade() {
        try {
            this.updateLinkAdjustTmplScenario(null);
        }
        catch (Exception e) {
            logger.error("\u5347\u7ea7\u9002\u7528\u60c5\u666f\u5931\u8d25", (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
        return super.upgrade();
    }

    public void updateByModelId(long newModelId) {
        try {
            this.updateLinkAdjustTmplScenario(newModelId);
        }
        catch (Exception e) {
            logger.error("\u5347\u7ea7\u9002\u7528\u60c5\u666f\u5931\u8d25\uff0cnewModelId=" + newModelId, (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", e.getMessage()), new Object[0]);
        }
    }

    private void updateLinkAdjustTmplScenario(Long modelId) {
        String sql = "select a.fid as fid ,a.fscenarioid as fscenarioid from t_bcm_linkage a left join t_bcm_applyscenarioconfig b on a.fid = b.fid where b.fid  is  null ";
        if (modelId != null) {
            sql = sql + " and a.fmodelid = " + modelId;
        }
        DataSet ds = DB.queryDataSet((String)"find_linkadjustscenario_data", (DBRoute)DBRoute.of((String)"bcm"), (String)sql, null);
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        while (ds != null && ds.hasNext()) {
            Row row = ds.next();
            paramList.add(new Object[]{row.getLong("fid"), GlobalIdUtil.genGlobalLongId(), 1, row.getLong("fscenarioid"), "10", "0"});
        }
        if (paramList.size() > 0) {
            String insertSql = "INSERT INTO t_bcm_applyscenarioconfig (fid,fentryid,fseq,fscenarioid,fscope,fisexcept) VALUES (?,?,?,?,?,?)";
            DB.executeBatch((DBRoute)DBRoute.of((String)"bcm"), (String)insertSql, paramList);
        }
    }
}

